<!--
AAMfP: a simple personal kanban metrics spreadsheet

Copyright (C)  2019-2020  Marco Bresciani.

Copying and distribution of this file, with or without modification, are
permitted in any medium without royalty provided the copyright notice
and this notice are preserved.  This file is offered as-is, without any
warranty.

SPDX-FileCopyrightText: 2019-2020 Marco Bresciani

SPDX-License-Identifier: FSFAP
-->
# Changelog
All notable changes to this project will be documented in this file.
```
 ,' ,-_-. '.
((_/)o o(\_))
 `-'(. .)`-'
     \_/

Copyright (C)  2019-2020  Marco Bresciani.

Copying and distribution of this file, with or without modification, are
permitted in any medium without royalty provided the copyright notice
and this notice are preserved.  This file is offered as-is, without any
warranty.
```
The format is based on [Keep a
Changelog](https://keepachangelog.com/en/1.0.0/), and this project
adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

If you want to periodically contribute to this project for its
development and improvement, please
[![Donate using Liberapay](https://liberapay.com/assets/widgets/donate.svg)](https://liberapay.com/marcoXBresciani/donate).
At the moment, this project
![](http://img.shields.io/liberapay/receives/marcoXbresciani.svg?logo=liberapay&style=plastic)
by
![Liberapay patrons](https://img.shields.io/liberapay/patrons/marcoXbresciani?style=plastic).

## [Unreleased]
### Added
* Introducing CLT (Customer Lead Time) metric to better highlight the
  possible differences between the LT from commitment and the lead time
  the end customer has to actually wait, also including backlog
  wait in queue.
* [Usage Hints](README.md#Usage-Hints) section added to better explain
  how to manage charts and their radiating information.
### Changed
### Deprecated
### Removed
### Fixed
### Security

## v.[15.1.2] - 2020-02-28
### Added
* Introducing [REUSE](https://reuse.software/) recommendations for an
  easier licensing management.
  The project itself should already be REUSE-compliant.
  REUSE tool bug 99 (see https://github.com/fsfe/reuse-tool/issues/99),
  for which there's still no solution, describes the `.hg` folder as not
  compliant, but it should actually be ignored by the tool.
* All previous releases have now been copied to Savannah Downloads page.
### Changed
* Licenses are moved to a LICENSES folder in order to fulfil
  [REUSE](https://reuse.software/) recommendations.
### Removed
* Removed licenses in ODF format.

## v.[15.1.1] - 2019-10-21
### Changed
* Introducing the *Standard Readme Style* from
  https://github.com/RichardLitt/standard-readme.
### Fixed
* Fit GPLv3 notice in board column

## v.[15.1.0] - 2019-09-24
### Added
* New Liberapay account for possible recurring donations.
  All donations will be exclusively used for this project purpose.
  For example: buying (e)books or (e)courses on LibreOffice programming
  or  statistics and metrics; if enough, for a domain name, ...
  If you want to periodically contribute to this project for its
  development and improvement, please
  [![Donate using Liberapay](https://liberapay.com/assets/widgets/donate.svg)](https://liberapay.com/marcoXBresciani/donate)
  At the moment, this project
  ![](http://img.shields.io/liberapay/receives/marcoXbresciani.svg?logo=liberapay).
* New *Backlog Control Chart* in *CFD* dashboard sheet: it shows the
  main overall values of the matching Weibull distribution for
  **Backlog** age data: mean, variance, median, mode and also add UCL
  and LCL values for such distribution.
* New *Lead Times Control Chart* in *Lead Time* dashboard sheet: it
  shows the main overall values of the matching Weibull distribution for
  **LT** data: mean, variance, median, mode and also add UCL and LCL
  values for such distribution.
* New *Age of WIP* chart in *CFD* dashboard sheet: it shows the
  age of current work items.
* *UCL* (Upper Control Limit) and *LCL (Lower Control Limit) for **LT**,
  **Backlog** and **Throughput** distributions, in
  [Distribution](README.md#Distribution) sheet, computed according to
  [On the Practically Useful Properties of the Weibull
  Distribution](https://connected-knowledge.com/2013/08/01/on-the-practically-useful-properties-of-the-weibull-distribution/)
  by Alexei Zheglov.
### Changed
* **Done** column in *Data* sheet now shows the actual open count, not
  the cumulative.
* **Backlog** column in *Data* sheet now shows the actual open count,
  not the cumulative.
* **DR** and **Thr* columns in *Data* sheet reworked following **Done**
  changes.
* Charts resized to 16×9 (and 9×9) from 20×10 (and 10×10).
### Removed
* Age data removed from *Lead Times Scatterplot* chart.
### Fixed
* [sr #110025](https://savannah.nongnu.org/support/index.php?110025)
  Wrong mArrival calculation.

## [v.15.0.0 '酒田'] - 2019-09-19
### Added
* GNU Free Documentation License full text added to the
  [USAGE.md](USAGE.md) file.
* GNU GPLv3 logo added in spreadhseet.
* Freedom Defined logo added in spreadsheet.
### Changed
* GNU Unifont replaced with GNU FreeFont in both board and spreadsheet.
* New shape for WIP box in printable kanban board: from pentagon to
  scroll.
* Updated charts in [Little's Law](#Little's-Law) sheet: they are now
  properly drawn as line charts.
* New colour for **AALT** value in *Approximate Average Lead Time*
  chart: the value it's now tracked with lilac.
* Updated *Flow Efficiency* chart: it now remains properly drawn even if
  work items are not correctly sorted.
* Updated *Daily Run Chart* chart: changed chart type, no visual
  difference.
* The reference to bug
  [#1](https://web.archive.org/web/20190918131734/https://bitbucket.org/marcobresciani/aamfp/issues/1/wrong-cfd-counting)
  has been moved to [Internet Archive Wayback
  Machine](https://web.archive.org/) instead of the official BitBucket
  repository that I will soon remove.
### Removed
* copyright.md file removed, content moved to [README.md](README.md).
### Fixed
* error and wrong GNU FDL link in the CHANGELOG for v.14.0.0 'Savannah'.
* [sr #109986](https://savannah.nongnu.org/support/index.php?109986)
  Computation error in mFE.
* [sr #109987](https://savannah.nongnu.org/support/index.php?109987)
  Computation error in Impact.
* [sr #109988](https://savannah.nongnu.org/support/index.php?109988)
  Computation error in Likelihood.

## [v.14.0.0 'Savannah'] - 2019-08-27
### Added
* Added [GNU General Public License](COPYING) Version 3 both in plain
  text and [Markdown](gpl-3.0.md) formats.
* Added [GNU Free Documentation License](fdl-1.3.md) Version 1.3 in
  Markdown format.
### Changed
* The AAMfP spreadsheet itself, is now licensed under the GNU General
  Public license version 3.0.
* The kanban board both ODG and PDF formats are now licensed under the
  GNU Free Documentation License version 1.3.
* All associated documentations files of the project are now licensed
  under the GNU All-Permissive License.
### Removed
* Removed the [Contributor Covenant Code of
  Conduct](CODE_OF_CONDUCT.md]).
### Fixed
* Solved bug #19 about average Flow Efficiency (mFE) of all completed
  work items.
* Solved bug #20 about averages computations from row 3 instead of 2.

## [v.13.2.0] - 2019-08-21
### Added
* New *Throughputs Distribution* in [Lead
  Time](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Lead%20Time)
  dashboard.
* New *Throughput Run Chart* in [Lead
  Time](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Lead%20Time)
  dashboard.
### Changed
* Data sets and tables updated to 3652 elements, corresponding to ten
  average Gregorian years (see
  https://www.wolframalpha.com/input/?i=10+average+gregorian+years).
* Updated Unifont version to 12.1.03.
* Charts resized to 20x10cm or 10x10cm.
* The *WIP Run Chart* has been moved from [Little's
  Law](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Little's%20Law)
  to [Lead
  Time](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Lead%20Time)
  dashboard.
  The *Approximate Average Lead Time* has been moved from [Lead
  Time](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Lead%20Time)
  to [Little's
  Law](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Little's%20Law)
  dashboard.
* The *Little's Law (7 days)* chart has been resized to double width.
### Fixed
* Minor changes to
  [ReadMe](https://bitbucket.org/marcobresciani/aamfp/src/tip/README.md);
* *Lead Times Detail* chart in [Lead
  Time](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Lead%20Time)
  dashboard limited to 42 work items.
* Conditional formatting for **Deadline** colouring in
  [WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems)
  sheet.

## [v.13.1.3] - 2019-05-24
### Added
* Clarification on formulas and charts data, to highlight the fact that
  almost all sheets and charts are already able to manage ten years of
  data.
* URLs reference to GNU Unifont and Unifoundry.com with font version
  number currently used.
### Changed
* Clarified, in
  [Usage](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md)
  the concept difference between discarded and aborted, for work items.

## [v.13.1.2] - 2019-05-17
### Changed
* Review of the WIP area shape in the kanban board.
* Free Cultural Works official recommendation icon to the kanban board.
  See https://freedomdefined.org/Logos_and_buttons#AMYMADE.27s_buttons.
  Now comes in yellow.
### Fixed
* Update of GNU Unifont copyright notice to version 12.0.1 of the font.

## [v.13.1.0] - 2019-05-15
### Added
* Red colour background highlight in Data sheet for saturdays and
  sundays.
  Current day in red colour.
### Removed
* Removed 63p or, better, the (1 - 1/e) percentile, that is something
  like 63,21% and is a common easy approximation of the scale parameter
  (λ) of the Weibull distribution: see [How to Match to Weibull
  Distribution without
  Excel](https://connected-knowledge.com/2014/09/08/how-to-match-to-weibull-distribution-without-excel/)
  by Alexei Zheglov.
### Fixed
* Minor errors in WorkItems sheet with respect to dates.

## [v.13.0.0 'GSB84'] - 2019-04-18
### Added
* References about **[Kanban One](https://www.kanbanone.com)**.
* *Backlog Age Distribution* chart in
  [Distribution](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Distribution)
  sheet.
* New [CFD](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#CFD)
  dashboard sheet with CFD-related charts moved here: *Cumulative Flow
  Diagram*, *Daily Run Chart*, *Backlog Age Distribution*, *CoS Ratio*,
  *Flow Efficiency*.
* New [Lead Time](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Lead%20Time)
  dashboard sheet with Lead Time-related charts moved here: *Lead Times
  Scatterplot*, *Lead Times Distribution*, *Lead Times Detail*,
  *Approximate Average Lead Time*.
* New [Little's Law](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Little's%20Law)
  dashboard sheet with Little's Law-related charts moved here: *Little's
  Law*, *Little's Law (7 days)*, *I/O Speed*, *WIP Run Chart*,
  *Blockers*, *Effort Run Chart*.
* Added 63p or, better, the (1 - 1/e) percentile, that is something like
  63,21% and is a common easy approximation of the scale parameter (λ)
  of the Weibull distribution: see [How to Match to Weibull Distribution
  without Excel](https://connected-knowledge.com/2014/09/08/how-to-match-to-weibull-distribution-without-excel/)
  by Alexei Zheglov.
* Added mean, variance, median and mode for the **Weibull(LT)** and
  **Weibull(Backlog)** distributions.
### Changed
* New name for *Activities* sheet, now called
  [WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems).
  The word *activity* has been replaced in favour of *work item*, to
  better highlight the use of the **WIT** classification;
* New ordering of sheets: [Notes](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Notes),
  [WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems),
  [CFD](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#CFD)
  (charts dashboard), [Lead Time](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Lead%20Time)
  (charts dashboard), [Little's Law](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Little's%20Law)
  (charts dashboard), [Metrics](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Metrics),
  [Distribution](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Distribution),
  [Data](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#Data).
* Review of text contents
  ([Usage](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md),
  [ReadMe](https://bitbucket.org/marcobresciani/aamfp/src/tip/README.md))
  to use the same naming conventions: [Sheet](#Sheet), *chart*,
  **Value**/**Column**.
* Renamed **Actual Effort** as **Computed Effort**.
* Review of work items data to have something more generic.
  But still not (yet) satisfied.
* New background colour for informational columns (CoS, WIT, Blocked
  Days, Deleted, and Labels) in
  [WorkItems](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md?fileviewer=file-view-default#WorkItems)
  sheet.
### Removed
* *Charts*, *CFD*, *Scatterplot*, *StackedLT* older sheets.

## [v.12.0.0 'Medhelan'] - 2019-03-01
### Added
* Simple "codename" for each release, together with the version number.
  All major versions will have a codename.
* Daily throughput value and run chart.
* Email contact address added to code of conduct.
* Commented copyright notice added to all Markdown files.
* Visible copyright notice added to where it was missing in the Markdown
  files.
### Fixed
* Solve bug #15.
  Error in computing outgoing rate value.
* Solve bug #16.
  Use "Delivery Rate" instead of "Throughput".
* Solve bug #17.
  Error in computing mLT value.

## [v.11.0.7] - 2019-02-19
### Added
* Copyright notes added also as file properties.
* Added Free Cultural Works official recommendation icon to the kanban
  board.
  See https://freedomdefined.org/Logos_and_buttons#AMYMADE.27s_buttons.
### Changed
* Small Creative Commons icon on the kanban board has been replaced with
  the 88x31 pixels icon.

## [v.11.0.6] - 2019-02-15
### Changed
* Few minor improvements and modifications to the sheets (few dates,
  corrected chart colours).

## [v.11.0.5] - 2019-01-28
### Added
* Reference to **AAMfP_**
  (ring:2e5e3ab18b487d096464ed0a0b2c2af468a8838a) user on the [GNU
  Jami](https://jami.net) (former [GNU Ring](https://ring.cx), former
  SFLphone) distributed communication platform for further Q&A and
  contact needs.

## [v.11.0.4] - 2019-01-25
### Added
* Reference to [@AAMfP@fosstodon.org](https://fosstodon.org/@AAMfP)
  user on [Mastodon](https://en.wikipedia.org/wiki/Mastodon_(software)
  federated social netowrk for all Q&A and contact needs.
### Changed
* Lock of charts position and dimension to improve usability and reduce
  errors

## [v.11.0.2] - 2019-01-14
### Added
* CC logo for "Free Cultural Works".
### Changed
* Updated
  [Usage](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md)
  to reflect latest improvements.

## [v.11.0.1] - 2019-01-12
### Changed
* Better logic for sample data construction.
* New layout and colouring for *Charts* sheet.
  Now each like keeps its unique colour and style through the sheet.
### Fixed
* Better formula for expired deadlines in *Activities* sheet.

## [v.11.0.0] - 2019-01-08
### Added
* MAJOR: add
  [Usage](https://bitbucket.org/marcobresciani/aamfp/src/tip/USAGE.md)
  file, now distributed together instead of an online wiki page.
* MAJOR: add
  [Changelog](https://bitbucket.org/marcobresciani/aamfp/src/tip/CHANGELOG.md)
  file, now distributed together instead of an online wiki page.
* MINOR: add lead time stacked bar chart.
* MINOR: pie chart representing CoS ratios using colors defined in the
  [Kanban](https://leankanban.com/shop/kanban-book/) book.
* MINOR: introduce "Keep a Changelog" format for
  [Changelog](CHANGELOG.md) file.
### Changed
* MAJOR: Content of all sheets now better fitted to modern widescreens,
  now at 1920×1080.
* MINOR: Represent ongoing activities with an asterisk (instead of a
  circle) in scatterplot to distiguish also through shapes with respect
  to completed activities.

## [v.10.2.5-beta] - 2019-01-04
### Changed
* PATCH: Use proper copyright notice for Unifont.

## [v.10.2.4-beta] - 2019-01-03
### Changed
* PATCH: small rework of the kanban board Draw/PDF, introducing Unifont.
### Fixed
* PATCH: Fix #13

## [v.10.2.2-beta] - 2019-01-02
### Changed
* PATCH: add the original Code of Conduct.

## [v.10.2.1-beta] - 2018-12-18
### Changed
* PATCH: update the layout of the kanban board.

## [v.10.2.0-beta] - 2018-11-14
### Added
* MINOR: add lead time stacked bar chart.

## [v.10.1.1] - 2018-11-10
### Changed
* PATCH: Rework Activities samples to have more dynamic sample data.

## [v.10.1.0] - 2018-10-20
### Changed
* MINOR: improve A3 board with WIP placeholder and Lead Time highlight.

## [v.10.0.0] - 2018-07-10
### Added
* MAJOR: add Contributor Covenant Code of Conduct for possible
  contributors.

## [v. 9.5.0] - 2018-07-09
### Changed
* MINOR: improve Deadline column highlight showing all expired deadlines
  with respect to current date.

## [v. 9.4.1] - 2018-07-09
### Changed
* PATCH: unlock all previously locked sheets (easier to manage all
  updates and versioning)

## [v. 9.4.0] - 2018-07-09
### Added
* MINOR: add "Labels" column to follow ActionableAgile™ Analitycs tool
  DEMO source data, so providing more filtering opportunities.

## [v. 9.3.2] - 2018-06-26
### Changed
* PATCH: blocks top rows for Activities, Metrics and Data sheets.
* PATCH: blocks modifications on all sheets (except Activities) with
  empty password, to simply highlight the fact that Activities should be
  the only read/write sheet.
  Feel free to unlock the sheets if you prefer.

## [v. 9.3.0] - 2018-06-12
### Added
* Add daily WIP and backlog run chart.
### Fixed
* Solve issue #10.

## [v. 9.2.1] - 2018-06-12
### Fixed
* Solve issue #9.
  Rename sheets with single word names.

## [v. 9.2.0] - 2018-06-01
### Added
* Add Impact and Likelihood metrics as described in *Kanban Maturity
  Model* book.

## [v. 9.0.1] - 2018-05-31
### Added
* Add percentile colouring for Lead Times column showing which reference
  percentile has been passed.

## [v. 9.0.0] - 2018-05-25
### Added
* "Distribution" sheet added.
### Changed
* Reworked "LT Data" sheet,
* "Flow Efficiency" sheet deleted.
### Fixed
* Solve bug #5.
  Add "Effort" evaluation for single activity.

## [v. 8.0.1] - 2018-05-24
### Fixed
* Solve bug #4.
  Rename columns to better fit KMM book.

## [v. 8.0.0] - 2018-05-21
### Added
* Plus add Links column.
### Fixed
* Solve bugs #2 and #3.

## [v. 7.2.1] - 2018-05-20
### Fixed
* Bug #1 solved in the CFD.
  Now the column "Date" of the CFD Data starts from the min - 1 day.

## [v. 7.2.0] - 2018-05-11
### Added
 * Add "Age" to scatterplot to represent deleted or WIP activities
   current LT.
 * Add "mLT" to scatterplot.
### Changed
* Ricalcolo medie Little.
* Grafico CFD fatto da cumulativo ("Dati CFD").
* English translation.
* Moving back basic statistics to "LT Data" folder in order to keep
  better compatibility with ActionableAgile™ Analitycs tool.
* Moving basic statistics to "Activities" folder making easier filtering
  scatterplot by CoS (or whatever).
### Fixed
* Dati CFD da min(*) altrimenti i conti non tornano.

## [v.3.0.0] - 2017-08-05
### Changed
* Rinominata "Opzioni" in "Backlog" per compatibilità col formato di
  ActionableAgile™ Analitycs.

## [v.2.1.0] - 2017-08-05

## [v.2.0.0] - 2017-08-05
### Added
* CoS filtrate per classi standard.
* Pagina dati efficienza (Flow Efficiency).
* Formattazione automatica per Scadenza.
* Formattazione automatica per attività chiuse in ritardo.
### Changed
* Arrotondamento (giorno) intero percentili e media.|
* Massimo dell'ascissa dei grafici a massimo "Fatto", non più assoluto.
* Dati CFD da min("Fatto") invece che da min(*).
### Removed
* Rimosso il vincolo di inizio delle ascisse.
### Fixed
* Correzione calcolo throughput.

## [v.1.0.0] - 2017-06-10
### Changed
* Moved computed data to "LT Data" sheet.
* Renamed "Work Items" sheet as "Tasks".
* Splitting LT and Age columns.
* Added small Age chart.
* Added this History page.

## [Excel v.0.0.1] - 2017-06-10
### Added
* First Microsoft Excel version.

## v0.0.1 - 2017-06-05
### Added
* First version.

[Unreleased]: http://hg.savannah.nongnu.org/hgweb/aamfp/file/tip
[15.1.1]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/c4d49a1acfde
[15.1.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/225a0e18eb80
[v.15.0.0 '酒田']: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/225a0e18eb80
[v.14.0.0 'Savannah']: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/bcfb27c5208e
[v.13.2.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/e918c0958776
[v.13.1.3]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/03040583a685
[v.13.1.2]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/c789317359a0
[v.13.1.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/04aa8ec2c033
[v.13.0.0 'GSB84']: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/1fda23bc0601
[v.12.0.0 'Medhelan']: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/ea6cc3110d16
[v.11.0.7]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/431dc22b6197
[v.11.0.6]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/3c4e541822b5
[v.11.0.5]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/dc43cc5d2d4c
[v.11.0.4]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/9bdc3bf121fa
[v.11.0.2]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/a322fee747be
[v.11.0.1]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/728edf6352cb
[v.11.0.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/56264b508de5
[v.10.2.5-beta]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/1b9858126444
[v.10.2.4-beta]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/6ed9ff4319d5
[v.10.2.2-beta]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/d5ba145ae9de
[v.10.2.1-beta]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/0120e71d867d
[v.10.2.0-beta]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/cdfe02407f2d
[v.10.1.1]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/811e373395fc
[v.10.1.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/5beeac958dc1
[v.10.0.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/7135208ea782
[v. 9.5.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/dd3471ed8f4c
[v. 9.4.1]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/7373819ce17e
[v. 9.4.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/10004120b96b
[v. 9.3.2]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/bb1b283cb0a7
[v. 9.3.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/1add52fe57ea
[v. 9.2.1]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/83450e1da23a
[v. 9.2.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/f2ceab4cc345
[v. 9.0.1]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/bec40ceba0b2
[v. 9.0.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/7bf45eca9d2d
[v. 8.0.1]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/2b5b94e1acf9
[v. 8.0.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/cf3776091c03
[v. 7.2.1]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/d06c0a626250
[v. 7.2.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/211fa0b9f2b7
[v. 7.0.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/1bdd52f47e1b
[v.3.0.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/1de39c2c6150
[v.2.1.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/42d233e85d5b
[v.2.0.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/40914f5090ee
[v.1.0.0]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/cce3de80ac79
[Excel v.0.0.1]: http://hg.savannah.nongnu.org/hgweb/aamfp/rev/7f6631b4db1b
