<!--
© 2019 Marco Bresciani.

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or
any later version published by the Free Software Foundation; with no
Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts. A
copy of the license is included in the section entitled "GNU Free
Documentation License".

SPDX-FileCopyrightText: 2019 Marco Bresciani

SPDX-License-Identifier: GFDL-1.3-or-later
-->
# Usage
```
 ,' ,-_-. '.
((_/)o o(\_))
 `-'(. .)`-'
     \_/

© 2019 Marco Bresciani.

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.3 or
any later version published by the Free Software Foundation; with no
Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.
A copy of the license is included in the section entitled "GNU Free
Documentation License".
```
The whole spreadsheet, in LibreOffice Calc format, contains these
sheets:
* [Notes](#notes)
* [WorkItems](#workitems)
* [CFD](#cfd)
* [Lead Time](#lead-time)
* [Little's Law](#littles-law)
* [Metrics](#metrics)
* [Distribution](#distribution)
* [Data](#data)

and it can be modified and used following the [GNU General Public
License (GNU GPL)](https://www.gnu.org/licenses/gpl.html).

For daily normal use, [WorkItems](#workitems) should be the only sheet
you need to work on, while all other sheets are there to compute your
metrics and show them.
There are no hidden sheets nor password-protected cells.
The whole spreadsheet is completely available for you, following the
license terms.

Please note that [WorkItems](#workitems) sheet already contains some
data.
Those are sample data to show you how to use and write them.
Feel free to remove (or overwrite) them.

## Notes
The [Notes](#notes) sheet is just a sort of cover page for the whole
spreadsheet with licensing notes, and the version number of the release,
for reference.

## WorkItems
For daily usage purposes, [WorkItems](#workitems) is the only sheet you
might need to work on and modify, by adding your own work items' data.

The whole [WorkItems](#workitems) sheet is compatible with [Actionable
Agile™ Analytics](https://www.actionableagile.com/) tool (see [Format
for Data File](https://www.actionableagile.com/format-data-file/)):
simply export [WorkItems](#workitems) sheet as CSV (select comma
<`,`> as cell separator and quotes <`"`> for fields) and then
import it in the tool.

As described in the [Format for Data
File](https://www.actionableagile.com/format-data-file/) page, the first
row contains the column names for each of the data fields.
* The first column is an item **ID** field.
* The second column is optional, and it's the **Link** to the item
  location in your online Kanban/Agile/PM tool, if any.
  If not used, the whole column could be hidden or removed.
* The third column is optional (but I strongly suggest using it), and
  it's the item **Name** (or title or description) field.

The next set of contiguous columns are the sequential steps of your
workflow.
Due to the basic needs of Personal Kanban concepts, they have been set
(and fixed) to **Backlog**, **Next**, **In-progress** and **Done**.
The contents of these columns are the date the item entered each
workflow step.

For standardization purposes, the spreadsheet displays the dates in
ISO8601 format (`yyyy-mm-dd`) but can be entered in your local format
(e.g.: `dd/mm/yyyy` or whatever), as configured in LibreOffice Calc.

The **Backlog** column contains the date when the work item appears,
when you had a new idea, a new task appears, or anyway when something
potentially doable appears in your work system.

The **Next** column represents the date when the person/entity that
asked for the work commits on it or when you decide that the work has
to be done.
For example: you may have an idea for a very good book, but this does
not mean that you actually have to write it.
Unless you firmly decide to write it.
This is  called *Commitment point*, the point in a kanban system at
which we make the commitment to deliver a work item.
Before this point, work done supports the decision whether to deliver
the item.
After this point, it has been confirmed that the customer wants and will
take delivery of the item, and that the service will deliver it.

The **In-progress** column contains the date when you have started
working on the work item activity.

The **Done** column contains the date when the result of the work item
activity has been delivered/provided to the person/entity that asked for
it.

These above are the mandatory columns for metrics.
There are also optional columns that may help identify and categorize
work items and their information:

* **CoS** is the Class of Service of the work item, and it could help
  differentiate items based on their Cost of Delay.
  Each class of service has a specific execution policy that the service
  provider agrees to follow.
  Those following are the basic standard classes of service defined in
  [Kanban](https://leankanban.com/shop/kanban-book/) book and predefined
  as available in this sheet.
  If you need other classes of service, feel free to modify the sheet
  according to the license above.
  Traditional Classes of Service can be described as:
    * *Expedite*, has an unacceptable cost of delay and therefore
      requires immediate attention.
      It can be pulled into development, even in violation of current
      WIP limits (even if it shouldn't be).
      > Typically, there can be only one expedite item in the system at
        a time, and teams may set a policy to swarm on that item to make
        sure it moves through the system rapidly.
    * *Fixed date*, describes work items that must be delivered on or
      before a specific date.
      > Typically, the cost of delay of these items is nonlinear and is
        highly sensitive to small changes in the delivery date; these
        must be actively managed to mitigate the schedule risk.
        Therefore, these items are pulled into development when
        necessary to be finished on time.
        Some items may require additional analysis to refine the
        expected lead time.
        Some need to be reclassified as expedite if the team falls
        behind.
    * *Standard*, represents the baseline class of service, applicable
      to work items that are neither expedited nor fixed date.
      Most backlog items should fall into this category.
      > The cost of delay is linear for standard items, meaning that
        value cannot be achieved until delivery occurs, but there's no
        fixed-date requirement.
    * *Intangible* is used for work that goes through the system that
      doesn't directly deliver value to the customer.
      > This is work that needs to be done - but for which it is hard to
        show a return on investment.
        It is a good idea to have some Intangible work going through the
        system.
        It is better to set this aside when an Expedite comes through
        then work with an associated due date or cycle time expectation.

  *NOTE*: As said, this column is optional but if you don't use it and
  you need to make the exported sheet properly compatible with
  [Actionable Agile™ Analytics](https://www.actionableagile.com/) tool,
  I suggest setting it to *Standard* (or, actually, any other value), so
  to not let this column being empty so causing an error while loading
  by the tool.

* **WIT** is the type of the work item (Work Item Type), and it could
  help categorize items based on your ideas, needs and concepts.
  Each work item type is specific for the person or team or group using
  it and for which it has a specific meaning.
  Some examples can be: "work", "home", "children", "taxes" or whatever
  category or main argument you may want using to aggregate items
  information and types.
  There are no pre-defined WITs in this sheet.

* **Deadline** is usually used for Fixed Date CoS only, and it
  represents the date before which the item shall be completed.
  The column value is anyway optional, even for Fixed Date CoS.
  As per other dates, the content is in ISO8601 standard format as
  described above and conditionally formatted with the following rules:
   * expires today, red background cell;
   * expires this week, orange background cell;
   * expires this month, yellow background cell;
   * expires next month, green background cell;
   * expired completed work item, red text.

* **Blocked Days** represents the total number of days when an *external
  dependency* or events or any *system-external* reason for which the
  item itself was not available to work on, has blocked a work item.
  In order to be properly evaluated, it shall be computed as the
  difference between two dates, plus one.
  That is: if a work item has been blocked today only, this column shall
  count 1, while if the work item has been blocked yesterday and today,
  the column shall count 2, etc.
  It is obviously possible to add multiple blockers, even through
  formulas, by simply adding the intervals and remembering to add 1 for
  each:
  `=(date(2019,8,15)-date(2019,8,12)+1)+(today(2019,3,5)-date(2019,3,3)+1)`
  that represents a blocker from 2019-08-12 to 2019-08-15 (4 days) and
  another blocker from 2019-03-03 to 2019-03-05 (3 days), for a total of
  7 blocked days.

* **Deleted** contains the date when a work item has been considered
  discarded (while in Backlog), or aborted (while in **Next** or
  **In-progress**) and no more bringing value to the flow.
  > *While bug [sr #109947](https://savannah.nongnu.org/support/?109947)
    is open*, when a work item has to be discarded or is aborted, *you*
    have to write such cancellation date in all remaining flow columns
    (from **Backlog** to **Done** all columns must contain a value, to
    consider the work item completed) and write the same date in the
    **Deleted** column.
	With this, the work item will be properly identified as deleted.

* The **Labels** column may contain a set of strings and text
  identifiers (labels) that can be used to further filter, categorize or
  tag the work items in order to better identify and collect their
  metrics.
  As shown in the example data of [Actionable Agile™
  Analytics](https://www.actionableagile.com/) tool, a single label can
  be written as simply as `A` while possible multiple labels can be
  represented as `[A|D|Y]`.
  That tool will take care of using them for filtering purposes.
  This spreadsheet has currently no use for this column, and it can be
  hidden.

All those columns above are properly managed by the [Actionable Agile™
Analytics](https://www.actionableagile.com/) tool as attributes that can
be filtered and grouped.
Filtering by **CoS** or **WIT** or other columns, and applying metrics
to filtered elements is not (yet?) supported in this spreadsheet.

## CFD
The [CFD](#cfd) dashboard sheet has the name tab highlighted in a
different colour, to show that it does not contain nor compute data but
represents them in charts.

If not otherwise specified, charts in this dashboard contain or manage
data enough to run the board for ten average Gregorian years (3652
days).

It contains some major metrics charts such as:
* *Cumulative Flow Diagram* (CFD) that shows:
  * a gray line showing the cumulative total number of work items that
  were created (**Backlog**);
  * a red line showing the cumulative total number of work items that
  has been committed (moved to **Next** column) for completion;
  * a yellow line showing the cumulative total number of work items that
  has been worked on (moved to **In-progress** column);
  * a green line showing the cumulative total number of work items that
  has been completed, discarded or aborted (moved to **Done** column).
  There is no visual distinction between actually completed work items
  and work items that have been discarded or aborted.

  The horizontal axis is a timeline, and the date of status update marks
  each work item.
  The vertical axis represents the cumulative total number of work items
  for such status on the reference date.
  This chart is a representation of the ongoing status of the service
  flow.

  For a detailed description of the behaviours and issues you can find
  with a Cumulative Flow Diagram, take a look at this relevant and
  interesting article by Pawel Brodzinski on his blog: [Cumulative Flow
  Diagram](http://brodzinski.com/2013/07/cumulative-flow-diagram.html).
* The *Daily Run Chart*, is the run chart for the daily values of
  **WIP** (orange, number of ongoing work items), **Thr**oughput (green,
  number of daily done work items as sum of completed and aborted) and
  **DR** or Delivery Rate (light green, number of daily completed work
  items).
* The *Backlog Age Distribution* is the distribution chart representing
  the amount of time the work items spend in Backlog before being
  committed.
  The chart currently includes data from all work items that has been
  created, regardless they are still in *Backlog*, they are in progress
  or already done.
* The *CoS Ratio* chart shows the Classes of Services ratio with respect
  to the total number of work items.
  It uses the four standard Classes of Services, and the colours are
  those defined as examples in
  [Kanban](https://leankanban.com/shop/kanban-book/) book and available
  in the **CoS** column in [WorkItems](#workitems) sheet.
* The *Flow Efficiency* is the run chart for Flow Efficiency
  computations with associated moving averages from the **FE**,
  **NetFE**, **mFE** and **mNetFE** columns in [Metrics](#metrics)
  sheet.
  The metrics details are in the specific section of this file.
* The *Age of WIP* is the chart that shows the age, in days, of the
  currently ongoing work items, taken from the **Age** column in
  [Metrics](#metrics) sheet.
* The *Backlog Control Chart*, is the chart that, following the
  principia and criteria of industrial control charts (see
  https://en.wikipedia.org/wiki/Control_chart), does a visual
  representation that can be used for statistical process monitoring.
  This can be used to identify special causes, working items that, for
  some reason, had a strange behaviour with respect to the overall
  system trend.
  Any observations outside the limits, or systematic patterns within,
  suggest the introduction of a new (and likely unanticipated) source of
  variation, known as a special-cause variation.
  Since increased variation means increased quality costs, a control
  chart signaling the presence of a special-cause requires immediate
  investigation.

Since same data are in different charts, to improve readability data
always (try to) use the same colouring throughout the charts in this
sheet.
So, for example, **mWIP** is always an orange line, both in *Little's
Law* and in *WIP Run Chart*, etc.

## Lead Time
The [Lead Time](#lead-time) dashboard sheet has the name tab
highlighted in a different colour to show that it does not contain nor
compute data but represents them in charts.

If not otherwise specified, charts contain or manage data enough to run
the board for ten average Gregorian years (3652 days).

It contains some charts related to Lead Time metric such as:
* the *Lead Times Scatter Plot* chart of completed work items, starting
from the earliest to the current date.
The scatter plot shows:
  * a blue dot for each "Done" work item with the value of its
    corresponding **LT** (Lead Time), shown in the day the work item has
    been "Done";
  * a red dotted line representing the moving average of the **95th
    percentile** (95%) of the **LT** values;
  * an orange dotted line representing the moving average of the **85th
    percentile** (85%) of the **LT** values;
  * a yellow dotted line representing the moving average of the **70th
    percentile** (70%) of the **LT** values;
  * a green dotted line representing the moving average of the **50th
    percentile** (50%) of the **LT** values;
  * a blue dotted line representing the moving average of the **LT**
    values themselves (**mLT**).

  The horizontal axis is a timeline that marks each work item on the
  completion (**Done**) date.
  The vertical axis represents the number of days: lead time of
  completed work items goes from the commitment point (when the work
  item enters the **Next** column) to the **Done** status (either
  completion or discard).

  This chart is a representation of how long (**LT**) it takes to get
  things done for individual work items on the kanban board, and the
  trends the **LT** has in time.

  Possible uses for scatter plot are:
  * visualize clearly the lead times of the work items, possibly
    filtering them according to CoS or WIT;
  * compare different WITs lead times;
  * forecast the lead time of future work items.

  For a detailed description of the behaviours and ways to read a lead
  time scatter plot, take a look at this article by
  [Kanbanize](https://kanbanize.com/): [Using Scatter Plot to Measure
  and Forecast Cycle
  Time](https://kanbanize.com/kanban-resources/kanban-analytics/cycle-time-scatter-plot/)
  with further details on [Meet the Cycle Time Scatterplot from Premium
  Analytics](https://kanbanize.com/blog/premium-cycle-time-scatterplot/).
* The *Lead Time Distribution* is the chart that represents the
  bin-constrained frequencies of Lead Time for all done work items.
  It plots the frequency of lead times, split in a set of 42 bins from
  the lowest to the highest value, with a blue dotted line overlay of
  the estimated Weibull distribution for such frequencies, if any.
  The values that are involved are **F(LT)** and **Weibull(LT)** from
  [Distribution](#distribution) sheet.
* The *Throughput Distribution* is the chart that represents the
  bin-constrained frequencies of Throughput values for all days.
  It plots the frequency of throughput, split in a set of 42 bins from
  the lowest to the highest value, with a green dotted line overlay of
  the estimated Weibull distribution for such frequencies, if any.
  The values that are involved are **F(Throughput)** and
  **Weibull(Throughput)** from [Distribution](#distribution) sheet.
* the *Lead Times Detail* charts work items Lead Times splitting them
  according to the time spent in each workflow status.

  For example: if a completed work item has spent 2 days in **Backlog**,
  3 days in **Next** and 12 days in **In-progress**, then the bar for
  such work item will be 17 days long, split in three differently
  coloured sections: a gray part, 2 days long, for **Backlog**; a red
  part, 3 days long, for **Next** and a yellow part, 12 days long, for
  **In-progress**.
  Keeping the same colour-conventions as in the *Cumulative Flow
  Diagram*, this chart shows:
  * a gray vertical bar showing the total number of days a completed
    work item has spent in the **Backlog** column;
  * a stacked red vertical bart showing the total number of days a
    completed work item has spent in the **Next** column;
  * a stacked yellow vertical bar showing the total number of days a
    completed work item has spent in the **In-progress** column.

  These are actual (calendar) days: if a work item has been moved from
  **Backlog** to **Done** in the same day, all column will be 0 (zero),
  but the corresponding Lead Time for such work item will be 1 (one)
  day.

  Since this is a bar chart, it cannot be spread to include 3652 days
  like, say, the *Lead Times Scatter Plot* chart because it does not
  automatically scale to skip empty values.
  So, while categories include the whole ten (average Gregorian) years
  set, the values of **Backlog**, **Next** and **In-progress** columns
  have been limited to 42 rows.
  Feel free to increase it, as soon as you have more than 42 work items,
  and remember to increase it further, when work items will increase in
  number.
* *Lead Time Control Chart*, is the chart that, following the principia
  and criteria of industrial control charts (see
  https://en.wikipedia.org/wiki/Control_chart), does a visual
  representation that can be used for statistical process monitoring.
  This can be used to identify special causes, that are working items
  that, for some reason, had a strange behaviour with respect to the
  overall system trend.
  Any observations outside the limits, or systematic patterns within,
  suggest the introduction of a new (and likely unanticipated) source of
  variation, known as a special-cause variation.
  Since increased variation means increased quality costs, a control
  chart signaling the presence of a special-cause requires immediate
  investigation.
* *WIP Run Chart*, is the chart that shows the ongoing daily **WIP**
    value, together with its moving average (**mWIP**) and the weekly
    moving average (**mWIP(7)**), computed only on the latest seven days
    of actual data).
* *Throughput Run Chart*, is the chart that shows the ongoing daily
  **Throughput** value, together with its moving average (**mThr**) and
  the weekly moving average (**mThr(7)**), computed only on the latest
  seven days of actual data).

Since same data are in different charts, to improve readability data
always (try to) use the same colouring throughout the charts in this
sheet.
So, for example, **mWIP** is always an orange line, both in *Little's
Law* and in *WIP Run Chart*, etc.

## Little's Law
The [Little's Law](#littles-law) dashboard sheet has the name tab
highlighted in a different colour to show that it does not contain nor
compute data but represents them in charts.

If not otherwise specified, charts in this dashboard contain or manage
data enough to run the board for ten average Gregorian years (3652
days).

The dashboard contains some charts related to Little's Law and other
useful metrics such as:
* The *Little's Law*, is the *mLT = mWIP / mThr* chart that represents
  the three terms of Little's Law.
  Running average of WIP (**mWIP**, orange), computed on actual data;
  running average of Throughput (**mThr**, green), computed on actual
  data; running average of Lead Time (**mLT**, blue), computed as ratio
  between those two values above;
* *Average Flows Speed*, is the chart that represents the running
  average speed of incoming (**mArrival**) and outgoing (**mThr**) work
  items flows, in terms of average number of work items per day.
  There is also the running average of delivery rate (**mDR**)
  considering only completed work items, without deleted/aborted ones.
* *Blockers*, is the chart that represents the running average
  **Impact** blockers may have in a work item, that is the average
  number of blocker days that may happen during a work item lifetime;
  the average **Likelihood** (probability) that a blocker day might
  happen during a work item life (on secondary, right-side, Y axis) and
  the average **Risk** that a blocker may represent, as product between
  the two previous values as product of the two values above,
  describing the number of probable blocker days for new work items
  appearing in a specific date.
* The *Little's Law (7 days)*, is the *LT = WIP / Thr* chart that
  represents the three terms of Little's Law.
  Running average of WIP (**mWIP(7)**, orange), computed only on the
  latest seven days of actual data; running average of Throughput
  (**mThr(7)**, green), computed only on the latest seven days of actual
  data; running average of Lead Time (**mLT(7)**, blue), computed as
  ratio between those two values above.
* The *Approximate Average Lead Time*, shows the **mLT** value, together
  with the trend of the approximate average lead time (**AALT**), as
  shown by the CFD chart.
  Chapter 9 of the [Actionable Agile Metrics for
  Predictability](https://leanpub.com/actionableagilemetrics) book
  (where is it described as Approximate Average Cycle Time) describes
  the Approximate Average Lead Time, and you can find a practical
  example in [Actionable Agile Metrics for Predictability by Daniel S.
  Vacanti, Re-read Saturday Week 10: Flow
  Debt](https://tcagley.wordpress.com/2017/12/23/actionable-agile-metrics-for-predictability-by-daniel-s-vacanti-re-read-saturday-week-10-flow-debt/#more-9151)
  while reviewing and commenting the book itself.
  It can be used to highlight flow issues.
* *Effort Run Chart*, simply represents the inverse of the daily **WIP**
  (`1/WIP`) and, for this reason, shows, each day, the **Daily Effort**
  that is the time theoretically spent, such day, for each ongoing (both
  **Next** and **In-progress**) work item.

  For example: if the **WIP** value is 1, you theoretically spend 100%
  of your time on the work item.
  If you have 2 ongoing work items (`WIP = 2`) means that you
  theoretically spend half of the day on each work item, this means the
  effort for each work item is 50% (of your day total effort).
  With 5 work items, your **Daily Effort** for each work item is 20%,
  and so on.

Since same data are in different charts, to improve readability data
always (try to) use the same colouring throughout the charts in this
sheet.
So, for example, **mWIP** is always an orange line, both in *Little's
Law* and in *WIP Run Chart*, etc.

## Metrics
The [Metrics](#metrics) sheet contains a set of metrics computed from
the data in [WorkItems](#workitems) sheet.
Mainly, together with a little duplication of information (work item
**ID**, **Name**, and **Done** date) for better reference and
readability, for each row there is a work item with the following
metrics and columns.
These metrics belongs to a single work item, even if there are others
(such has averages), that are more related to the evolution of those
basic metrics.

To easily remember the content length, the formulas in this sheet runs
till row number 3653, that is enough to manage 3652 work items, the same
number used in previous sheets.
Feel free to increase the formulas' coverage by dragging them to cover
more rows, when needed.
* **Backlog**, **Next** and **In-progress** columns that contain the
  number of days spent by the work item in each column.
  If the work item enters and exists a column on the same day, the count
  will show 0.
  If the work item has not yet entered a column, that column value will
  be empty, for that work item.
  In this situation, the value for the latest filled column will be
  computed against the current day.
* the **95%**, **85%**, **70%**, **50%** columns that represent the
  corresponding moving percentile of the completed work items Lead
  Times.
  You can find a description of percentile in
  [Percentile](https://en.wikipedia.org/wiki/Percentile) page on
  Wikipedia.
  For more details, see [Actionable Agile Metrics for
  Predictability](https://leanpub.com/actionableagilemetrics) book.
* **LT** computes the Lead Time for each completed work item.
  That is, **Done** date minus **Next** date plus one.
* **mLT** contains the daily moving average of all the Lead Times of
  the completed work items.
  Please note that this is the plain running average, done
  point-by-point by day.
* **Age** contains, for all not-completed work items, the number of days
  since the work item is in progress (since it entered in **Next**).
* **Blocked Days** contains the total number of days the work item has
  been blocked.
* **Computed Effort**, for a completed work item, considers, for each
  day of the progress life of the work item, the number of parallel work
  items ongoing in the system (that is, the daily WIP).
  e.g. While a single work item counts as 1 day of effort per day, if
  there are two parallel work items (WIP = 2), the actual effort, per
  work item, is 1/2 (or half) day.
  So, summing up all these daily computed efforts, for the whole work
  item lifetime, this column contains the total number of days
  theoretically worked on the work items, blockers included.
* **FE** (or Flow Efficiency) is computed, for each completed work item,
  as the ratio between the lead time minus the blocked days, and the
  lead time itself.
  e.g. If a work item has been completed in 13 days, but it has been
  blocked for 5 days, its FE is 61.53% that is (13 - 5) / 13.
* **NetFE** (or "Net" Flow Efficiency) is computed, for each completed
  work item, as the ratio between the lead time minus the sum of blocked
  days and days in **Next** column, and the lead time itself.
  e.g. If a work item has been completed in 13 days, but it has been
  blocked for 5 days, and it has spent 2 days in Next column, its NetFE
  is 46.15% that is (13 - (5 + 2)) / 13.

Those metrics below, instead, are not associated to a single work item,
as per those above, but are actually associated to the completion date
in the same line.
They all are averages computed from values on such completion date and
before, considering all values in those dates.

* **Impact** is computed (as described in [Kanban Maturity
  Model](https://www.kanbanmaturitymodel.com/) book), for a completed
  work item, by summing the total of blocked days of all previously
  **Done** work items (current included), divided by the number of
  work items.
  It represents the average number of blocker days per work item.
* **Likelihood** is computed (as described in [Kanban Maturity
  Model](https://www.kanbanmaturitymodel.com/) book), for a completed
  work item, by counting the total number of blockers of all previously
  **Done** work items (current included), divided by the number of
  work items.
  It represents the average probability of having a blocker per work
  item.
* **Risk** is computed (as described in [Kanban Maturity
  Model](https://www.kanbanmaturitymodel.com/) book), for a completed
  work item, by multipling the Impact and the Likelihood.
  It represents the average number of blocker days that may appear in
  work items.
* **mFE** contains the daily moving average of all the Flow Efficiencies
  of the completed work items, with completion date lower or equal the
  current work item one, if any.
* **mNetFE** contains the daily moving average of all the Net Flow
  Efficiencies of the completed work items, with completion date lower
  or equal the current work item one, if any.

## Distribution
The [Distribution](#distribution) sheet contains some set of data used
for previously described chart.
Specifically, it contains the frequency distributions and percentile
value for **LT**, **Backlog** and **Thr**oughput, as shown in
[CFD](#cfd) and [Lead Time](#lead-time) dashboards.
* The **F(LT)** column contains the frequency related to lead times, the
  number of completed work items that had a lead time less than or equal
  to the **LT(bin)** column value.
  The *Lead Times Distribution* bar chart plots this table column,
  showing the current distribution of lead time frequencies.
* The **F(Backlog)** column contains the frequency related to the age of
  elements (days spent) in backlog, regardless they are still in backlog
  (so their age will increase), or they've already been moved to other
  columns.
  This is the number of work items that have/had a backlog age less than
  or equal to the **Backlog(bin)** column value.
  The *Backlog Age Distribution* bar chart that plots this table column,
  showing the current distribution of backlog ages frequencies.
* The **F(Thr)** column contains the frequency related to daily
  throughput values, the number of done work items for each day, less
  than or equal to the **Thr(bin)** column value.
  The *Throughput Distribution* bar chart plots this table column,
  showing the current distribution of throughput frequencies.
* The Weibull columns (**Weibull(LT)**, **Weibull(Backlog)** and
  **Weibull(Thr)**) contain the computed values of the approximate
  Weibull distribution that mostly resemble the current distribution of
  values described by the **F(LT)**, **F(Backlog)** and **F(Thr)**
  columns, if any.
  Each specific distribution bar chart also plots these table columns as
  overlapping lines.
  Using **Shape (k)** and **Scale (λ)** values, approximated from the
  **Percentile(LT)**, **Percentile(Backlog)** and **Percentile(Thr)**
  values, there is also the computation of the Weibull distributions.
* **Shape (k)** is computed from the 35p and 75p (percentile) values in
  the **Percentile(LT)** column while **Scale (λ)** is computed from the
  35p value, and the **Shape**.
  I'd reference to Alexei Zheglov's nice blog post [How to Match to
  Weibull Distribution in
  Excel](https://connected-knowledge.com/2013/08/01/how-to-match-to-weibull-distribution-in-excel/):
  even though my calculations came from a different source (that I can't
  actually remember, but still searching for, to give it a proper
  reference), the results are similar to those written by Alexei in such
  post.
* **Mean**, **Variance**, **Median**, **Mode** are computed according to
  default Weibull distribution equation, using values of **Shape (k)**
  and **Scale (λ)**.
  Together with this default values from a Weibull distribution, there
  also are the **UCL** (Upper Control Limit) and **LCL** (Lower Control
  Limit) for control chart purposes as described, again, by Alexei
  Zheglov in [On the Practically Useful Properties of the Weibull
  Distribution](https://connected-knowledge.com/2013/08/01/on-the-practically-useful-properties-of-the-weibull-distribution/).
* **Percentile(LT)** and **Percentile(Backlog)** columns represents the
  current percentile values for Lead Time and Backlog age, the latter
  being the number of days a work item remains in the Backlog (since it
  has been created) before being took in charge and worked on;
* The **CoS** table shows the Classes of Services ratio with respect
  to the total number of work items.
  It uses the four standard Classes of Services, and the colours are
  those defined as examples in
  [Kanban](https://leankanban.com/shop/kanban-book/) book.
  It's the source of the *CoS Ratio* chart in the [CFD](#cfd) dashboard
  sheet.

## Data
The *Data* sheet is the daily representation of the whole board, with
reference metrics needed for each day (**Date** column).
Together with the daily number of work items for each column
(**Backlog**, **Next**, **In-progress**, **Done**), the sheet contains:
* the daily number of **Deleted** work items.
* the daily *Delivery Rate* (**DR**), the number of completed work items
  for the day, that is the number of work items moved to *Done* column
  and not deleted/discarded.
* the moving average delivery rate since the initial period (**mDR**).
* the daily **WIP**, the number of currently ongoing work items
  (**Next** plus **In-progress**).
* the moving average WIP since the initial period (**mWIP**).
* the moving average WIP of the latest seven days (**mWIP(7)**).
* the average lead time (**mLT**) computed as **mWIP** / **mThr**.
* the average lead time (**mLT(7)**) computed as **mWIP(7)** /
   **mThr(7)**.
* the theoretically (computed) current **Daily Effort** per work item,
  as the multiplicative inverse of **WIP** (1 / **WIP**).
* the daily current **Thr**oughput as the number of done work items for
  the day, that is the number of work items moved to *Done* column.
* the daily **mArrival** and **mThr** moving averages rates for work
  items as described in [Actionable Agile Metrics for
  Predictability](https://leanpub.com/actionableagilemetrics) book (as
  "Incoming" and "Outgoing"), together with the weekly **mThr(7)**;
* after a duplication of the **Date** for better readability, the set of
  cumulative daily data of work items for each column (**Backlog**,
  **Next**, **In-progress**, **Done**);
* the Approximate Average Lead Time (**AALT**), computed as described in
  [Actionable Agile Metrics for
  Predictability](https://leanpub.com/actionableagilemetrics) book.

This chart contains data rows till spreadsheet row number 3653, that is
enough to run the board for ten average Gregorian years.

## Appendix

### GNU Free Documentation License

Version 1.3, 3 November 2008

Copyright (C) 2000, 2001, 2002, 2007, 2008 Free Software Foundation,
Inc. <https://fsf.org/>

Everyone is permitted to copy and distribute verbatim copies of this
license document, but changing it is not allowed.

#### 0. PREAMBLE

The purpose of this License is to make a manual, textbook, or other
functional and useful document "free" in the sense of freedom: to
assure everyone the effective freedom to copy and redistribute it,
with or without modifying it, either commercially or noncommercially.
Secondarily, this License preserves for the author and publisher a way
to get credit for their work, while not being considered responsible
for modifications made by others.

This License is a kind of "copyleft", which means that derivative
works of the document must themselves be free in the same sense. It
complements the GNU General Public License, which is a copyleft
license designed for free software.

We have designed this License in order to use it for manuals for free
software, because free software needs free documentation: a free
program should come with manuals providing the same freedoms that the
software does. But this License is not limited to software manuals; it
can be used for any textual work, regardless of subject matter or
whether it is published as a printed book. We recommend this License
principally for works whose purpose is instruction or reference.

#### 1. APPLICABILITY AND DEFINITIONS

This License applies to any manual or other work, in any medium, that
contains a notice placed by the copyright holder saying it can be
distributed under the terms of this License. Such a notice grants a
world-wide, royalty-free license, unlimited in duration, to use that
work under the conditions stated herein. The "Document", below, refers
to any such manual or work. Any member of the public is a licensee,
and is addressed as "you". You accept the license if you copy, modify
or distribute the work in a way requiring permission under copyright
law.

A "Modified Version" of the Document means any work containing the
Document or a portion of it, either copied verbatim, or with
modifications and/or translated into another language.

A "Secondary Section" is a named appendix or a front-matter section of
the Document that deals exclusively with the relationship of the
publishers or authors of the Document to the Document's overall
subject (or to related matters) and contains nothing that could fall
directly within that overall subject. (Thus, if the Document is in
part a textbook of mathematics, a Secondary Section may not explain
any mathematics.) The relationship could be a matter of historical
connection with the subject or with related matters, or of legal,
commercial, philosophical, ethical or political position regarding
them.

The "Invariant Sections" are certain Secondary Sections whose titles
are designated, as being those of Invariant Sections, in the notice
that says that the Document is released under this License. If a
section does not fit the above definition of Secondary then it is not
allowed to be designated as Invariant. The Document may contain zero
Invariant Sections. If the Document does not identify any Invariant
Sections then there are none.

The "Cover Texts" are certain short passages of text that are listed,
as Front-Cover Texts or Back-Cover Texts, in the notice that says that
the Document is released under this License. A Front-Cover Text may be
at most 5 words, and a Back-Cover Text may be at most 25 words.

A "Transparent" copy of the Document means a machine-readable copy,
represented in a format whose specification is available to the
general public, that is suitable for revising the document
straightforwardly with generic text editors or (for images composed of
pixels) generic paint programs or (for drawings) some widely available
drawing editor, and that is suitable for input to text formatters or
for automatic translation to a variety of formats suitable for input
to text formatters. A copy made in an otherwise Transparent file
format whose markup, or absence of markup, has been arranged to thwart
or discourage subsequent modification by readers is not Transparent.
An image format is not Transparent if used for any substantial amount
of text. A copy that is not "Transparent" is called "Opaque".

Examples of suitable formats for Transparent copies include plain
ASCII without markup, Texinfo input format, LaTeX input format, SGML
or XML using a publicly available DTD, and standard-conforming simple
HTML, PostScript or PDF designed for human modification. Examples of
transparent image formats include PNG, XCF and JPG. Opaque formats
include proprietary formats that can be read and edited only by
proprietary word processors, SGML or XML for which the DTD and/or
processing tools are not generally available, and the
machine-generated HTML, PostScript or PDF produced by some word
processors for output purposes only.

The "Title Page" means, for a printed book, the title page itself,
plus such following pages as are needed to hold, legibly, the material
this License requires to appear in the title page. For works in
formats which do not have any title page as such, "Title Page" means
the text near the most prominent appearance of the work's title,
preceding the beginning of the body of the text.

The "publisher" means any person or entity that distributes copies of
the Document to the public.

A section "Entitled XYZ" means a named subunit of the Document whose
title either is precisely XYZ or contains XYZ in parentheses following
text that translates XYZ in another language. (Here XYZ stands for a
specific section name mentioned below, such as "Acknowledgements",
"Dedications", "Endorsements", or "History".) To "Preserve the Title"
of such a section when you modify the Document means that it remains a
section "Entitled XYZ" according to this definition.

The Document may include Warranty Disclaimers next to the notice which
states that this License applies to the Document. These Warranty
Disclaimers are considered to be included by reference in this
License, but only as regards disclaiming warranties: any other
implication that these Warranty Disclaimers may have is void and has
no effect on the meaning of this License.

#### 2. VERBATIM COPYING

You may copy and distribute the Document in any medium, either
commercially or noncommercially, provided that this License, the
copyright notices, and the license notice saying this License applies
to the Document are reproduced in all copies, and that you add no
other conditions whatsoever to those of this License. You may not use
technical measures to obstruct or control the reading or further
copying of the copies you make or distribute. However, you may accept
compensation in exchange for copies. If you distribute a large enough
number of copies you must also follow the conditions in section 3.

You may also lend copies, under the same conditions stated above, and
you may publicly display copies.

#### 3. COPYING IN QUANTITY

If you publish printed copies (or copies in media that commonly have
printed covers) of the Document, numbering more than 100, and the
Document's license notice requires Cover Texts, you must enclose the
copies in covers that carry, clearly and legibly, all these Cover
Texts: Front-Cover Texts on the front cover, and Back-Cover Texts on
the back cover. Both covers must also clearly and legibly identify you
as the publisher of these copies. The front cover must present the
full title with all words of the title equally prominent and visible.
You may add other material on the covers in addition. Copying with
changes limited to the covers, as long as they preserve the title of
the Document and satisfy these conditions, can be treated as verbatim
copying in other respects.

If the required texts for either cover are too voluminous to fit
legibly, you should put the first ones listed (as many as fit
reasonably) on the actual cover, and continue the rest onto adjacent
pages.

If you publish or distribute Opaque copies of the Document numbering
more than 100, you must either include a machine-readable Transparent
copy along with each Opaque copy, or state in or with each Opaque copy
a computer-network location from which the general network-using
public has access to download using public-standard network protocols
a complete Transparent copy of the Document, free of added material.
If you use the latter option, you must take reasonably prudent steps,
when you begin distribution of Opaque copies in quantity, to ensure
that this Transparent copy will remain thus accessible at the stated
location until at least one year after the last time you distribute an
Opaque copy (directly or through your agents or retailers) of that
edition to the public.

It is requested, but not required, that you contact the authors of the
Document well before redistributing any large number of copies, to
give them a chance to provide you with an updated version of the
Document.

#### 4. MODIFICATIONS

You may copy and distribute a Modified Version of the Document under
the conditions of sections 2 and 3 above, provided that you release
the Modified Version under precisely this License, with the Modified
Version filling the role of the Document, thus licensing distribution
and modification of the Modified Version to whoever possesses a copy
of it. In addition, you must do these things in the Modified Version:

-   A. Use in the Title Page (and on the covers, if any) a title
    distinct from that of the Document, and from those of previous
    versions (which should, if there were any, be listed in the
    History section of the Document). You may use the same title as a
    previous version if the original publisher of that version
    gives permission.
-   B. List on the Title Page, as authors, one or more persons or
    entities responsible for authorship of the modifications in the
    Modified Version, together with at least five of the principal
    authors of the Document (all of its principal authors, if it has
    fewer than five), unless they release you from this requirement.
-   C. State on the Title page the name of the publisher of the
    Modified Version, as the publisher.
-   D. Preserve all the copyright notices of the Document.
-   E. Add an appropriate copyright notice for your modifications
    adjacent to the other copyright notices.
-   F. Include, immediately after the copyright notices, a license
    notice giving the public permission to use the Modified Version
    under the terms of this License, in the form shown in the
    Addendum below.
-   G. Preserve in that license notice the full lists of Invariant
    Sections and required Cover Texts given in the Document's
    license notice.
-   H. Include an unaltered copy of this License.
-   I. Preserve the section Entitled "History", Preserve its Title,
    and add to it an item stating at least the title, year, new
    authors, and publisher of the Modified Version as given on the
    Title Page. If there is no section Entitled "History" in the
    Document, create one stating the title, year, authors, and
    publisher of the Document as given on its Title Page, then add an
    item describing the Modified Version as stated in the
    previous sentence.
-   J. Preserve the network location, if any, given in the Document
    for public access to a Transparent copy of the Document, and
    likewise the network locations given in the Document for previous
    versions it was based on. These may be placed in the "History"
    section. You may omit a network location for a work that was
    published at least four years before the Document itself, or if
    the original publisher of the version it refers to
    gives permission.
-   K. For any section Entitled "Acknowledgements" or "Dedications",
    Preserve the Title of the section, and preserve in the section all
    the substance and tone of each of the contributor acknowledgements
    and/or dedications given therein.
-   L. Preserve all the Invariant Sections of the Document, unaltered
    in their text and in their titles. Section numbers or the
    equivalent are not considered part of the section titles.
-   M. Delete any section Entitled "Endorsements". Such a section may
    not be included in the Modified Version.
-   N. Do not retitle any existing section to be Entitled
    "Endorsements" or to conflict in title with any Invariant Section.
-   O. Preserve any Warranty Disclaimers.

If the Modified Version includes new front-matter sections or
appendices that qualify as Secondary Sections and contain no material
copied from the Document, you may at your option designate some or all
of these sections as invariant. To do this, add their titles to the
list of Invariant Sections in the Modified Version's license notice.
These titles must be distinct from any other section titles.

You may add a section Entitled "Endorsements", provided it contains
nothing but endorsements of your Modified Version by various
partiesâ€”for example, statements of peer review or that the text has
been approved by an organization as the authoritative definition of a
standard.

You may add a passage of up to five words as a Front-Cover Text, and a
passage of up to 25 words as a Back-Cover Text, to the end of the list
of Cover Texts in the Modified Version. Only one passage of
Front-Cover Text and one of Back-Cover Text may be added by (or
through arrangements made by) any one entity. If the Document already
includes a cover text for the same cover, previously added by you or
by arrangement made by the same entity you are acting on behalf of,
you may not add another; but you may replace the old one, on explicit
permission from the previous publisher that added the old one.

The author(s) and publisher(s) of the Document do not by this License
give permission to use their names for publicity for or to assert or
imply endorsement of any Modified Version.

#### 5. COMBINING DOCUMENTS

You may combine the Document with other documents released under this
License, under the terms defined in section 4 above for modified
versions, provided that you include in the combination all of the
Invariant Sections of all of the original documents, unmodified, and
list them all as Invariant Sections of your combined work in its
license notice, and that you preserve all their Warranty Disclaimers.

The combined work need only contain one copy of this License, and
multiple identical Invariant Sections may be replaced with a single
copy. If there are multiple Invariant Sections with the same name but
different contents, make the title of each such section unique by
adding at the end of it, in parentheses, the name of the original
author or publisher of that section if known, or else a unique number.
Make the same adjustment to the section titles in the list of
Invariant Sections in the license notice of the combined work.

In the combination, you must combine any sections Entitled "History"
in the various original documents, forming one section Entitled
"History"; likewise combine any sections Entitled "Acknowledgements",
and any sections Entitled "Dedications". You must delete all sections
Entitled "Endorsements".

#### 6. COLLECTIONS OF DOCUMENTS

You may make a collection consisting of the Document and other
documents released under this License, and replace the individual
copies of this License in the various documents with a single copy
that is included in the collection, provided that you follow the rules
of this License for verbatim copying of each of the documents in all
other respects.

You may extract a single document from such a collection, and
distribute it individually under this License, provided you insert a
copy of this License into the extracted document, and follow this
License in all other respects regarding verbatim copying of that
document.

#### 7. AGGREGATION WITH INDEPENDENT WORKS

A compilation of the Document or its derivatives with other separate
and independent documents or works, in or on a volume of a storage or
distribution medium, is called an "aggregate" if the copyright
resulting from the compilation is not used to limit the legal rights
of the compilation's users beyond what the individual works permit.
When the Document is included in an aggregate, this License does not
apply to the other works in the aggregate which are not themselves
derivative works of the Document.

If the Cover Text requirement of section 3 is applicable to these
copies of the Document, then if the Document is less than one half of
the entire aggregate, the Document's Cover Texts may be placed on
covers that bracket the Document within the aggregate, or the
electronic equivalent of covers if the Document is in electronic form.
Otherwise they must appear on printed covers that bracket the whole
aggregate.

#### 8. TRANSLATION

Translation is considered a kind of modification, so you may
distribute translations of the Document under the terms of section 4.
Replacing Invariant Sections with translations requires special
permission from their copyright holders, but you may include
translations of some or all Invariant Sections in addition to the
original versions of these Invariant Sections. You may include a
translation of this License, and all the license notices in the
Document, and any Warranty Disclaimers, provided that you also include
the original English version of this License and the original versions
of those notices and disclaimers. In case of a disagreement between
the translation and the original version of this License or a notice
or disclaimer, the original version will prevail.

If a section in the Document is Entitled "Acknowledgements",
"Dedications", or "History", the requirement (section 4) to Preserve
its Title (section 1) will typically require changing the actual
title.

#### 9. TERMINATION

You may not copy, modify, sublicense, or distribute the Document
except as expressly provided under this License. Any attempt otherwise
to copy, modify, sublicense, or distribute it is void, and will
automatically terminate your rights under this License.

However, if you cease all violation of this License, then your license
from a particular copyright holder is reinstated (a) provisionally,
unless and until the copyright holder explicitly and finally
terminates your license, and (b) permanently, if the copyright holder
fails to notify you of the violation by some reasonable means prior to
60 days after the cessation.

Moreover, your license from a particular copyright holder is
reinstated permanently if the copyright holder notifies you of the
violation by some reasonable means, this is the first time you have
received notice of violation of this License (for any work) from that
copyright holder, and you cure the violation prior to 30 days after
your receipt of the notice.

Termination of your rights under this section does not terminate the
licenses of parties who have received copies or rights from you under
this License. If your rights have been terminated and not permanently
reinstated, receipt of a copy of some or all of the same material does
not give you any rights to use it.

#### 10. FUTURE REVISIONS OF THIS LICENSE

The Free Software Foundation may publish new, revised versions of the
GNU Free Documentation License from time to time. Such new versions
will be similar in spirit to the present version, but may differ in
detail to address new problems or concerns. See
<https://www.gnu.org/licenses/>.

Each version of the License is given a distinguishing version number.
If the Document specifies that a particular numbered version of this
License "or any later version" applies to it, you have the option of
following the terms and conditions either of that specified version or
of any later version that has been published (not as a draft) by the
Free Software Foundation. If the Document does not specify a version
number of this License, you may choose any version ever published (not
as a draft) by the Free Software Foundation. If the Document specifies
that a proxy can decide which future versions of this License can be
used, that proxy's public statement of acceptance of a version
permanently authorizes you to choose that version for the Document.

#### 11. RELICENSING

"Massive Multiauthor Collaboration Site" (or "MMC Site") means any
World Wide Web server that publishes copyrightable works and also
provides prominent facilities for anybody to edit those works. A
public wiki that anybody can edit is an example of such a server. A
"Massive Multiauthor Collaboration" (or "MMC") contained in the site
means any set of copyrightable works thus published on the MMC site.

"CC-BY-SA" means the Creative Commons Attribution-Share Alike 3.0
license published by Creative Commons Corporation, a not-for-profit
corporation with a principal place of business in San Francisco,
California, as well as future copyleft versions of that license
published by that same organization.

"Incorporate" means to publish or republish a Document, in whole or in
part, as part of another Document.

An MMC is "eligible for relicensing" if it is licensed under this
License, and if all works that were first published under this License
somewhere other than this MMC, and subsequently incorporated in whole
or in part into the MMC, (1) had no cover texts or invariant sections,
and (2) were thus incorporated prior to November 1, 2008.

The operator of an MMC Site may republish an MMC contained in the site
under CC-BY-SA on the same site at any time before August 1, 2009,
provided the MMC is eligible for relicensing.

### ADDENDUM: How to use this License for your documents

To use this License in a document you have written, include a copy of
the License in the document and put the following copyright and
license notices just after the title page:

        Copyright (C)  YEAR  YOUR NAME.
        Permission is granted to copy, distribute and/or modify this document
        under the terms of the GNU Free Documentation License, Version 1.3
        or any later version published by the Free Software Foundation;
        with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts.
        A copy of the license is included in the section entitled "GNU
        Free Documentation License".

If you have Invariant Sections, Front-Cover Texts and Back-Cover
Texts, replace the "with … Texts." line with this:

        with the Invariant Sections being LIST THEIR TITLES, with the
        Front-Cover Texts being LIST, and with the Back-Cover Texts being LIST.

If you have Invariant Sections without Cover Texts, or some other
combination of the three, merge those two alternatives to suit the
situation.

If your document contains nontrivial examples of program code, we
recommend releasing these examples in parallel under your choice of
free software license, such as the GNU General Public License, to
permit their use in free software.
