<?php

/* Appora server
 * Copyright (C) 2011 Appora contributors
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** Included file for hello action service */
require_once(dirname(__FILE__) . "/../env.php");
require_once(dirname(__FILE__) . "/AService.php");

class HelloService extends AService {

	public function __construct() {
		$this->name = "hello";
	}

	public function run() {
		global $server, $header, $response, $aLocales;
		$data = array();
		$data['name'] = $server->getServerName($aLocales);
		$data['description'] = $server->getServerDescription($aLocales);
		$data['status'] = $server->getServerStatus();
		$data['default_locale'] = $server->getDefaultLocale();
		$data['source_location'] = $server->getServerSourceCodeLocation();
		$response = json_encode($data);
		$header = "HTTP/1.0 200 Ok; Content-Type: application/json;"
				. " Content-Length: " . strlen($response);
	}

}

$hello_service = new HelloService();
$hello_service->run();
?>
