<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

class Event {

	var $timestamps = array('event_start_datetime'  => 0,
							'event_end_time' => 0);

	// Event -------------------------------------------------------------
	// the constructor
	// Sebastian Oblome, 25th October 2006
	//
	function Event($db, $core_config) {
		$this->db = $db;
		$this->core_config = $core_config;
	}//EO Event
	
	
	
	// insertEvent --------------------------------------------------------
	// inserts a record in the database
	// Sebastian Oblom, 25th October 2006
	//
	function insertEvent($data) {
		
		$rec = array();
		
		if (!$this->validateDate($data['schedule_start_date'])) {
			$GLOBALS['am_error_log'][] = array('no_valid_date');
		}

		if (!isset($data['event_all_day']) || empty($data['event_all_day'])) {
		
			if (!$this->validateTime($data['schedule_start_time'])) {
				$GLOBALS['am_error_log'][] = array('no_valid_time');
			}
		}
		
		$this->timestamps['event_end_time'] = $this->timestamps['event_start_datetime'] + $data['event_duration'] * 3600 * $data['event_duration_type'];

		if ($this->timestamps['event_end_time'] <= $this->timestamps['event_start_datetime']) {
			$GLOBALS['am_error_log'][] = array('no_valid_end_time');
		}
		
		if (!is_numeric($data['event_allocation']) && $data['event_allocation'] != '') {
			$GLOBALS['am_error_log'][] = array('not_numeric');
		}
		
		if (!is_numeric($data['event_duration'])) {
			$GLOBALS['am_error_log'][] = array('not_numeric');
		}
		
		$rec['event_create_datetime'] = time();
		$rec['event_start_datetime']  = $this->timestamps['event_start_datetime'];
		$rec['event_end_datetime']    = $this->timestamps['event_end_time'];
		$rec['event_title']           = trim(strip_tags($data['event_title']));
		$rec['event_synopsis']        = trim(strip_tags($data['event_synopsis']));
		$rec['event_body']            = $data['event_body'];
		$rec['location_id']           = $data['location_id'];
		$rec['user_id']               = $this->user_id;
 		$rec['status_id']             = $this->event_config['event_invite_status'];
 		$rec['event_allocation']      = $data['event_allocation'];
		$rec['level_id']              = $data['event_invite_type'];
		$rec['event_venue']           = trim(strip_tags($data['event_venue']));
		$rec['language_id']           = $this->language_id;
		$rec['event_type']            = $data['participation_type'];
		
		if (empty($rec['event_title'])) {
			$GLOBALS['am_error_log'][] = array('no_title');
		}
		
		if (empty($rec['event_synopsis'])) {
			$GLOBALS['am_error_log'][] = array('no_synopsis');
		}
		
		if (empty($rec['event_venue'])) {
			$GLOBALS['am_error_log'][] = array('no_venue');
		}
		
		if (isset($data['event_private']) && !empty($data['event_private'])) {
			$rec['event_private'] = 1;
		}
		else {
			$rec['event_private'] = 'null';
		}
		
		if (isset($data['file_id']) && $data['file_id'] != 0) {
			$rec['file_id'] = $data['file_id'];
		}
		
		if ($rec['event_allocation'] == '') {
			$rec['event_allocation'] = 'null';
		}
		
		$table = $this->db->prefix . "_event";

		if (empty($GLOBALS['am_error_log'])) {
			
			$query  = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
		
			if (isset($result->fields)) {
				$this->event_id = $this->db->Insert_ID();
			}
			else {
				$error_info = "function=insertEvent class=Event.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array('db_error', $error_info);
			}
		}
	}//EO insertEvent

	
	
	// updateEvent ---------------------------------------------------------------------
	// updates a row in the database
	// Sebastian Oblom, 25th October 2006
	//
	function updateEvent($data) {
		
		$rec = array();

		$query = "
			SELECT event_id, event_create_datetime, event_start_datetime, event_venue,
			event_end_datetime, event_title, event_synopsis, event_body, file_id,
			location_id, user_id, event_allocation, language_id, level_id, event_private
			FROM " . $this->db->prefix . "_event
			WHERE event_id=" . $this->event_id
		;
		
		$result = $this->db->Execute($query);
		
		if (!$this->validateDate($data['schedule_start_date'])) {
			$GLOBALS['am_error_log'][] = array('no_valid_date');
		}

		if (!isset($data['event_all_day']) || empty($data['event_all_day'])) {
		
			if (!$this->validateTime($data['schedule_start_time'])) {
				$GLOBALS['am_error_log'][] = array('no_valid_time');
			}
		}
		
		$this->timestamps['event_end_time'] = $this->timestamps['event_start_datetime'] + $data['event_duration'] * 3600 * $data['event_duration_type'];

		if ($this->timestamps['event_end_time'] <= $this->timestamps['event_start_datetime']) {
			$GLOBALS['am_error_log'][] = array('no_valid_end_time');
		}
		
		if (!is_numeric($data['event_allocation']) && $data['event_allocation'] != '') {
			$GLOBALS['am_error_log'][] = array('not_numeric');
		}
		
		if (!is_numeric($data['event_duration'])) {
			$GLOBALS['am_error_log'][] = array('not_numeric');
		}
		
		
		$rec['event_edit_datetime']   = time();
		$rec['event_start_datetime']  = $this->timestamps['event_start_datetime'];
		$rec['event_end_datetime']    = $this->timestamps['event_end_time'];
		$rec['event_title']           = htmlspecialchars($data['event_title']);
		$rec['event_synopsis']        = htmlspecialchars($data['event_synopsis']);
		$rec['event_body']            = $data['event_body'];
		$rec['location_id']           = $data['location_id'];
		$rec['user_id']               = $this->user_id;
 		$rec['status_id']             = $this->event_config['event_invite_status'];
 		$rec['event_allocation']      = $data['event_allocation'];
		$rec['level_id']              = $data['event_invite_type'];
		$rec['event_venue']           = htmlspecialchars($data['event_venue']);
		$rec['language_id']           = $this->language_id;
		
		if (isset($data['file_id']) && $data['file_id'] != 0) {
			$rec['file_id'] = $data['file_id'];
		}
		
		if ($rec['event_allocation'] == '') {
			$rec['event_allocation'] = 'null';
		}
		
		if (isset($data['event_private']) && !empty($data['event_private'])) {
			$rec['event_private'] = 1;
		}
		else {
			$rec['event_private'] = 'null';
		}
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
		
		if (!isset($result->fields)) {
			$error_info = "function=updateEvent class=Event.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO updateEvent
	
	
	function selEvent() {
		$query = "
			SELECT e.event_id, e.event_create_datetime, e.event_start_datetime, e.default_user_permission,
			e.event_end_datetime, e.event_title, e.event_synopsis, e.event_body, e.event_type,
			e.event_venue, e.location_id, e.user_id, e.status_id, e.event_allocation, e.event_private,
			e.language_id, e.level_id, e.event_edit_datetime, e.file_id, l.location_name
			FROM " . $this->db->prefix . "_event e
			INNER JOIN " . $this->db->prefix . "_user_location l
			ON e.location_id=l.location_id
			LEFT JOIN " . $this->db->prefix . "_mem_type_access mt ON e.event_id=mt.item_id and mt.module_id=" . $this->core_config['module_id']['event'] . "
			WHERE e.event_id=" . $this->event_id . " AND "
		;
		
		if (isset($this->level_id)) {
			$query .= "e.level_id=" . $this->level_id . "AND ";
		}
		
		$query .= "(e.event_type!=4 OR ";
		$query .= "(e.event_type=4 AND mt.membership_type_id=". $this->membership_type_id . ")) AND ";
		
		$query .= "1=1 ";

		$result = $this->db->Execute($query);
	
		if (isset($result->fields)) {
			$temp = $result->fields;
			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selEvent class=Event.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}
	
	
	// selEvents ------------------------------------------------------------------
	// returns events/event from the database
	// Sebastian Oblom, 25th October 2006
	//
	function selEvents($future_events = true, $my_events = false) {
		
		$timestamp_from = time(); // we need this to select future events
		$timestamp_to = strtotime("+" . $this->event_config['view']['default_days'] . " days");
	
		$query = "
			SELECT e.event_id, e.event_create_datetime, e.event_start_datetime, e.event_venue, e.default_user_permission,
			e.event_end_datetime, e.event_title, e.event_synopsis, e.event_body, e.file_id, e.event_type, e.event_private, 
			e.location_id, e.user_id, e.event_allocation, e.language_id, e.level_id, e.status_id"
		;
		

		if (isset($this->my_attendance)) {
			$t = "p";
			$query .= " FROM " . $this->db->prefix . "_event e 
			INNER JOIN " . $this->db->prefix . "_participation p 
			ON p.item_id=e.event_id 
			WHERE p.status_id=" . $this->event_config['user']['status']['active'] . " AND ";
		}
		else {
 			$t = "e";
 			$query .= ",l.location_name, i.identity_nic, i.identity_id, COUNT(p.user_id) AS count_attendance
 			FROM " . $this->db->prefix . "_event e
 			LEFT JOIN " . $this->db->prefix . "_user_location l
 			ON l.location_id=e.location_id
 			LEFT JOIN " . $this->db->prefix . "_participation p
 			ON (e.event_id=p.item_id AND e.user_id=p.user_id)
 			INNER JOIN " . $this->db->prefix . "_user_identity i
 			ON p.identity_id=i.identity_id
 			WHERE ";
		}
		
		if (isset($this->level_id)) {
			$query .= "e.level_id=" . $this->level_id . " AND ";
		}

		if (isset($this->event_id)) {
			$query .= "e.event_id=" . $this->event_id . " AND ";
		}

		if ($this->event_config['view']['default_list'] == "local") {
			$query .= "e.location_id=" . $this->location_id . " AND ";
		}
		
		if ($future_events) {
			$query .= "UNIX_TIMESTAMP(e.event_start_datetime) > " . $timestamp_from . " AND ";
			$query .= "UNIX_TIMESTAMP(e.event_start_datetime) < " . $timestamp_to . " AND ";
		}
		
		if (isset($this->today)) {
			$query .= "UNIX_TIMESTAMP(e.event_start_datetime) < " . $timestamp_from . " AND ";
			$query .= "UNIX_TIMESTAMP(e.event_end_datetime) > " . $timestamp_from . " AND ";
		}
		
		if ($my_events) {
			$query .= $t . ".user_id=" . $this->user_id . " AND ";
		}
		
		if (!isset($this->sel_canceled)) {
			$query .= "e.status_id !=" . $this->event_config['event']['status']['canceled'] . " AND ";
		}
		
		$query .= "1=1 ";
		$query .= "GROUP BY e.event_id ";
		
		if (isset($this->high_attendance)) {
			$query .= "ORDER BY count_attendance DESC, e.event_start_datetime";
		}
		elseif ($my_events) {
			$query .= "ORDER BY e.event_create_datetime DESC";
		}
		else {
			$query .= "ORDER BY e.event_start_datetime ";
		}

		$result = $this->db->Execute($query);
		
		$temp = array();
		
		if (isset($result->fields)) {
		
			if (isset($this->max_events)) {
				$counter = 1;
			}
		
			while(!$result->EOF) {
			
// 				if (isset($this->wiki)) {
// 					$result->fields['event_body'] = $this->wiki->transform(stripslashes($result->fields['event_body']), 'Xhtml');
// 				}
			
				$result->fields['event_duration'] = $this->toDuration($result->fields['event_start_datetime'], $result->fields['event_end_datetime']);
				array_push($temp, $result->fields);
				$result->moveNext();
				
				if (isset($counter)) {
				
					if ($counter == $this->max_events) {
						
						break;
					}
					$counter++;
				}
			}
			$result->Close();
		}
		
		if (isset($this->single_event)) {
			if (isset($temp[0])) {
				return $temp[0];
			}
			else {
				return array(0);
			}
		}
		return $temp;
	}//EO selEvents
	
	
	
	// selTagCloud ---------------------------------------------------------------
	// returns this modules tagcloud
	// Sebastian Oblom, 25th October 2006
	//
	function selTagCloud() {
		
		$query = "
			SELECT t.tag_body, t.item_id,
			COUNT(t.tag_body) AS tag_count
			FROM " . $this->db->prefix . "_tag t
			INNER JOIN " . $this->db->prefix . "_event e
			ON t.item_id=e.event_id
			WHERE t.module_id=" . $this->core_config['module_id']['event'] . " AND "
		;
		
		if (isset($this->level_id)) {
			$query .= "e.level_id=" . $this->level_id . " AND ";
		}
		
		$query .= " 1=1 GROUP BY t.tag_body ORDER BY t.tag_body";

		
		$result = $this->db->Execute($query);
		$temp = array();
		
		if (isset($result->fields)) {
			while(!$result->EOF) {
				array_push($temp, $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}
		return $temp;
	}//EO selTagCloud

	
	
	// validateDate -------------------------------------------------------------
	// validates date-format
	// Sebastian Oblom, 25th October 2006
	//
	function validateDate($date) {
		
		$tmp = explode('-', $date);
		
		foreach($tmp as $t) {
			if (!is_numeric($t)) {
				return false;
			}
		}
		
		if (count($tmp) != 3) {
			return false;
		}
		
		if (!checkdate($tmp[1], $tmp[2], $tmp[0])) {
			return false;
		}
		$this->timestamps['event_start_datetime'] = mktime(0, 0, 0, $tmp[1], $tmp[2], $tmp[0]);

		return true;
	}//EO validateDate
	
	
	
	// validateTime -------------------------------------------------------------
	// validates time-format
	// Sebastian Oblom, 25th October 2006
	//
	function validateTime($time) {
		
		$tmp = explode(':', $time);

		foreach($tmp as $t) {
			if(!is_numeric($t)) {
				return false;
			}
		}
		
		if ($tmp[0] > 24 || $tmp[0] < 0) {
			return false;
		}
		
		if ($tmp[1] > 60 || $tmp[1] < 0) {
			return false;
		}
		
		$this->timestamps['event_start_datetime'] += $tmp[0]*3600 + $tmp[1]*60;
		
		return true;
	}//Eo validateTime
	
	
	
	// toDuration ----------------------------------------------------------------
	// returns in hours, the difference from one date to another
	// Sebastian Oblom, 25th October 2006
	//
	function toDuration($start_datetime, $end_datetime) {
		
		return (strtotime($end_datetime) - strtotime($start_datetime))/3600;
	}//EO toDuration



	// allEvents ------------------------------------------------------------------
	// simple config-change to select not just local events
	// Sebastian Oblom, 26th October 2006
	//
	function allEvents() {
		
		$this->event_config['view']['default_list'] = "all";
	}//EO allEvents



	// searchEvents ---------------------------------------------------------------
	// searches for events
	// Sebastian Oblom, 25th October 2006
	//
	function searchEvents($data) {
		
		$query = "
			SELECT e.event_id, e.event_create_datetime, e.event_start_datetime, e.event_venue,
			e.event_end_datetime, e.event_title, e.event_synopsis, e.event_body, e.file_id,
			e.location_id, e.user_id, e.event_allocation, e.language_id, e.level_id
			FROM " . $this->db->prefix . "_event e "
		;
		
		if (isset($data['event_tag']) && !empty($data['event_tag'])) {
			$query .= "INNER JOIN " . $this->db->prefix . "_tag t
			ON (e.event_id=t.item_id AND t.module_id=" . $this->core_config['module_id']['event'] . ") ";
		}
		
		$query .= "WHERE ";
		
		if (isset($this->level_id)) {
			$query .= "e.level_id=" . $this->level_id . " AND ";
		}
		
		if (isset($data['event_location'])) {
			if ($data['event_location'] == 0) {
				$query .= "e.location_id=" . $this->location_id . " AND ";
			}
		}
		
		if (isset($data['search_text']) && !empty($data['search_text'])) {
			$query .= "(e.event_title LIKE " . $this->db->qstr("%" . $data['search_text'] . "%", get_magic_quotes_gpc()) . " 
			OR e.event_synopsis LIKE " . $this->db->qstr("%" . $data['search_text'] . "%", get_magic_quotes_gpc()) . " 
			OR e.event_body LIKE " . $this->db->qstr("%" . $data['search_text'] . "%", get_magic_quotes_gpc()) . "
			OR e.event_venue LIKE " . $this->db->qstr("%" . $data['search_text'] . "%", get_magic_quotes_gpc()) . ") AND ";
		}
		
		if (isset($data['search_startdate'])) {
		
			$data['search_startdate'] = str_replace('-', '', $data['search_startdate']);
		
			if (strlen($data['search_startdate']) == 4) { // allow "easy-search" on years
				$data['search_startdate'] .= "0101";
			}
			
			if (strlen($data['search_startdate']) == 6) { // allow "easy-search" on months
				$data['search_startdate'] .= "01";
			}
		
			$start_datetime = strtotime($data['search_startdate']);
			if ($start_datetime) {
				$query .= "UNIX_TIMESTAMP(e.event_start_datetime) > " . $start_datetime . " AND ";
			}
		}
		
		if (isset($data['search_enddate'])) {
			
			$data['search_enddate'] = str_replace('-', '', $data['search_enddate']);
			
			if (strlen($data['search_enddate']) == 4) { // allow "easy-search" on years
				$data['search_startdate'] .= "0101";
			}
			
			if (strlen($data['search_enddate']) == 6) { // allow "easy-search" on months
				$data['search_startdate'] .= "01";
			}
		
			$end_datetime = strtotime($data['search_enddate']);
			if ($end_datetime) {
				$query .= "UNIX_TIMESTAMP(e.event_end_datetime) < " . $end_datetime . " AND ";
			}
		}

		if (isset($data['event_tag']) && !empty($data['event_tag'])) {
			$query .= "t.tag_body='" . $data['event_tag'] . "' AND "; // add code here
		}
		
		$query .= "e.status_id=" . $this->event_config['event']['status']['live'] . " AND 1=1 ";
		$query .= "ORDER BY e.event_start_datetime DESC";

		$temp = array();
		$result = $this->db->Execute($query);
		
		if(isset($result->fields)) {
			
			while(!$result->EOF) {
				$result->fields['event_duration'] = $this->toDuration($result->fields['event_start_datetime'], $result->fields['event_end_datetime']);
				array_push($temp, $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}
		
		return $temp;
	}//EO searchEvents



	// insertFeedback -----------------------------------------------------------------
	// inserts a feeback-record in the database
	// Sebastian Oblom, 13th November 2006
	//
	function insertFeedback($data) {
		$rec = array();
		
		$rec = $data;
		$rec['event_id'] = $this->event_id;
		$rec['user_id'] = $this->user_id;
		$rec['identity_id'] = $this->identity_id;
		$rec['feedback_create_datetime'] = time();
		
		if (!isset($data['feedback_participation'])) {
			$GLOBALS['am_error_log'][] = array('not_numeric');
		}
		
		if (!isset($data['feedback_enjoyment'])) {
			if ($data['feedback_participation']) {
				$GLOBALS['am_error_log'][] = array('not_numeric');
			}
		}
		
		if (!isset($data['feedback_arrangement'])) {
			$GLOBALS['am_error_log'][] = array('not_numeric');
		}
		
		if (!isset($data['feedback_comment'])) {
			$rec['feedback_comment'] = 'null';
		}
		
		if (!isset($data['feedback_private'])) {
			$rec['feedback_private'] = 0;
		}
	
		if (empty($GLOBALS['am_error_log'])) {
			$table = $this->db->prefix . "_event_feedback";
			$query  = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			$result = $this->db->Execute($query);
		
			if (isset($result->fields)) {
				$this->feedback_id = $this->db->Insert_ID();
			}
			else {
				$error_info = "function=insertFeedback class=Event.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['am_error_log'][] = array('db_error', $error_info);
			}
		}
	}//EO insertFeedback
	
	
	
	// selFeedback ----------------------------------------------------------------------
	// returns a feedback-record from the database
	// Sebastian Oblom, 13th November 2006
	//
	function selFeedback($private=true) {
		$query = "
			SELECT f.feedback_id, f.event_id, f.user_id, f.feedback_participation, 
			f.feedback_enjoyment, f.feedback_arrangement, f.feedback_comment, 
			f.feedback_private, f.feedback_create_datetime, f.identity_id, i.identity_nic
			FROM " . $this->db->prefix . "_event_feedback f
			INNER JOIN " . $this->db->prefix . "_user_identity i
			ON f.identity_id=i.identity_id
			WHERE f.event_id=" . $this->event_id . " AND "
		;
	
		if ($private) {
			$query .= "f.feedback_private=0 AND ";
		}
	
		$query .= "1=1 ";
		$query .= "ORDER BY f.feedback_create_datetime DESC";
		$result = $this->db->Execute($query);
		$temp = array();
		
		if (isset($result->fields)) {
			while(!$result->EOF) {
				array_push($temp, $result->fields);
				$result->moveNext();
			}
			$result->Close();
		}

		return $temp;
	}//EO selFeedback

}

?>