<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

$menu_section = "event";


// EVENT SETUP -----------------------------------------------------------
include_once ("config/evt.config.php");
include_once ("inc/evt_initiate.inc.php");


if ($output_event['user_id'] != $_SESSION['user_id']) {
	header("Location: index.php?amn=evt_item&event_id=" . $output_event['event_id'] . "&" . strip_tags(SID));
	exit;
}


// TAG SETUP -------------------------------------------------------------
require_once ('components/core/class/Tag.class.php');
$tag = new Tag($db);
$tag->module_id = $core_config['module_id']['event'];
$tag->item_id   = $event->event_id;


if (isset($_REQUEST['edit_tag'])) {
	$output_tag  = $tag->selTag($_REQUEST['edit_tag']);
}

if (isset($_POST['insert_tag'])) {
	if ($_POST['tag_body'] != '' && '' !== $_POST['tag_body'] = trim($_POST['tag_body'])) {
	
		if (isset($_REQUEST['edit_tag'])) {
			$tag->updateTag($_REQUEST['tag_id'], $_POST['tag_body']);
		}
		else {
			$tag->insertTag($_POST['tag_body']);
		}
	}
}
elseif (isset($_POST['delete_tag'])) {
	if (isset($_REQUEST['tag_id'])) {
		$tag->deleteTag($_REQUEST['tag_id']);
	}
}
elseif (isset($_POST['submit_status'])) {

	$query = "
		UPDATE " . $db->prefix . "_event
		SET status_id=" . $_POST['frm_status'] . "
		WHERE event_id=" . $event->event_id
	;
	
	$db->Execute($query);
	header('location: index.php?amn=evt_list');
	exit;
}

// $output_event = $event->selEvents(false, false);
$output_tags  = $tag->selTags();
$output_coordinators = $participation->selParticipants(null, $event_config['role']['coordinator'], null);


if (!empty($output_event)) {
	$body->set('event', $output_event);
}

if (!empty($output_tags)) {
	$body->set('tags', $output_tags);
}

if (!empty($output_tag)) {
	$body->set('tag', $output_tag);
}

if (!empty($event_config)) {
	$body->set('config', $event_config);
}

if (!empty($output_coordinators)) {
	foreach ($output_coordinators as $key => $i):
		$user->identity_ids[] = $i['identity_id'];
	endforeach;
	
	$user->identity_ids = array_unique($user->identity_ids);
	
	if (!empty($user->identity_ids)) {
		$output_coordinators = $user->selUserIdentities();
		$body->set('coordinators', $output_coordinators);
	}
}

?>
