<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// this include file is used in the core and in the event
// if it receives either a item_id or a event_id it gets the event
// if it returns the event it checks your participation in that

$menu_section = "event";

include_once($language_path . 'inc/evt_common.inc.php');
require_once('components/core/class/Kses/kses.php');

//setup event
include_once ('components/evt/config/evt.config.php');
require_once('components/evt/class/Event.class.php');
$event = new Event($db, $core_config);
$event->event_config  = $event_config;

if (isset($_SESSION['user_id'])) {
	$event->user_id       = $_SESSION['user_id'];
	$event->language_id   = $_SESSION['language_id'];
	$event->location_id   = $_SESSION['location_id'];
}
else {
 	$event->event_config['view']['default_list'] = "all";
	$event->level_id = $event_config['level']['public'];
}

$event->single_event  = true;
$event->allEvents();

if (empty($_SESSION['md5'])) {
	$event->level_id = $event_config['level']['public'];
	$event->membership_type_id = 0;
}
else {
	$event->membership_type_id = $_SESSION['membership_type_id'];
}

require_once ('components/core/class/Date.class.php');
$event->date = new Date;




if (!empty($_REQUEST['event_id'])) {
	$event->event_id = $_REQUEST['event_id'];
	$output_event = $event->selEvents(false, false);
}
elseif (!empty($_REQUEST['item_id'])) {
	$event->event_id = $_REQUEST['item_id'];
	$output_event = $event->selEvents(false, false);
}



if (!empty($output_event[0])) {

	if (date('Y-m-d H:i:s', time()) > $output_event['event_end_datetime'] && $script_name != "item" && $script_name != "profile") {
 		header('location: index.php?amn=evt_item&event_id=' . $event->event_id);
 		exit;
 	}


	require_once('components/core/class/Participation.class.php');
	$participation = new Participation($db, $core_config);
	$participation->module_id = $core_config['module_id']['event'];
	$participation->item_id = $event->event_id; //$_REQUEST['event_id'];


	// anyone is able to view the event structure page which lists the event type
	// for any other event page a membership check is required
	if (isset($output_event) && isset($_SESSION['user_id'])) {
		// participation
		$participation->item_id = $output_event['event_id'];
 		$output_participation = $participation->selParticipation($_SESSION['user_id']);
		$output_item = $output_event; // used for core pages
		$output_item['item_id'] = $output_event['event_id'];
		$output_item['item_title'] = $output_event['event_title'];
		$output_item['item_synopsis'] = $output_event['event_synopsis'];
		
		$participation->item_id = $output_item['item_id'];
		
	}
	
	if (!empty($output_participation)) {
		$tpl->set('participation', $output_participation);
		$body->set('participation', $output_participation);
	}
	else {
		unset($output_participation);
	}
	
	
	$tpl->set("event", $output_event);
}
elseif (isset($_REQUEST['amn']) && $_REQUEST['amn'] != 'evt_edit' && $_REQUEST['amn'] != 'evt_maintain') {
	header('location: index.php?amn=evt_list&' . strip_tags(SID));
	exit;
}

// we authenticate the user
if (isset($output_event['event_id']) && $script_name != "participate" && $script_name != "item") {
	//check status	
	if (isset($output_participation['status_id']) && $output_participation['status_id'] == $core_config['participation']['status']['barred']) {
		header("Location: index.php?amn=evt_participate&" . strip_tags(SID));
		exit;
	}
	elseif (isset($event_config['type']['membership_type']) && $output_event['level_id'] < $event_config['level']['public'] && $output_event['event_type'] == $event_config['type']['membership_type'] && $output_event['user_id'] != $_SESSION['user_id']) {
		// we need to check that my membership_type corresponds to those that can access the set
		if (!$participation->checkSetMembershipTypeAccess($_SESSION['membership_type_id'])) {
			header("Location: index.php?amn=evt_list&" . strip_tags(SID));
			exit;
		}
	}
}


$tpl->set("event_config", $event_config);
$body->set("event_config", $event_config);


// FULLSCREEN MODE ------------------------------------------
// there is no full screen mode for events
unset ($_SESSION['fullscreen']);

?>
