<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

// Permission check
if ($_SESSION['user_mod_permission'] & $core_config['resource']['module']['evt']['maint']) {

	$menu_section = "event";
	
	include_once ("config/evt.config.php");
	include_once ("inc/evt_initiate.inc.php");
	
	// update event
	if (isset($_POST['update_event'])) {
		$query = "
			SELECT * 
			FROM " . $db->prefix . "_event  
			WHERE 
			event_id=" . $_POST['maint_event_id']
		;
		
		$result = $db->Execute($query);
	
		if (isset($result->fields)) {
	
			$rec = array();
			$rec['status_id'] = $_POST['status_id'];

			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
		
		
	}
	
	// list events
	$output_events = array();
	$timestamp_from = time();
	$query = "
		SELECT e.*
		FROM " . $db->prefix . "_event e
		WHERE UNIX_TIMESTAMP(e.event_start_datetime) >= " . $timestamp_from
	;
	
	$result = $db->Execute($query);

	if (isset($result->fields)) {
		while(!$result->EOF) {
			array_push($output_events, $result->fields);
			$result->moveNext();
		}
		$result->Close();
	}

	if (!empty($output_events)) {
		$body->set('events', $output_events);
	}

	if (isset($_POST['maint_event_id'])) {
		
		$query = "
			SELECT e.*
			FROM " . $db->prefix . "_event e
			WHERE e.event_id=" . $_POST['maint_event_id']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			$output_event = $result->fields;
			$result->Close();
		}
		$participation->item_id = $output_event['event_id'];
	}
	elseif (isset($_REQUEST['event_id'])) {
		$query = "
			SELECT e.*
			FROM " . $db->prefix . "_event e
			WHERE e.event_id=" . $_REQUEST['event_id']
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			$output_event = $result->fields;
			$result->Close();
		}
	}

	if (!empty($output_event)) {
		// get arbiter
		require_once ("components/core/class/File.class.php");
		$file = new File($db, $core_config['file']);
		
		if (isset($core_config['module'])) {
			$file->core_config_module = $core_config['module'];
		}
		
		$file->module_id = 0; // core
		
		$file->thumb = $core_config['file']['image']['thumb'][0]['suffix'];
		$file->no_image = $core_config['file']['image']['thumb'][0]['no_image'];
		$user->file = $file;

		$output_owner = $participation->selParticipation($output_event['user_id']);
		$output_identity = $user->selUserIdentity(null, $output_owner['identity_id']);
		$body->set('identity', $output_identity);

		$body->set('event', $output_event);
	}
	else { // get statistics
		$output_statistics = array();

		$query = "
			SELECT event_type, count(event_type) as event_count 
			FROM " . $db->prefix . "_event
			GROUP BY event_type"
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			while (!$result->EOF) {
				$output_statistics['event_type'][] = $result->fields;
				
				$result->MoveNext();
			}
		}
		$query = "
			SELECT status_id, count(status_id) as status_count
			FROM " . $db->prefix . "_event
			GROUP BY status_id"
		;
		
		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			while (!$result->EOF) {
				$output_statistics['status'][] = $result->fields;
				
				$result->MoveNext();
			}
		}
				
		if (!empty($output_statistics)) {
			$body->set('statistics', $output_statistics);
		}
	}

	
}
else {
	header("Location: index.php?amn=" . $_SESSION['user_homepage'] . "&" . strip_tags(SID));
	exit;
}
?>
