<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


// Include the Message class so that the message functionality is obtained

class Schedule {
	//Note setlocale(); is set in the User.class.php at login
	//this will affect date output.

	var $id;             // Group or user id
	var $db;             // Database connection
	var $tables;         // Head table to use
	var $schedule;       // The array that contains everything in the calendar
	var $todo;           // The array with non-time-specific events
	var $daysinmonth;    // Number of days in month

	var $mh, $da, $yr;

	function Schedule($db, $now, $id="", $type="") {
		$this->db = $db;
		$this->id  = $id;

		// Tables differ for groups and users ?
		$this->tables["events"]   = "br_events";
		$this->tables["activity"] = "br_activity";

		$this->mh  = $now['mon'];
		$this->da  = $now['mday'];
		$this->yr  = $now['year'];

		$this->schedule = array(); // Initialize calendar
		$this->todo = array(); // Initialize calendar

	}

	function setScheduleBase()
	{
		//setup calendar array
		$this->daysinmonth = date("t",mktime(0, 0, 0, $this->mh, 1, $this->yr));

		//populate the calendar array with dates
		//fill the calendar
		for ($i=0; $i < 24; $i++) {
			$temp = array(
				'today' => date("h:00",mktime($i,0,0,$this->mh,$this->da,$this->yr)),
				'hour' => $i,
				'content' => array()
			);

			array_push($this->schedule, $temp);
		}

	}

	function getMax()
	{
		$value = 0;
		for ($i=0; $i < 24; $i++) {
			$value = count($this->schedule[$i]['content'])>$value ? count($this->schedule[$i]['content']) : $value;
		}

		return $value;

	}

	function getSchedule()
	{
		return $this->schedule;
	}

	function getToDo()
	{
		return $this->todo;
	}

	// Recalculate the dates so that the matches up
	// the structure of the populating algortihm
	// Erik Sundelöf, June 3, 2004
	//-----------------------------

	function modifyEventDate($event) {

		$event_date = $this->calculateDate($event);

		if(!empty($event_date[0])) {
			$event[5] = $event_date[0];
			$event["event_start_datetime"] = $event_date[0];
		}

		if(!empty($event_date[1])) {
			$event[6] = $event_date[1];
			$event["event_end_datetime"] = $event_date[1];
		}

		return $event;
	}

	function populateEvent($event)
	{
		if(!empty($event["event_start_datetime"]))
			$start = strtotime($event[5]);
		else
			$start = 0;

		if(!empty($event["event_end_datetime"]))
			$end = strtotime($event[6]);
		else
			$end = 0;

		// Defines useful dates
		$time_start      = mktime(0, 0, 1, $this->mh, $this->da, $this->yr);
		$time_end        = mktime(23, 59, 59, $this->mh, $this->da, $this->yr);

		if($start>=$time_start & $start<=$time_end)
		{
			if($end<=$time_end)
			{
				$hs = date("G", $start);
				$he = date("G", $end);
			}
			else
			{
				$hs = date("G", $start);
				$he = 23;
			}

		}
		elseif($end>=$time_start & $end<=$time_end)
		{
			$hs = 0;
			$he = date("G", $end);
		}
		elseif($start<$time_start & $end>$time_end)
		{
			if(!empty($event["event_frequency"]))
			{
				if(!empty($event["event_start_hour"]) & !empty($event["event_end_hour"]))
				{
					$hs = $event["event_start_hour"];
					$he = $event["event_end_hour"]-1;
					if($he<$hs)
						$he = $hs;
				}
				else
				{
					$he = $hs = 1;
				}
				//else
				//	array_push($this->todo, $event);
			}
		}

		if(!empty($event["event_frequency"]) & empty($event["event_start_hour"]) & empty($event["event_end_hour"]))
			$hs = $he = 1;

		// Corrects hours if incorrect
		if(isset($hs))
		{
			if($hs<0)
				$hs = 0;
		}

		// Corrects hours if incorrect
		if(isset($he))
		{
			if($he>23)
				$he = 23;
		}

		if(isset($hs) & isset($he))
		{

			for($h = $hs; $h < $he+1; $h++)
			{
				if(isset($event["event_frequency"]))
				{

					if($event["event_frequency"]==3) // Weekly
					{

						$weekday        = date("w", mktime(0, 1, 1, $this->mh, $this->da, $this->yr))+1;
						$start_weekday  = $event["event_start_weekday"];

						if(empty($event["event_end_weekday"]))
							$end_weekday = $event["event_start_weekday"];
						else
							$end_weekday = $event["event_end_weekday"];

						if($start_weekday<=$weekday & $end_weekday>=$weekday)
						{
							if(!empty($event["event_start_hour"]) & !empty($event["event_end_hour"]))
								array_push($this->schedule[$h]['content'], $event);
							else
								array_push($this->todo, $event);
						}
					}
					elseif ($event["event_frequency"]==9) { // Monthly
						$start_day = $event["event_start_day"];

						if(empty($event["event_end_day"]))
							$end_day = $event["event_start_day"];
						else
							$end_day = $event["event_end_day"];

						if($start_day<=$this->da & $end_day>=$this->da)
						{
							if(empty($event["event_start_hour"]) & empty($event["event_end_hour"]))
								array_push($this->todo, $event);
							else
								array_push($this->schedule[$h]['content'], $event);
						}
					}
					elseif ($event["event_frequency"]==10) { // Yearly
						$start_day = $event["event_start_day"];

						if(empty($event["event_end_day"]))
							$end_day = $event["event_start_day"];
						else
							$end_day = $event["event_end_day"];

						if($start_day<=$this->da & $end_day>=$this->da & $event["event_start_month"]<=$this->mh & $event["event_end_month"]>=$this->mh)
						{
							if(empty($event["event_start_hour"]) & empty($event["event_end_hour"]))
								array_push($this->todo, $event);
							else
								array_push($this->schedule[$h]['content'], $event);
						}
					}
					else
					{
						if(empty($event["event_start_hour"]) & empty($event["event_end_hour"]))
							array_push($this->todo, $event);
						else
							array_push($this->schedule[$h]['content'], $event);
					}
				}
				else
					array_push($this->schedule[$h]['content'], $event);
			}
		}
	}

		// Calculate starting date
	function calculateDate($event){

		$sec[0] = (!empty($event['event_start_sec'])) ? $event['event_start_sec'] : "01";
		$min[0] = (!empty($event['event_start_min'])) ? $event['event_start_min'] : "01";
		$hour[0] = (!empty($event['event_start_hour'])) ? $event['event_start_hour'] : "01";
		$day[0] = (!empty($event['event_start_day'])) ? $event['event_start_day'] : 1;
		$month[0] = (!empty($event['event_start_month'])) ? $event['event_start_month'] : $this->mh;
		$year[0] = (!empty($event['event_start_year'])) ? $event['event_start_year'] : $this->yr;

		$sec[1] = (!empty($event['event_end_sec'])) ? $event['event_end_sec'] : "01";
		$min[1] = (!empty($event['event_end_min'])) ? $event['event_end_min'] : "01";
		$hour[1] = (!empty($event['event_end_hour'])) ? $event['event_end_hour']-1 : "01";
		$day[1] = (!empty($event['event_end_day'])) ? $event['event_end_day'] : $this->daysinmonth;
		$month[1] = (!empty($event['event_end_month'])) ? $event['event_end_month'] : $this->mh;
		$year[1] = (!empty($event['event_end_year'])) ? $event['event_end_year'] : $this->yr;

		if($hour[0]>$hour[1])
			$hour[1] = $hour[0];

		for($i = 0; $i<=1; $i++)
			$event_date[$i] = mktime($hour[$i], $min[$i], $sec[$i], $month[$i], $day[$i], $year[$i]);
			//$event_date[$i] = strtotime($year[$i]."-".$month[$i]."-".$day[$i]." ".$hour[$i].":".$min[$i].":".$sec[$i]);

		// Redefining the end date so that it matches the events
		if(isset($event["event_frequency"]) && $event["event_frequency"]>0) {

			$freq = $event["event_frequency"];
			if($freq==3 | $freq==1) {
				$event_date[0] = mktime(0, 0, 0, $this->mh, 1, $this->yr);
				$event_date[1] = strtotime("+1 month -1 day", $event_date[0]);
			}
		}

		if(!empty($event["event_start_datetime"]))
			$event_date[0] = ($event_date[0]>=strtotime($event["event_start_datetime"])) ? $event_date[0] : strtotime($event["event_start_datetime"]);

		if(!empty($event["event_end_datetime"]))
			$event_date[1] = ($event_date[1]>=strtotime($event["event_end_datetime"])) ? $event_date[1] : strtotime($event["event_end_datetime"]);

		$event_date[0] = ($event_date[0]<=mktime(0, 0, 0, $this->mh, 1, $this->yr)) ? date("Y-n-j G:i:s", mktime(0, 0, 0, $this->mh, 1, $this->yr)) : date("Y-n-j G:i:s", $event_date[0]);
		$event_date[1] = ($event_date[1]<=mktime(0, 0, 0, $this->mh, $this->daysinmonth, $this->yr)) ? date("Y-n-j G:i:s", mktime(0, 0, 0, $this->mh, $this->daysinmonth, $this->yr)) : date("Y-n-j G:i:s", $event_date[1]);

		if(empty($event["event_frequency"])) {
			$event_date[0] = $event[5];//$event["event_start_datetime"];
			$event_date[1] = $event[12];//$event["event_end_datetime"];
		}

		return $event_date;

	}
}
