<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


// Include the Message class so that the message functionality is obtained
include "Message.class.php";

class IM {

	// Instance variables
	var $user_id;                        // User id
	var $db;                              // get db connect
	var $max_size;                        // max size
	var $output_message_statistics;       // allocate statitical variable
	var $status;                          // holding the message status coding
	var $boxes;                           // holding the coding of the boxes

	// Set the user id and $db connection in the constructor for simplicity
	function IM($user_id, $db, $max_size) {
		$this->user_id = $user_id;
		$this->db = $db;
		$this->max_size = $max_size;
	}

	// Set message status coding
	function setStatus($unread, $read)  {
		$this->status["unread"] = $unread;
		$this->status["read"]   = $read;
	}

	// Getting the status for read/unread
	function getStatus($type) {
		return $this->status[$type];
	}

	// Set message box coding
	function setBoxes($inbox, $savebox, $outbox) {
		$this->boxes["in_box"]     = $inbox;
		$this->boxes["save_box"]   = $savebox;
		$this->boxes["out_box"]    = $outbox;

	}

	// Setting message statistics
	function setStatistics() {

		// Setting the statistics
		$query = "
		SELECT m.message_body, m.message_box, m.message_status
		FROM " . $this->db->prefix . "_user_message m
		LEFT JOIN " . $this->db->prefix . "_user u on m.owner_user_id=u.user_id
		WHERE
		(m.message_box = " . $this->boxes["in_box"] . " and m.to_user_id =" . $this->user_id . ") or
		(m.message_box = " . $this->boxes["save_box"] . " and m.to_user_id =" . $this->user_id . ") or
		(m.message_box = " . $this->boxes["out_box"] . " and m.from_user_id =" . $this->user_id . ")"
		;

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
		else {

			$total_size = 0;
			$total_in_box_size = 0;
			$in_box_messages = 0;
			$total_save_box_size = 0;
			$save_box_messages = 0;
			$total_out_box_size = 0;
			$out_box_messages = 0;
			$total_messages = 0;
			$unread_messages = 0;

			while (!$result->EOF) {

				if ($result->fields['message_box'] == $this->boxes["in_box"]) {
					$total_in_box_size = $total_in_box_size + strlen($result->fields['message_body']);
					$in_box_messages++;
					if ($result->fields['message_status'] == $this->getStatus("unread")) {
						$unread_messages++;
					}
				}
				else if ($result->fields['message_box'] == $this->boxes["save_box"]) {
					$total_save_box_size = $total_save_box_size + strlen($result->fields['message_body']);
					$save_box_messages++;
				}
				else if ($result->fields['message_box'] == $this->boxes["out_box"]) {
					$total_out_box_size = $total_out_box_size + strlen($result->fields['message_body']);
					$out_box_messages++;
				}
				$total_messages++;
				$result->MoveNext();
			}

			$total_size = $total_in_box_size + $total_save_box_size + $total_out_box_size;

			$result->Close();

			$this->output_message_statistics =
				array(
					'total_size'=> 				$total_size,
					'total_messages'=> 			$total_messages,
					'total_size_allowed'=> 		$this->max_size,
					'in_box_size'=> 			$total_in_box_size,
					'in_box_messages'=> 		$in_box_messages,
					'out_box_size'=> 			$total_out_box_size,
					'out_box_messages'=> 		$out_box_messages,
					'save_box_size'=> 			$total_save_box_size,
					'save_box_messages'=> 		$save_box_messages,
					'unread'=> 					$unread_messages
				);
			

		}
	}

	// obtaining the output statistics
	function getStatistics()
	{
		return $this->output_message_statistics;
	}

	// Get the message list from the message box of interest
	function getMessageBox($message_box)
	{
		// Selection of messages is differs for different boxes...
		if ($message_box == "out_box") {
			$selection = " and m.from_user_id =" . $this->user_id;
			$join = "m.to_user_id=u.user_id";
		}
		else if ($message_box == "save_box") {
			$selection = " and (m.to_user_id =" . $this->user_id ." or m.from_user_id =" . $this->user_id . ")";
			$join = "m.owner_user_id=u.user_id";

		}
		else if ($message_box == "in_box") {
			$selection = " and m.to_user_id =" . $this->user_id;
			$join = "m.from_user_id=u.user_id";
		}

		// Forming query and selecting the messages with the correct owner id:s...
		// The \" m.to_user_id, m.owner_user_id, m.from_user_id \" are there so that one can track
		// everything about the users linked to that particular message outside the class.

		$query = "
		SELECT u.user_nic, u.user_firstname, m.message_id,
		m.owner_user_id, m.to_user_id, m.from_user_id,
		m.message_status, m.message_subject, m.message_body, m.message_create_datetime
		FROM " . $this->db->prefix . "_user_message m
		LEFT JOIN " . $this->db->prefix . "_user u on ". $join ." WHERE
		m.message_box = " . $this->boxes[$message_box] . $selection . " ORDER BY  m.message_create_datetime DESC";
		;
		
		// Getting the message_box list
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {

			$temp = array();

			while (!$result->EOF) {
				array_push($temp, $result->fields);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$this->log[]  = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
			exit();
		}
	}

	// Delete message
	function deleteMessages($del_arr)
	{
		$rownums = count ($del_arr);

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				DELETE from " . $this->db->prefix . "_user_message
				WHERE
				message_id = " . $del_arr[$i]
				;

			$result = $this->db->Execute($query);

			if (!$result) {
				$state[]  = array('error', 1, $this->db->ErrorMsg());
			}
		}
	}

	// move message to save_box, send in the save_box to
	// ensure that the index is correct
	function moveToSavebox($move_arr)
	{
		$rownums = count ($move_arr);

		for ($i=0; $i < $rownums; $i++) {
			$query = "
				UPDATE " . $this->db->prefix . "_user_message SET message_box=" . $this->boxes["save_box"] . "
				WHERE
				message_id=" . $move_arr[$i]
				;

			$result = $this->db->Execute($query);

			if (!$result) {
				$state[]  = array('error', 1, $this->db->ErrorMsg());
			}
		}
	}

	// set the status of the messages to unread
	function setMessagesStatus($message_arr, $status)
	{
		$rownums = count ($message_arr);             // Counting messages
		$message = new Message($this->db);           // create tmp message object

		for ($i=0; $i < $rownums; $i++) {
			$message->setMessageId($message_arr[$i]); // Assign id
			$message->setStatus($status);             // Assign status
		}

	}

	// create new message entry in database
	function newMessage($owner_user_id, $to_user_id, $message_subject, $message_body, $message_box, $message_type = null) {

		/*
		* message types:
		* added by Tom Calthrop
		* Message type 1 = will display the "add new friend" button in the msg_item.php template
		*/
		if (!isset($message_type)) {
		    $message_type = "null";
		}

		$message_status = $this->getStatus("unread");

		// save user into br_user
		$query = "INSERT INTO " . $this->db->prefix . "_user_message SET
			owner_user_id='$owner_user_id', to_user_id='$to_user_id', from_user_id='$this->user_id',
			message_subject='$message_subject', message_body='$message_body', message_box='$message_box',
			message_create_datetime=NOW(), message_status='$message_status', message_type=$message_type";

		$result = $this->db->Execute($query);

		if (!$result) {
			$state[]  = array('error', 1, $this->db->ErrorMsg());
		}
	}

	// create new message entry in database
	function sendMessage($to_user_id, $message_subject, $message_body, $message_type = null) {

		// Creating message for the sender - box=out_box
		$this->newMessage($this->user_id, $to_user_id, $message_subject, $message_body, $this->boxes["out_box"]);

		// Creating message for the receiver - box=in_box
		if (isset($message_type)) {
		    $this->newMessage($to_user_id, $to_user_id, $message_subject, $message_body, $this->boxes["in_box"], $message_type);
		}
		else {
			$this->newMessage($to_user_id, $to_user_id, $message_subject, $message_body, $this->boxes["in_box"]);
		}



	}


	//check if the $to_user_id has blocked me
	//tom calthrop - 21st April 2004
	function checkUserBlocked($to_user_id) {
		$query = "
			SELECT user_id_blocker
			FROM " . $this->db->prefix . "_user_blocked
			WHERE
			user_id_blocker = " . $to_user_id . " and
			user_id_blocked = " . $this->user_id
		;

		$result = $this->db->Execute($query);

		if (!isset($result->fields['user_id_blocker'])) {
			return true;
		}
	}

	
	/*
	* GET UNREAD MESSAGES
	* tom calthrop
	* 21st Feb 2004
	*/
	function messageCount() {
		$query = "
			SELECT count(message_id) as total_unread
			FROM " . $this->db->prefix . "_user_message
			WHERE
			message_box = " . $this->boxes['in_box'] . " and
			message_status = " . $this->status['unread'] . " and
			to_user_id =" . $this->user_id
		;

		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			return $result->fields['total_unread'];
			exit();
		}
		else {
			return 0;
			$this->log[] = array('error', 1, $query . "-" . $this->db->ErrorMsg(), null);
		}
		
	}

}


