<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "event";
include "inc/header.inc.php";


//append language setup
require_once($languageArrayPath . 'arr_event_type.lang.php');
require_once($languageArrayPath . 'arr_activity_user_status.lang.php');


if (isset($_POST['search'])) {
	$search = trim($_POST['search_text']);
	$search_event_type_id = $_POST['search_event_type_id'];
	$output_event_search_results = searchEventItems($search, $search_event_type_id);
	$output_activity_search_results = searchActivityItems($search);
	$display = "search";
}
elseif (isset($_REQUEST['my_events'])) {
	//get user activities and events
	$output_my_events = myEvents();
	$display = "myevents";
}
elseif (isset($group_id) && $group_id > 0) {
	//list event
	$output_events = $event->getEvents('group', $group_id);

	$display = "list_group_events";
}
elseif (isset($_REQUEST['list_events'])) { //published events
	//list event
	$output_events = $event->getEvents('user', $me['user_id']);

	$display = "list_events";
}
else {
	//get the latest
	$output_latest_events = lastestEvents();
	$output_latest_activities = latestActivities();
}


//move to template
if (isset($output_event_search_results)) {
	$body->set('event_search_results', $output_event_search_results);
}

if (isset($output_events)) {
   $body->set('events', $output_events);
}

if (isset($output_activity_search_results)) {
	$body->set('activity_search_results', $output_activity_search_results);
}

if (isset($output_my_events)) {
	$body->set('my_events', $output_my_events);
}

if (isset($output_latest_events)) {
	$body->set('latest_events', $output_latest_events);
}

if (isset($output_latest_activities)) {
	$body->set('latest_activities', $output_latest_activities);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($search)) {
	$body->set('search', $search);
}

if (isset($search_event_type_id)) {
	$body->set('search_event_type_id', $search_event_type_id);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_events)) {
   $body->set('events', $output_events);
}

$body->set('user_levels', $c_node['user_level_id']);

$template_pageLink = $lang['txt_events'];
include "inc/footer.inc.php";




/*
* searchEventItems
* Tom Calthrop 7th April 2004
*/
function searchEventItems ($search, $search_event_type_id) {

	global $db, $c_node, $me, $image, $date, $log;

	$query = "
		SELECT e.event_id, e.event_title, e.event_description, e.event_start_datetime,
		e.event_end_datetime, e.event_location, e.group_id, e.event_image_id
		FROM " . $db->prefix . "_event e
		WHERE
		e.event_title like '%" . $search . "%' or
		e.event_description like '%" . $search . "%'"
		;

	if($search_event_type_id != 0) {

		$query .= "and e.event_type_id=" . $search_event_type_id;
	}

	$query .= " order by e.event_title";

	//echo $query . "<br><br>";
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['event_start_datetime'] = $date->formatDate($temp1['event_start_datetime']);

			if (isset($temp1['event_image_id'])) {
			    $temp1['image'] = $image->getImage($temp1['event_image_id'], 't2', 'group', $temp1['group_id']);
			}

			//format search results
			$temp1['event_description'] = searchTextFormat($search, $temp1['event_description']);
			$temp1['event_title'] = searchTextFormat($search, $temp1['event_title']);

			array_push($temp, $temp1);

			$result->MoveNext();
		}

		$result->Close();
		return $temp;
	}
} //EO searchItems();


/*
* searchEventItems
* Tom Calthrop 7th April 2004
*/
function searchActivityItems ($search) {

	global $db, $c_node, $me, $date, $log;

	$query = "
		SELECT a.activity_id, a.activity_description, a.activity_start_datetime, a.activity_title, a.activity_total_required, a.event_id
		FROM " . $db->prefix . "_activity a
		WHERE
		a.activity_title like '%" . $search . "%' or
		a.activity_description like '%" . $search . "%'
		order by a.activity_title"
		;

	//echo $query . "<br><br>";
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;
			$temp1['activity_start_datetime'] = $date->formatDate($temp1['activity_start_datetime']);

			//format search results
			$temp1['activity_description'] = searchTextFormat($search, $temp1['activity_description']);
			$temp1['activity_title'] = searchTextFormat($search, $temp1['activity_title']);

			array_push($temp, $temp1);

			$result->MoveNext();
		}

		$result->Close();
		return $temp;
	}
} //EO searchItems();


function myEvents () {

	global $db, $me, $image, $log;

	$query = "
		SELECT distinct e.event_id, e.event_description, e.event_start_datetime,
		e.event_title, e.group_id, e.event_image_id
		FROM " . $db->prefix . "_activity_user au
		LEFT JOIN " . $db->prefix . "_activity a on au.activity_id=a.activity_id
		LEFT JOIN " . $db->prefix . "_event e on a.event_id=e.event_id
		where
		au.user_id=" . $me['user_id'] . "
		order by e.event_start_datetime"
	;


	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else if ($result) {

		$temp = array();

		while (!$result->EOF) {

			$temp1 = $result->fields;

			if (isset($temp1['event_image_id'])) {
			    $temp1['image'] = $image->getImage($temp1['event_image_id'], 't2', 'group', $temp1['group_id']);
			}

			//if it is a blog we get the newest item.
			if ($result->fields['event_id']) {
			    $query = "
					SELECT a.activity_id, a.activity_description, a.activity_start_datetime, a.activity_title, au.activity_user_status, a.activity_total_required
					FROM " . $db->prefix . "_activity_user au
					LEFT JOIN " . $db->prefix . "_activity a on au.activity_id=a.activity_id
					where
					au.user_id=" . $me['user_id'] . " and
					a.event_id=" . $result->fields['event_id'] . "
					order by a.activity_title"
					;
				//echo $query . "<br>";

				$result1 = $db->Execute($query);
				if (!$result1) {
					$error[]  = array('error', 1, $db->ErrorMsg());
				}
				else {
					$temp2 = array();
					while (!$result1->EOF) {
						array_push($temp2, $result1->fields);
						$result1->MoveNext();
					}
					$temp1['activities'] = $temp2;
				}
			}
			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}

function lastestEvents() {

	global $db, $image, $me, $date, $log;

	$query = "
		SELECT e.event_id, e.event_title, e.event_description, e.event_start_datetime,
		e.event_end_datetime, e.event_location, e.event_image_id, e.group_id
		FROM " . $db->prefix . "_event e
		order by e.event_title limit 20"
		;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {

			$temp1 = $result->fields;

			$temp1['event_start_datetime'] = $date->formatDate($temp1['event_start_datetime']);

			if (isset($temp1['event_image_id'])) {
			    $temp1['image'] = $image->getImage($temp1['event_image_id'], 't2', 'group', $temp1['group_id']);
			}

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();
		return $temp;

	}
}

function latestActivities() {

	global $db, $me, $date, $log;

	$query = "
		SELECT a.activity_id, a.activity_description, a.activity_start_datetime,
		a.activity_title, a.activity_total_required, a.event_id
		FROM " . $db->prefix . "_activity a
		order by a.activity_title limit 20"
		;

	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			$temp1['activity_start_datetime'] = $date->formatDate($temp1['activity_start_datetime']);

			array_push($temp, $temp1);
			$result->MoveNext();
		}

		$result->Close();

		return $temp;
	}
}


?>
