<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

$core = "group";
include "inc/header.inc.php";
require_once($c_node['class_dir'] . 'Group/Forum.class.php');


//setup image
$image->thumb = "t2";


$forum = new Forum($group_id);
$forum->db = $db;
$forum->user_id = $me['user_id'];
$forum->group_id = $group_id;
$forum->image = $image;
$forum->date = $date;


if (isset($_POST['search'])) {
	$search = trim($_POST['search_text']);
	$output_topic_search_results = searchTopics($group_id, $search);
	$output_subject_search_results = searchSubjects($group_id, $search);
	$display = "search";
}
else {
	$output_topics = $forum->sectionTopicList();
}


//move to template
if (isset($output_group_member_level)) {
	$body->set('group_member_level', $output_group_member_level);
}

if (isset($output_group)) {
	$body->set('group', $output_group);
}

if (isset($output_topics)) {
    $body->set('topics', $output_topics);
}

if (isset($output_topic_search_results)) {
	$body->set('topic_search_results', $output_topic_search_results);
}

if (isset($output_subject_search_results)) {
	$body->set('subject_search_results', $output_subject_search_results);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($search)) {
	$body->set('search', $search);
}

if (isset($output_group['group_title'])) {
    $template_pageLink = $lang['txt_forum'];
	$template_pageLinkNote = $output_group['group_title'];
}

include "inc/footer.inc.php";

/*
* searchEventItems
* Tom Calthrop 7th April 2004
*/
function searchTopics ($group_id, $search) {

	global $db, $c_node, $me, $image, $log;

	$query = "
		SELECT t.*
		FROM " . $db->prefix . "_forum_topic t
		left join " . $db->prefix . "_forum_section s ON s.section_id=t.section_id
		where
		(
		t.topic_title like '%" . $search . "%' or
		t.topic_body like '%" . $search . "%'
		) and
		s.group_id=" . $group_id . "
		order by t.topic_title"
	;

	//echo $query . "<br><br>";
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			if (isset($temp1['topic_image_id'])) {
				   $temp1['image'] = $image->getImage($temp1['topic_image_id']);
			}

			//format search results
			$temp1['topic_body'] = searchTextFormat($search, $temp1['topic_body']);
			$temp1['topic_title'] = searchTextFormat($search, $temp1['topic_title']);

			array_push($temp, $temp1);

			$result->MoveNext();
		}

		$result->Close();
		return $temp;
	}
} //EO searchTopics();


/*
* searchSubjects
* Tom Calthrop 10th April 2004
*/
function searchSubjects ($group_id, $search) {

	global $db, $c_node, $me, $image, $log;

	$query = "
		SELECT s.*
		FROM " . $db->prefix . "_forum_subject s
		left join " . $db->prefix . "_forum_topic t ON s.topic_id=t.topic_id
		left join " . $db->prefix . "_forum_section se ON se.section_id=t.section_id
		where
		(
		s.subject_title like '%" . $search . "%' or
		s.subject_body like '%" . $search . "%'
		) and
		se.group_id=" . $group_id . "
		order by s.subject_title"
	;

	//echo $query . "<br><br>";
	$result = $db->Execute($query);

	if (!$result) {
		$error[]  = array('error', 1, $db->ErrorMsg());
	}
	else {
		$temp = array();

		while (!$result->EOF) {
			$temp1 = $result->fields;

			if (isset($temp1['subject_image_id'])) {
				 $temp1['image'] = $image->getImage($temp1['subject_image_id']);
			}

			//format search results
			$temp1['subject_body'] = searchTextFormat($search, $temp1['subject_body']);
			$temp1['subject_title'] = searchTextFormat($search, $temp1['subject_title']);

			array_push($temp, $temp1);

			$result->MoveNext();
		}

		$result->Close();
		return $temp;
	}
} //EO searchSubjects();

?>
