<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2004 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------


/*
* auth user
* check current vote
* if current vote != option_id
* remove all defaults
* insert vote and set as default
* return to page
*
* Tom Calthrop, 13th May 2004
*/

include "config/config_server.inc.php";
include "config/config_aroundme.inc.php";
include "inc/functions.inc.php";


require_once($c_node['class_dir'] . 'Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection('mysql');
$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
$db->prefix = $c_node['db']['prefix'];


require_once($c_node['class_dir'] . 'Date.class.php');
$date = new Date();


require_once($c_node['class_dir'] . 'User/User.class.php');
$user = new User();
$user->relation_type = $c_node['relation_type']['approved'];
$user->db = $db;
$user->date = $date;

$user->authUser();


if (isset($_POST['option_id'])) {
    //setup data
	$user_id = $_SESSION['s_user_id'];
	$poll_id = $_POST['poll_id'];
	$option_id = $_POST['option_id'];


	//setup poll
	require_once($c_node['class_dir'] . 'Poll.class.php');
	$poll = new Poll();
	$poll->db = $db;
	$poll->date = $date;
	$poll->poll_id = $poll_id;


	$current_answer = $poll->pollUserCurrentVote($user_id);

	if (isset($current_answer) && $current_answer != $option_id) {
		//remove all defaults
		$query = "
			UPDATE " . $db->prefix . "_poll_answer SET
			current_answer=null
			WHERE
			poll_id=" . $poll_id . " and
			user_id=" . $user_id
		;
		$result = $db->Execute($query);

		//insert record
		$datetime = date("Y-m-d H:i:s");
		$datetime = $db->DBDate($datetime);

		$query = "
			INSERT INTO " . $db->prefix . "_poll_answer
			(user_id, poll_id, option_id, current_answer, answer_create_datetime) VALUES (
			" . $user_id . ",
			" . $poll_id . ",
			" . $option_id . ",
			1,
			" . $datetime . "
			)"
		;

		$result = $db->Execute($query);
	}
}

header("Location: " . $_POST['return_url']."&amp;".SID);
exit;

?>