<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_my.inc.php";

//append language setup
require_once($languageArrayPath . 'arr_language_name.lang.php');
require_once($languageArrayPath . 'arr_homepage.lang.php');


//setup user
unset($user->file); //images not required in this page


if (isset($_REQUEST['edit_membership'])) {
	$output_user['language_ids'] = $user->getLanguages();

	$display = "edit_membership";

}
elseif (isset($_REQUEST['update_membership'])) {
	
	$dob = $_POST['year']."-".$_POST['month']."-".$_POST['day'];
	$data['user_dob'] = $dob;
		
	//update profile
	$user->updateUser($data);
	
	if (empty($GLOBALS['am_error_log'])) {
		//update the user languages
		$user->deleteLanguages();
		$user->insertLanguages($data['language_ids']);
		$_SESSION['s_language_ids'] = $data['language_ids'];
	}
	
	if (empty($GLOBALS['am_error_log'])) {
		$output_user = $user->getUser();
		$output_user['template'] = $user->getTemplate($output_user['template_id']);
		$output_user['language_ids'] = $user->getLanguages();
		
		$display = "view_membership";
	}
	else {
		$output_user = $data;
		$display = "edit_membership";
	}
	
	
}
elseif (isset($_REQUEST['update_email'])) {
	//update email
	if(isset($data['user_email1']) && ($data['user_email1'] != $output_user['user_email'])) {
		if(empty($data['user_email1']) || empty($data['user_email2'])) {
			$GLOBALS['am_error_log'][] = array(2, null, null);
		}
	
		if($data['user_email1'] != $data['user_email2']) {
			$GLOBALS['am_error_log'][] = array(14, null, null);
		}
	
		if(!preg_match('/^[-A-Za-z0-9_.]+[@][A-Za-z0-9_-]+([.][A-Za-z0-9_-]+)*[.][A-Za-z]{2,8}$/', $data['user_email1'])) {
			$GLOBALS['am_error_log'][] = array(3, null, null);
		}
		
		if (empty($GLOBALS['am_error_log'])) {
			//check that the email is not already used
			$query = "
				SELECT user_id
				FROM " . $db->prefix . "_user
				WHERE user_email='" . $data['user_email1'] . "'"
			;
	
			$result = $db->Execute($query);
	
			if (isset($result) && empty($result->fields)) {
				//append class vars
				$user->aroundme_dir = "";
				$user->language_dir = $c_node['node']['template_default_name'];
	
				//get messaging texts
				require_once($languageTextPath . 'message.lang.php');
	
				//we now reset the password and send an email with the new login details
				$password = $user->createPassword();
				
				$tmp = md5($password);
		
				$feed_password = $user->createFeedPassword($tmp);
				
				unset ($data['user_password1'], $data['user_password2']);
	
				//set up mail
				require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');
				$mail = new PHPMailer();
				$mail->Host = 		$c_node['mail']['host'];
				$mail->Mailer = 	$c_node['mail']['mailer'];
				$mail->From = 		$c_node['mail']['no_reply_address'];
				$mail->FromName = 	$c_node['mail']['from_name'];
				$mail->WordWrap = 	$c_node['mail']['wordwrap'];
				$mail->Subject = 	$lang['subject_new_details'];
				$mail->AddReplyTo($c_node['mail']['no_reply_address'], $lang['subject_noreply']);
	
				$user->mail = $mail;
	
				$user->template_id = $data['template_id'];
				$user->emailVerification($password, $data['user_email1'], $data['user_firstname'], $data['language_id'], 'registration.txt.php', "");
			
				$query = "
					UPDATE " . $db->prefix . "_user SET 
					user_email = '" . $data['user_email1'] . "',
					user_password='" . $tmp . "',
					user_feed_password='" . $feed_password . "',
					status_id = " . $c_node['user']['status']['pending'] . " 
					WHERE
					user_id=" . $me['user_id']
				;
				
				$db->Execute($query);
				
				$user->logoffUser();
				header("Location: index.php");
				exit;
			}
		}
		else {
			$output_user['language_ids'] = $user->getLanguages();
			
			$display = "edit_membership";
		}
	}
}
else {

	$output_user['template'] = $user->getTemplate($output_user['template_id']);
	$output_user['language_ids'] = $user->getLanguages();
	
	$display = "view_membership";
}


//ACS check - we may not be allowed to set the network page as our homepage
if (!$user_acs->checkPermission($c_acs['arr_acs']['resource']['social_network'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	unset($lang['homepage']['page'][7]);
}


$output_template = $user->getTemplates();


//move to template
if (!empty($output_user)) {
   $body->set('user', $output_user);
}

if (isset($display)) {
   $body->set('display', $display);
}

if (!empty($output_template)) {
   $body->set('templates', $output_template);
}

$body->set('datedropdown', $date->dateDropdown($output_user['user_dob']));

include "inc/footer.inc.php";

?>
