<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";


//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_activity'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $output_group['group_id']."&amp;".SID);
	exit;
}


if (isset($_REQUEST['activity_id'])) {
	$activity_id = $_REQUEST['activity_id'];
}
else {
	header("Location: g_calendar.php?group_id=" . $_REQUEST['group_id'] . "&" . SID);
	exit;
}


if (isset($_REQUEST['task_id'])) {
	$task_id = $_REQUEST['task_id'];
}


require_once($c_node['dir']['class_path'] . 'Activity.class.php');
require_once($c_node['dir']['class_path'] . 'Bookmark.class.php');


//append language setup
require_once($languageArrayPath . 'arr_activity.lang.php');
require_once($languageArrayPath . 'arr_task_user_status.lang.php');
require_once($languageArrayPath . 'arr_user.lang.php');



//setup activities
require_once($c_node['dir']['class_path'] . 'Activity.class.php');
$activity = new Activity($db, $c_acs['arr_section']['group'], $date, $file);
$activity->section_item_id = $group_id;
$activity->task_user_status_ids = $c_node['activity']['task_user_status'];


if (isset($_REQUEST['withdraw_confirmation'])) {
	$activity->updateTaskUserStatus($_REQUEST['task_id'], $me['user_id'], $c_node['activity']['task_user_status']['withdrawn']);
	header("Location: g_activity.php?group_id=" . $group_id . "&activity_id=" . $activity_id . "&" . SID);
	exit;
}
elseif (isset($_REQUEST['task_apply_update'])) {
	$activity->updateTaskUserStatus($_REQUEST['task_id'], $me['user_id'], $c_node['activity']['task_user_status']['pending']);
	header("Location: g_activity.php?group_id=" . $group_id . "&activity_id=" . $activity_id . "&" . SID);
	exit;
}
elseif (isset($_REQUEST['task_apply'])) {
	$activity->insertTaskUserStatus($_REQUEST['task_id'], $me['user_id'], $c_node['activity']['task_user_status']['pending']);
	header("Location: g_activity.php?group_id=" . $group_id . "&activity_id=" . $activity_id . "&" . SID);
	exit;
}


$activity->activity_id = $activity_id;
$output_activity = $activity->getActivity();

$output_tasks = $activity->getTasks();


$user->profile_id = $output_group['member']['profile_id'];
$output_activity['author'] = $user->getProfile($output_activity['user_id']);




//get activity image
$file->noimage = $c_node['file']['image']['thumb'][2]['noimage'];

if (isset($output_activity['file_id'])) {
	$file->thumb = $c_node['file']['image']['thumb'][1]['name'];
	$file->file_id = $output_activity['file_id'];
	$output_activity['image'] = $file->getFileRecord();
}
else {
	$output_activity['image']['file_title'] = "";
	$output_activity['image']['file'] = $file->noimage;
}


//setup bookmarks
$bookmark = new Bookmark($db, $c_node['cms']['item_type']['group_activity'], $date, $user_id);
$bookmark->item_id = $activity_id;


//watching
$bookmark->bookmark_type = $c_node['bookmark']['type']['watch'];
//set or unset bookmarks
if (isset($_REQUEST['watch'])) {
	$bookmark->insertBookmark();
}
elseif (isset($_REQUEST['unwatch'])) {
	$bookmark->deleteBookmark();
}
//get and update bookmark
if ($bookmark->getBookmark()) {
	$bookmark->updateBookmark();
	$output_activity['bookmark']['watch'] = 1;
}

//recommended
$bookmark->bookmark_type = $c_node['bookmark']['type']['recommend'];
//set or unset bookmarks
if (isset($_REQUEST['recommend'])) {
	$bookmark->insertBookmark();
}
elseif (isset($_REQUEST['unrecommend'])) {
	$bookmark->deleteBookmark();
}
//get and update bookmark
if ($bookmark->getBookmark()) {
	$bookmark->updateBookmark();
	$output_activity['bookmark']['recommend'] = 1;
}



//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_activity)) {
	$body->set('activity', $output_activity);
}

if (!empty($output_tasks)) {
	$body->set('tasks', $output_tasks);
}

if (!empty($c_node['activity']['task_user_status'])) {
	$body->set('task_status_ids', $c_node['activity']['task_user_status']);
}


if (!empty($output_activity['activity_title'])) {
	$template_pageLink = $lang['txt_activity'];
	$template_pageLinkNote = $output_activity['activity_title'];
}


include "inc/footer.inc.php";

?>
