<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "config/config_aroundme.inc.php";
include "config/config_acs.inc.php";
include "inc/functions.inc.php";

if (isset($_REQUEST['feed'])) {
    //pull vars out of feed string
	$feedstring = $_REQUEST['feed'];
	$group_id = substr($_REQUEST['feed'],0,strpos($feedstring,'_'));
	$feed_user_pass = substr($_REQUEST['feed'],strpos($feedstring,'_')+1);
	
	$user_id = substr($feed_user_pass,6);
	$feedpass = substr($feed_user_pass,0,6);
	
	//SETUP RSS FEED
	include($c_node['dir']['class_path'] . 'Feedcreator.class.php');
	$rss = new UniversalFeedCreator();
	$rss->useCached();
	$rss->link = $_SERVER['HTTP_HOST'];
	$rss->syndicationURL = $_SERVER['HTTP_HOST'].$_SERVER['PHP_SELF'];
	
	

	// SETUP DATABASE -----------------------------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'Adodb/adodb.inc.php');
	$ADODB_CACHE_DIR = 'cache/Adodb';
	$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
	$db = NewADOConnection($c_node['db']['driver']);
	$db->Connect($c_node['db']['host'], $c_node['db']['user'] , $c_node['db']['pass'] , $c_node['db']['db']);
	$db->prefix = $c_node['db']['prefix'];
	
	
	//SETUP DATE -----------------------------------------------------------------------
	require_once($c_node['dir']['class_path'] . 'Date.class.php');
	$date = new Date();

	
	//we check that this person is who they say they are
	$query = "
		SELECT user_id
		FROM " . $db->prefix . "_user
		WHERE 
		user_id=" . $user_id . " AND 
		user_feed_password='" . $feedpass . "'"
	;
	
	$result = $db->Execute($query);
	
	//print_r($result);
	if (isset($result->fields['user_id'])) {//I am the correct user for this feed
		//am I a member of this group?
		//get group details
		require_once($c_node['dir']['class_path'] . 'Group.class.php');
		$group = new Group($db, $date, null);
		$group->user_id = $user_id;
		$group->registration_types = $c_node['group']['registration_type'];
		$group->group_id = $group_id;
		$output_group = $group->getGroup();
		
		//is the group status active
		if ($output_group['status_id'] == $c_node['group']['status']['active']) {
		
			$output_group['member'] = $group->getGroupMembership();
		
			if (!empty($output_group['member']['status_id']) && $output_group['member']['status_id'] == $c_node['group']['member_status']['active']) {
				//we are ok to recieve this feed
				$rss->title = $output_group['group_title'];
				$rss->description = $output_group['group_synopsis'];
				
				
				//setup blog
				require_once($c_node['dir']['class_path'] . 'Blog.class.php');
				$blog = new Blog($db, $c_acs['arr_section']['group'], $date, null);
				$blog->section_item_id = $group_id;
				$output_blogs = $blog->getBlogs();
				
				//setup polls
				require_once($c_node['dir']['class_path'] . 'Poll.class.php');
				$poll = new Poll($db, $c_acs['arr_section']['group'], $date, null);
				$poll->section_item_id = $group_id;
				$output_polls = $poll->getPolls();
				
				//setup library
				require_once($c_node['dir']['class_path'] . 'Library.class.php');
				$library = new Library($db, $c_acs['arr_section']['group'], $date, null);
				$library->section_item_id = $group_id;
				$output_library_items = $library->getLibraryItems();
				
				//setup forum
				require_once($c_node['dir']['class_path'] . 'Forum.class.php');
				$forum = new Forum($db, $c_acs['arr_section']['group'], $date, null);
				$forum->section_item_id = $group_id;
				$output_topics = $forum->getTopics(1, null);
				
			}
		}
	}

	
	//url
	$url = "http://" . $_SERVER['HTTP_HOST'];
	$url .= dirname ($_SERVER['PHP_SELF']);
	
	
	if (isset($output_blogs)) {
		$blog_url = $url . "/g_blog.php?group_id=" . $group_id . "&blog_id=";
		
		foreach($output_blogs as $key => $i):
		    $item = new FeedItem();
		    $item->title = $i['blog_title'];
		    $item->link = $blog_url . $i['blog_id'];
		    $item->description = $i['blog_synopsis'];
		    $item->date = $i['blog_create_datetime'];
		    $item->source = $_SERVER['HTTP_HOST']."/";
		    $item->author = "";
		    
		    $rss->addItem($item);
		endforeach;
	}
	
	if (isset($output_polls)) {
				
		$poll_url = $url . "/g_poll.php?group_id=" . $group_id . "&poll_id=";
		
		foreach($output_polls as $key => $i):
		    $item = new FeedItem();
		    $item->title = $i['poll_question'];
		    $item->link = $poll_url . $i['poll_id'];
		    $item->description = $i['poll_question'];
		    $item->date = $i['poll_create_datetime'];
		    $item->source = $_SERVER['HTTP_HOST']."/";
		    $item->author = "";
		    
		    $rss->addItem($item);
		endforeach;
	}
	
	if (isset($output_library_items)) {
		$library_url = $url . "/g_library.php?group_id=" . $group_id . "&library_id=";
		
		foreach($output_library_items as $key => $i):
		    $item = new FeedItem();
		    $item->title = $i['library_title'];
		    $item->link = $library_url . $i['library_id'];
		    $item->description = $i['library_synopsis'];
		    $item->date = $i['library_create_datetime'];
		    $item->source = $_SERVER['HTTP_HOST']."/";
		    $item->author = "";
		    
		    $rss->addItem($item);
		endforeach;
	}
	
	if (isset($output_topics)) {
		$forum_url = $url . "/g_forum_subject.php?group_id=" . $group_id . "&subject_id=";
		
		foreach($output_library_items as $key => $r):
			if (!empty($r['subjects'])) {
				foreach($r['subjects'] as $key => $i):
				    $item = new FeedItem();
				    $item->title = $i['subject_title'];
				    $item->link = $forum_url . $i['subject_id'];
				    $item->description = $i['subject_body'];
				    $item->date = $i['subject_create_datetime'];
				    $item->source = $_SERVER['HTTP_HOST']."/";
				    $item->author = "";
				    
				    $rss->addItem($item);
				endforeach;
			}
		endforeach;
	}
	
	//TIDY UP
	$db->Close();
	
	$rss->saveFeed("RSS1.0", "cache/feed/rss_feed_group" . $feed_user_pass . ".xml"); 
	
}

?>