<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";


//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_administration'], $c_acs['arr_acs']['privilege']['allow_access'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $output_group['group_id']."&amp;".SID);
	exit;
}


//append language setup
require_once($languageArrayPath . 'arr_user.lang.php');
require_once($languageArrayPath . 'arr_group.lang.php');
require_once($languageArrayPath . 'arr_language_name.lang.php');


//wiki setup
require_once($c_node['dir']['class_path'] . 'Wiki/Wiki.php');
$wiki =& new Text_Wiki();
$wiki->setRenderConf('xhtml', 'wikilink', 'view_url', 'g_library.php?group_id=' . $group_id . '&page=');
$wiki->setRenderConf('xhtml', 'wikilink', 'new_url', 'g_library_edit.php?group_id=' . $group_id . '&page=');
$wiki->setRenderConf('xhtml', 'image', 'base', $c_node['dir']['asset_path'] . 'group/');
$wiki->setRenderConf('xhtml', 'swf', 'base', $c_node['dir']['asset_path'] . 'group/');


if (isset($frmdata['save_overview']) || isset($frmdata['save_go_overview'])) {

	$frmdata['group_synopsis'] = htmlspecialchars($frmdata['group_synopsis']);
	$frmdata['group_title'] = htmlspecialchars($frmdata['group_title']);

	$group->updateGroup($frmdata);

	if (empty($GLOBALS['am_error_log'])) {

		if (isset($frmdata['save_go_overview'])) {
			header("Location: g_structure.php?group_id=" . $frmdata['group_id'] . "&".SID);
			exit;
		}
		else {
			header("Location: g_group_edit.php?group_id=" . $frmdata['group_id'] . "&".SID);
			exit;
		}
	}

}
elseif (isset($frmdata['save_rules']) || isset($frmdata['save_go_rules'])) {
	$frmdata['group_rules'] = htmlspecialchars($frmdata['group_rules']);

	$group->updateGroupRules($frmdata);

	if (empty($GLOBALS['am_error_log'])) {

		if (isset($frmdata['save_go_rules'])) {
			header("Location: g_structure.php?group_id=" . $frmdata['group_id'] . "&".SID);
			exit;
		}
		else {
			header("Location: g_group_edit.php?group_id=" . $frmdata['group_id'] . "&edit_group_rules=1&".SID);
			exit;
		}
	}
}
elseif (isset($_POST['update_categories'])) {
	$group->category_max = 5;
	$group->updateCategories($frmdata['group_category']);
	header("Location: g_group_edit.php?group_id=" . $group->group_id . "&edit_group_categories=1&".SID);
	exit;
}
elseif (isset($_REQUEST['edit_group_categories'])) {
	require_once($languageArrayPath . 'arr_category.lang.php');
	$output_group['categories'] = $group->selCategories();
	$display = "edit_group_categories";
}
elseif (isset($_REQUEST['edit_group_rules'])) {
	$display = "edit_group_rules";
}
elseif (isset($frmdata['preview_overview'])) {
		$output_group['group_home_synopsis'] = stripslashes($frmdata['group_home_synopsis']);
		$output_group['group_home_synopsis_preview'] = $wiki->transform($output_group['group_home_synopsis'], 'Xhtml');
}
elseif (isset($frmdata['preview_rules'])) {
		$output_group['group_rules'] = stripslashes($frmdata['group_rules']);
		$output_group['group_rules_preview'] = $wiki->transform($output_group['group_rules'], 'Xhtml');
		$display = "edit_group_rules";
}


$output_user = $user->getUser($me['user_id']);

//move to template
if (!empty($output_user)) {
	$body->set('user', $output_user);
}

if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (isset($display)) {
	$body->set('display', $display);
}

if (isset($arr_category['tree'])) {
	$body->set('arr_category', $arr_category['tree']);
}

$body->set('status_ids', $c_node['group']['status']);

$body->set('datedropdown', $date->dateDropdown($output_group['group_election_date'], null,null, 10, 20));

include "inc/footer.inc.php";

?>
