<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
// 
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
// -----------------------------------------------------------------------

include "inc/header_group.inc.php";


//ACS check
if (!$group_acs->checkPermission($c_acs['arr_acs']['resource']['group_rsp'], $c_acs['arr_acs']['privilege']['allow_edit'])) { //resourece_id, Priv_id
	header("Location: g_group.php?group_id=" . $group_id."&".SID);
	exit;
}


//append language setup
require_once($languageArrayPath . 'arr_rsp.lang.php');


//setup rsp
require_once($c_node['dir']['class_path'] . 'Rsp.class.php');
$rsp = new Rsp($db, null);
$rsp->group_id = $group_id;
$rsp->level_id = $c_node['rsp']['rsp_level']['group']['home'];

if (isset($_REQUEST['status_id']) && $_REQUEST['status_id'] > 0) {
	$status_id = $_REQUEST['status_id'];
	$rsp->rsp_status_id = $status_id;
}

//get subject ids -----------------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['forum'];
if (isset($data['subject_status'])) {
	foreach($data['subject_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_subject_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			if (isset($data['subject_sticky'][$key])) {
			    $rsp->updateRspItem($i, 1);
			}
			else {
				$rsp->updateRspItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_subject_delete)) {
	    $rsp->deleteRspItems($arr_subject_delete);
	}
}
$output_rsp_subjects = $rsp->selRspItems();
if (!empty($output_rsp_subjects)) {
	foreach($output_rsp_subjects as $key => $i):
		$rsp_subject_ids[] = $i['item_id'];
	endforeach;
}

//get group blog ids -----------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['blog'];
if (isset($data['blog_status'])) {
	foreach($data['blog_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_blog_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			if (isset($data['blog_sticky'][$key])) {
			    $rsp->updateRspItem($i, 1);
			}
			else {
				$rsp->updateRspItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_blog_delete)) {
	    $rsp->deleteRspItems($arr_blog_delete);
	}
}
$output_rsp_blogs = $rsp->selRspItems();
if (!empty($output_rsp_blogs)) {
	foreach($output_rsp_blogs as $key => $i):
		$rsp_blog_ids[] = $i['item_id'];
	endforeach;
}


//get library item ids --------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['library'];
if (isset($data['library_item_status'])) {
	foreach($data['library_item_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_library_item_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			if (isset($data['library_item_sticky'][$key])) {
			    $rsp->updateRspItem($i, 1);
			}
			else {
				$rsp->updateRspItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_library_item_delete)) {
	    $rsp->deleteRspItems($arr_library_item_delete);
	}
}
$output_rsp_library_items = $rsp->selRspItems();
if (!empty($output_rsp_library_items)) {
	foreach($output_rsp_library_items as $key => $i):
		$rsp_library_ids[] = $i['item_id'];
	endforeach;
}

//get file ids --------------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['file'];
if (isset($data['file_status'])) {
	foreach($data['file_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_file_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			if (isset($data['file_sticky'][$key])) {
			    $rsp->updateRspItem($i, 1);
			}
			else {
				$rsp->updateRspItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_file_delete)) {
	    $rsp->deleteRspItems($arr_file_delete);
	}
}
$output_rsp_files = $rsp->selRspItems();
if (!empty($output_rsp_files)) {
	foreach($output_rsp_files as $key => $i):
		$rsp_file_ids[] = $i['item_id'];
	endforeach;
}

//get poll ids ---------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['poll'];
if (isset($data['poll_status'])) {
	foreach($data['poll_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_poll_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			if (isset($data['poll_sticky'][$key])) {
			    $rsp->updateRspItem($i, 1);
			}
			else {
				$rsp->updateRspItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_poll_delete)) {
	    $rsp->deleteRspItems($arr_poll_delete);
	}
}
$output_rsp_polls = $rsp->selRspItems();
if (!empty($output_rsp_polls)) {
	foreach($output_rsp_polls as $key => $i):
		$rsp_poll_ids[] = $i['item_id'];
	endforeach;
}
//get activity ids ---------------------------------------------------
$rsp->rsp_item_type_id = $c_node['rsp']['item_type']['schedule'];
if (isset($data['activity_status'])) {
	foreach($data['activity_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_activity_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			if (isset($data['activity_sticky'][$key])) {
			    $rsp->updateRspItem($i, 1);
			}
			else {
				$rsp->updateRspItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_activity_delete)) {
	    $rsp->deleteRspItems($arr_activity_delete);
	}
}
$output_rsp_activities = $rsp->selRspItems();
if (!empty($output_rsp_activities)) {
	foreach($output_rsp_activities as $key => $i):
		$rsp_activity_ids[] = $i['item_id'];
	endforeach;
}
//get task ids ---------------------------------------------------
if (isset($data['task_status'])) {
	foreach($data['task_status'] as $key => $i):
		if ($i <= 0) {
		    $arr_task_delete[] = $key;
		}
		else {
			$rsp->item_id = $key;
			
			if (isset($data['task_sticky'][$key])) {
			    $rsp->updateRspItem($i, 1);
			}
			else {
				$rsp->updateRspItem($i);
			}
		}
	endforeach;
	
	if (isset($arr_task_delete)) {
	    $rsp->deleteRspItems($arr_task_delete);
	}
}
$output_rsp_tasks = $rsp->selRspItems();
if (!empty($output_rsp_tasks)) {
	foreach($output_rsp_tasks as $key => $i):
		$rsp_task_ids[] = $i['item_id'];
	endforeach;
}


//setup file
$file->noimage = $c_node['file']['image']['thumb'][3]['noimage'];
$file->thumb = $c_node['file']['image']['thumb'][3]['name'];


//setup forum
require_once($c_node['dir']['class_path'] . 'Forum.class.php');
$forum = new Forum($db, $c_node['rsp']['item_type']['forum'], $date, $file);
$forum->group_id = $group_id;


//setup blog
require_once($c_node['dir']['class_path'] . 'Blog.class.php');
$blog = new Blog($db, $c_node['rsp']['item_type']['blog'], $date, $file);
$blog->group_id = $group_id;


//library setup
require_once($c_node['dir']['class_path'] . 'Library.class.php');
$library = new Library($db, $c_node['rsp']['item_type']['library'], $date, $file);
$library->group_id = $group_id;


//activity setup
require_once($c_node['dir']['class_path'] . 'Schedule.class.php');
$activity = new Schedule($db, $c_node['rsp']['item_type']['schedule'], $date, $file);
$activity->group_id = $group_id;
$schedule->schedule_config = $c_node['schedule'];


// poll setup
require_once($c_node['dir']['class_path'] . 'Poll.class.php');
$poll = new Poll($db, $c_node['rsp']['item_type']['poll'], $date);
$poll->group_id = $group_id;


//get items
if (!empty($rsp_blog_ids)) {
	$blog->blog_ids = $rsp_blog_ids;
	$output_blogs = $blog->selBlogs();
}
//get subjects
if (!empty($rsp_subject_ids)) {
	$forum->subject_ids = $rsp_subject_ids;
	$output_subjects = $forum->selSubjects();
}
//get library items
if (!empty($rsp_library_ids)) {
	$library->module = "group";
	$library->library_item_ids = $rsp_library_ids;
	$output_library_items = $library->selLibraryItems();
}
//get activities
if (!empty($rsp_activity_ids)) {
	$activity->activity_ids = $rsp_activity_ids;
	$activity->schedule_type_id = $c_node['schedule']['type']['event'];
	$output_activities = $activity->selScheduleItems();
}
//get files
if (!empty($rsp_file_ids)) {
	$file->file_ids = $rsp_file_ids;
	$output_files = $file->getFiles();
}
//get polls
if (!empty($rsp_poll_ids)) {
	$poll->poll_ids = $rsp_poll_ids;
	$output_polls = $poll->selPolls();
}
//get tasks
if (!empty($rsp_task_ids)) {
	$activity->task_ids = $rsp_task_ids;
	$activity->schedule_type_id = $c_node['schedule']['type']['task'];
	$output_tasks = $activity->selScheduleItems();
}



//move to template
if (!empty($output_group)) {
	$body->set('group', $output_group);
}

if (!empty($output_blogs)) {
	$body->set('blogs', $output_blogs);
	$body->set('rsp_blogs', $output_rsp_blogs);
	
}

if (!empty($output_subjects)) {
	$body->set('subjects', $output_subjects);
	$body->set('rsp_subjects', $output_rsp_subjects);
}

if (!empty($output_library_items)) {
	$body->set('library_items', $output_library_items);
	$body->set('rsp_library_items', $output_rsp_library_items);
}

if (!empty($output_activities)) {
	$body->set('activities', $output_activities);
	$body->set('rsp_activities', $output_rsp_activities);
}

if (!empty($output_tasks)) {
	$body->set('tasks', $output_tasks);
	$body->set('rsp_tasks', $output_rsp_tasks);
}

if (!empty($output_files)) {
	$body->set('files', $output_files);
	$body->set('rsp_files', $output_rsp_files);
}

if (!empty($output_polls)) {
	$body->set('polls', $output_polls);
	$body->set('rsp_polls', $output_rsp_polls);
}

if (!empty($display)) {
	$body->set('display', $display);
}

if (isset($status_id)) {
    $body->set('status_id', $status_id);
}

include "inc/footer.inc.php";

?>
