/**
 * Some of these scripts were taken from wikipedia.org and were modified for DokuWiki
 */

/**
 * Some browser detection
 */
var clientPC  = navigator.userAgent.toLowerCase(); // Get client info
var is_gecko  = ((clientPC.indexOf('gecko')!=-1) && (clientPC.indexOf('spoofer')==-1)
                && (clientPC.indexOf('khtml') == -1) && (clientPC.indexOf('netscape/7.0')==-1));
var is_safari = ((clientPC.indexOf('AppleWebKit')!=-1) && (clientPC.indexOf('spoofer')==-1));
var is_khtml  = (navigator.vendor == 'KDE' || ( document.childNodes && !document.all && !navigator.taintEnabled ));
if (clientPC.indexOf('opera')!=-1) {
    var is_opera = true;
    var is_opera_preseven = (window.opera && !document.childNodes);
    var is_opera_seven = (window.opera && document.childNodes);
}


/**
 * apply tagOpen/tagClose to selection in textarea, use sampleText instead
 * of selection if there is none copied and adapted from phpBB
 *
 * @author phpBB development team
 * @author MediaWiki development team
 * @author Andreas Gohr <andi@splitbrain.org>
 * @author Jim Raynor <jim_raynor@web.de>
 */
 

function insertTags(tagOpen, tagClose, sampleText) {
	//alert(txtarea.value + "HH");
 
  
  // IE
  if(document.selection  && !is_gecko) {
    var theSelection = document.selection.createRange().text;
    var replaced = true;
    if(!theSelection){
      replaced = false;
      theSelection=sampleText;
    }
    txtarea.focus();
 
    // This has change
    text = theSelection;
    if(theSelection.charAt(theSelection.length - 1) == " "){// exclude ending space char, if any
      theSelection = theSelection.substring(0, theSelection.length - 1);
      r = document.selection.createRange();
      r.text = tagOpen + theSelection + tagClose + " ";
    } else {
      r = document.selection.createRange();
      r.text = tagOpen + theSelection + tagClose;
    }
    if(!replaced){
      r.moveStart('character',-text.length-tagClose.length);
      r.moveEnd('character',-tagClose.length);
    }
    r.select();
  // Mozilla
  } else if(txtarea.selectionStart || txtarea.selectionStart == '0') {
    var replaced = false;
    var startPos = txtarea.selectionStart;
    var endPos   = txtarea.selectionEnd;
    if(endPos - startPos) replaced = true;
    var scrollTop=txtarea.scrollTop;
    var myText = (txtarea.value).substring(startPos, endPos);
    if(!myText) { myText=sampleText;}
    if(myText.charAt(myText.length - 1) == " "){ // exclude ending space char, if any
      subst = tagOpen + myText.substring(0, (myText.length - 1)) + tagClose + " ";
    } else {
      subst = tagOpen + myText + tagClose;
    }
    txtarea.value = txtarea.value.substring(0, startPos) + subst +
                    txtarea.value.substring(endPos, txtarea.value.length);
    txtarea.focus();
 
    //set new selection
    if(replaced){
      var cPos=startPos+(tagOpen.length+myText.length+tagClose.length);
      txtarea.selectionStart=cPos;
      txtarea.selectionEnd=cPos;
    }else{
      txtarea.selectionStart=startPos+tagOpen.length;   
      txtarea.selectionEnd=startPos+tagOpen.length+myText.length;
      txtarea.scrollTop=scrollTop;
    }
  // All others
  } else {
    var copy_alertText=alertText;
    var re1=new RegExp("\\$1","g");
    var re2=new RegExp("\\$2","g");
    copy_alertText=copy_alertText.replace(re1,sampleText);
    copy_alertText=copy_alertText.replace(re2,tagOpen+sampleText+tagClose);
    var text;
    if (sampleText) {
      text=prompt(copy_alertText);
    } else {
      text="";
    }
    if(!text) { text=sampleText;}
    text=tagOpen+text+tagClose;
    //append to the end
    txtarea.value += "\n"+text;

    // in Safari this causes scrolling
    if(!is_safari) {
      txtarea.focus();
    }

  }
  // reposition cursor if possible
  if (txtarea.createTextRange) txtarea.caretPos = document.selection.createRange().duplicate();
}


/**
 * This function generates the actual toolbar buttons with localized text
 * we use it to avoid creating the toolbar where javascript is not enabled
 */
function formatButton(imageFile, speedTip, tagOpen, tagClose, sampleText, accessKey) {
  speedTip=escapeQuotes(speedTip);
  tagOpen=escapeQuotes(tagOpen);
  tagClose=escapeQuotes(tagClose);
  sampleText=escapeQuotes(sampleText);

  document.write("<a ");
  if(accessKey){
    document.write("accesskey=\""+accessKey+"\" ");
    speedTip = speedTip+' [ALT+'+accessKey.toUpperCase()+']';
  }
  document.write("href=\"javascript:insertTags");
  document.write("('"+tagOpen+"','"+tagClose+"','"+sampleText+"');\">");

  document.write("<img width=\"16\" height=\"16\" src=\""+
                baseImgURL+imageFile+"\" border=\"0\" alt=\""+
                speedTip+"\" title=\""+speedTip+"\" />");
  document.write("</a>");
  return;
}

/**
 * This function generates the actual toolbar buttons with localized text
 * we use it to avoid creating the toolbar where javascript is not enabled
 */
function insertButton(imageFile, speedTip, value, accessKey) {
  speedTip=escapeQuotes(speedTip);
  value=escapeQuotes(value);

  document.write("<a ");
  if(accessKey){
    document.write("accesskey=\""+accessKey+"\" ");
    speedTip = speedTip+' [ALT+'+accessKey.toUpperCase()+']';
  }
  document.write("href=\"javascript:insertAtCarret");
  document.write("(document.editform.wikitext,'"+value+"');\">");

  document.write("<img width=\"16\" height=\"16\" src=\""+
                baseImgURL+imageFile+"\" border=\"0\" alt=\""+
                speedTip+"\" title=\""+speedTip+"\" />");
  document.write("</a>");
  return;
}



/**
 * This function escapes some special chars
 */
function escapeQuotes(text) {
  var re=new RegExp("'","g");
  text=text.replace(re,"\\'");
  re=new RegExp('"',"g");
  text=text.replace(re,'&quot;');
  re=new RegExp("\\n","g");
  text=text.replace(re,"\\n");
  return text;
}



/*
 * Insert the given value at the current cursor position
 *
 * @see http://www.alexking.org/index.php?content=software/javascript/content.php
 */
function insertAtCarret(field,value){
  //IE support
  if (document.selection) {
    field.focus();
    if(opener == null){
      sel = document.selection.createRange();
    }else{
      sel = opener.document.selection.createRange();
    }
    sel.text = value;
  //MOZILLA/NETSCAPE support
  }else if (field.selectionStart || field.selectionStart == '0') {
    var startPos  = field.selectionStart;
    var endPos    = field.selectionEnd;
    var scrollTop = field.scrollTop;
    field.value = field.value.substring(0, startPos)
                  + value
                  + field.value.substring(endPos, field.value.length);

    field.focus();
    var cPos=startPos+(value.length);
    field.selectionStart=cPos;
    field.selectionEnd=cPos;
    field.scrollTop=scrollTop;
  } else {
    field.value += "\n"+value;
  }
  // reposition cursor if possible
  if (field.createTextRange) field.caretPos = document.selection.createRange().duplicate();
}


var displayType;
//OUTPUT BAR
if (displayType == 'comment') {
	formatButton('gui_wiki_b.png','Bold Text','\'\'\'','\'\'\'','Bold Text','b');           
	formatButton('gui_wiki_i.png','Italic Text','\'\'','\'\'','Italic Text','i');
	formatButton('gui_wiki_tt.png','TeleType Text','{{','}}','TeleType Text','t');
	formatButton('gui_wiki_code.png','Code Text','<code>','</code>','Code Text','c'); 
} else {
	formatButton('gui_wiki_b.png','Bold Text','\'\'\'','\'\'\'','Bold Text','b');           
	formatButton('gui_wiki_i.png','Italic Text','\'\'','\'\'','Italic Text','i');
	formatButton('gui_wiki_h1.png','Level 1 Headline','\n+ ','','Level 1 Headline','1');
	formatButton('gui_wiki_h2.png','Level 2 Headline','\n++ ','','Level 2 Headline','2');
	formatButton('gui_wiki_h3.png','Level 3 Headline','\n+++ ','','Level 3 Headline','3');
	formatButton('gui_wiki_h4.png','Level 4 Headline','\n++++ ','','Level 4 Headline','4');
	formatButton('gui_wiki_h5.png','Level 5 Headline','\n+++++ ','','Level 5 Headline','5');    
	formatButton('gui_wiki_tt.png','TeleType Text','{{','}}','TeleType Text','t');
	formatButton('gui_wiki_code.png','Code Text','<code>','\n</code>','Code Text','c'); 
	formatButton('gui_wiki_centre.png','Centre Text','\n= ','','Centre Text','-');
	formatButton('gui_wiki_ol.png','Ordered List Item','# ','\n','Ordered List Item');
	formatButton('gui_wiki_ul.png','Unordered List Item','* ','\n','Unordered List Item');
	formatButton('gui_wiki_colour.png','Colour Text (Press [?] for colour selection)','##color|','##','Colour Text');
	insertButton('gui_wiki_hr.png','Horizontal Rule','----\n');
	formatButton('gui_wiki_file.png','WikiFile (Press [?] for list of WikiFile names)','[[image ',']]','WikiPage_name');
	formatButton('gui_wiki_a.png','WikiPage (Press [?] for list of WikiLink names)','[',']','WikiFile Text');
}