<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2006 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>
<!DOCTYPE html
PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="Content-Language" content="<?php echo $language_arr[0];?>" />
<meta name="keywords" content="<?php echo $lang['meta_keywords'];?>" />
<meta name="OriginalPublicationDate" content="<?php echo $lang['meta_OriginalPublicationDate'];?>" />
<meta name="Description" content="<?php echo $lang['meta_Description'];?>" />

<title><?php echo $lang['txt_page_title'];?></title>
<style type="text/css">
<!--
@import url(<?php echo $template_path_core;?>css/aroundme_default.css);

-->
</style>
<!--[if IE]>
<style type="text/css">
@import url(<?php echo $template_path_core;?>css/aroundme_default-IE.css);
</style>
<![endif]-->


<?php
//we reload an image in this template just before the session times out to
//make sure that the session does not time out
$session_maxlifetime = ini_get('session.gc_maxlifetime'); // in seconds

// we need to warn 2 minutes before
$session_warning_time = 120; // seconds
if ($session_maxlifetime > $session_warning_time) {
	$session_maxlifetime = $session_maxlifetime-$session_warning_time;
}
$session_maxlifetime_ms = $session_maxlifetime*1000; // in milliseconds
?>


<script type="text/javascript" src="<?php echo $template_path_core;?>js/functions.js"></script>
<script type="text/javascript">
	var baseImgURL = '<?php echo $template_path_core;?>img/';
</script>


<script type="text/javascript">
var session_maxlifetime_ms = <?php echo $session_maxlifetime_ms;?>;

function ShowTimeoutWarning () {
	// we append the time to the string to avoid caching
	var urldate = new Date()
	var urltime = urldate.getTime()
	document.session_reload_image.src = 'get_file.php?file=session_reload_image.png&reloadsession=start&now=' + urltime;
	setTimeout( 'ShowTimeoutWarning();', session_maxlifetime_ms );
}

</script>

</head>


<body onLoad="setTimeout( 'ShowTimeoutWarning();', session_maxlifetime_ms );">


<div id="layout">
	<div id="header">
		<div class="masthead">
			<div class="menu">
				<?php
				if (isset($_SESSION['user_id']) && $_SESSION['user_id'] > 0) {
				?>
				
				<?php echo $_SESSION['user_firstname'];?>:&nbsp;
				
				<?php
 				if (isset($_SESSION['mail']) && $_SESSION['mail'] > 0) {
				?>
				<a href="index.php?amn=core_msg_list"><img src="<?php echo $template_path_core;?>img/unopenned_mail.png" alt="" border="0" /></a>&nbsp;(<a href="index.php?amn=core_msg_list"><?php echo $_SESSION['mail'];?></a>)&nbsp;
				<?php }?>
				
				<?php
				$url = "#";
				
				if (empty($_POST) && $page_name_short != "maint_contact_view" && $page_name_short != "maint_contact_list") {
					$url = $_SERVER['REQUEST_URI'];
					if (substr($url, -4) == ".php") {
						$url .= "?";
					}
					else {
						$url .= "&amp;";
					}
					$url .= "abuse_report=1&nbsp;";
				}
				?>
				
				<a href="<?php echo $url;?>"><?php echo $lang['href_report_abuse'];?></a>
				
				<?php
				if (!empty($_SESSION['outstanding_announcements'])) {
				?>
				&nbsp;
				<a href="index.php?amn=core_ann_list"><img src="<?php echo $template_path_core;?>img/announce.png" alt="" border="0" /></a>&nbsp;(<a href="index.php?amn=core_ann_list"><?php echo $_SESSION['outstanding_announcements'];?></a>)
				<?php }?>
				
				&nbsp;
				<a href="index.php?logoff=1"><?php echo $lang['href_logoff'];?></a>
				
				<?php
				if (!empty($_SESSION['outstanding_contact_reports'])) {
				?>
				&nbsp;
				<a href="index.php?amn=core_maint_contact_list"><img src="<?php echo $template_path_core;?>img/alert.png" id="contact_report" alt="" border="0" /></a>&nbsp;(<a href="index.php?amn=core_maint_contact_list"><?php echo $_SESSION['outstanding_contact_reports'];?></a>)
				<?php }?>

				
				<?php }?>
				<br />
			</div>
			
			<div style="text-align:left;padding: 9px;">
				<a href="<?php if (isset($_SESSION['user_homepage'])) { echo $_SESSION['user_homepage'];} else { echo "index.php";}?>"><img src="<?php echo $template_path_core;?>img/aroundme.png" width="142" height="43" alt="" border="0" /></a>
			</div>
		</div>
	
		<div id="main_menu">
			<div class="content">
				<p>
					<?php
					if (isset($section) && $section == "me") {
						echo $lang['menu_main_me'];
					}
					else {
						echo "<a href='index.php?amn=core_me_view'>" . $lang['menu_main_me'] . "</a>";
					}
					?><br />
				</p>
				
				<p>
					<?php
					if (isset($section) && $section == "structure") {
						echo $lang['menu_main_structure'];
					}
					else {
						echo "<a href='index.php?amn=core_structure'>" . $lang['menu_main_structure'] . "</a>";
					}
					?><br />
				</p>
			</div>
		</div>
	
		<div id="sub_menu">
			<div class="content">
				<?php
				if (isset($section)) {
					include_once($template_path . "inc/menu_" . $section . ".inc.php");
				}
				?>
			</div>
		</div>
	
		<div class="box_bottom">
			<span class="box_bottom_right"></span>
			<span class="box_bottom_left"></span>
		</div>
	</div>

	<?php
	if (!empty($GLOBALS['am_error_log'])) {
	?>
	<div class="system_message">
		<?php
		foreach($GLOBALS['am_error_log'] as $key => $i):
		?>
		<p>
			<?php 
			if (isset($lang['error'][$i[0]])) {
				echo $lang['error'][$i[0]];
			}
			else {
				echo $i[0];
			}
			
			if (!empty($i[1])) {
				echo ": " . $i[1];
			}?>
			<br />
		</p>
		<?php
		endforeach;
		?>
	</div>
	<?php }?>


	<div id="content">
		<?php echo $content;?>
	</div>

	<div id="footer">
		<!-- under our free license policy you are allowed to remove this, however we would like it if you chose 
		to promote us through including the following text and link  -->
		<?php echo $lang['txt_footer'];?><br />
	</div>
	
	<img name="session_reload_image" src="get_file.php?file=0-session_reload_image.png" alt="" />
	
	<?php
	if (isset($GLOBALS['am_debug_output'])) {
	?>
	<div id="debug_mode">
		SYS_DEBUG_MODE_OUTPUT
	</div>
	<?php }?>
</div>
</body>
</html>

