<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



// MODULE HEADER INCLUSION -----------------------------------------------
// We include any header files for the modules
if (empty($suffix)) {
	$suffix = "core";
}

if (is_file("components/" . $suffix . "/inc/" . $suffix . "_participation.header.php")) {
	include_once("components/" . $suffix . "/inc/" . $suffix . "_participation.header.php");
}


if (isset($_SESSION['md5'])) {
	
	if (isset($_POST['accept_invite'])) {
		$query = "
			SELECT user_id, identity_id, role_id, status_id,
			participation_permission,  invitee_user_id
			FROM " . $db->prefix . "_participation 
			WHERE 
			item_id=" . $output_item['item_id'] . " AND
			module_id=" . $module_id . " AND
			user_id=" . $_SESSION['user_id']
		;
		
			
		$result = $db->Execute($query);
		$invitee_user_id = $result->fields['invitee_user_id'];
				
		if (isset($result->fields)) {
			$rec = array();
			$rec['identity_id'] = $_POST['identity_id'];
			$rec['status_id'] = $core_config['participation']['status']['active'];
			
			$query = $db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			$result = $db->Execute($query);
		}
		
		$query = "
			SELECT i.identity_nic
			FROM " . $db->prefix . "_user_identity i
			WHERE i.identity_id=" . $_POST['identity_id']
		;
		$result = $db->Execute($query);
		
		$identity_nic = $result->fields['identity_nic'];
		$result->Close();
	
		//Someone invited me so i have to send that user a message, added by sebastian at 070215
		$query = "
			SELECT p.identity_id, p.module_id, p.item_id, i.identity_nic
			FROM " . $db->prefix . "_participation p
			INNER JOIN " . $db->prefix . "_user_identity i
			ON p.identity_id=i.identity_id
			WHERE p.module_id=" . $module_id . " AND 
			p.item_id=" . $output_item['item_id'] . " AND
			p.user_id=" . $invitee_user_id
		;

		$result = $db->Execute($query);
		
		if (isset($result->fields)) {
			
			$msg_body = readTxtFile($language_path_core . "texts/im_invitee_joined.txt.php");
			$msg_body = str_replace("SYS_KEYWORD_NAME", $identity_nic, $msg_body);
			
			// we include all module files which have a function to obtain a single item
			// module_id 1 will include a function called -selItemModule1
			if (!empty($core_config['module'])) {
				foreach($core_config['module'] as $key => $i):
					$suffix = $core_config['module'][$key]['prefix'];
					if(is_file("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php")) {
						include_once("components/" . $suffix . "/inc/" . $suffix . "_item_select.function.php");
					}
				endforeach;
			}
			
			//We need to get the item i invited the person to
			$suffix = $core_config['module'][$result->fields['module_id']]['prefix'];
			$function_name = "selItemModule_" . $suffix;

			if (function_exists($function_name)) {
				$invitee_item = $function_name($result->fields['item_id']);
				$msg_body = str_replace("SYS_KEYWORD_ITEM", $invitee_item['item_title'], $msg_body);
				$msg_body = str_replace("SYS_KEYWORD_URL", $invitee_item['item_url'], $msg_body);
			}

			$im = new Message($invitee_user_id, $db, $core_config['messaging']);
			
			$msg = array();
			$msg['from_identity_id'] = $_POST['identity_id'];
			$msg['to_identity_id'] = $result->fields['identity_id'];
			$msg['message_subject'] = $lang['txt_joined'];
			$msg['message_body'] = $msg_body;
			
			$im->sendMessage($msg);
		}
		$result->Close();
		
		header("Location: " . $item_url . "&" . strip_tags(SID));
		exit;
		
	}
	elseif (isset($_POST['my_participation_insert'])) { // we are joining
		if (empty($_POST['identity_id'])) {
			$GLOBALS['am_error_log'][] = array('identity_empty');
		}
	
		if (empty($GLOBALS['am_error_log'])) {
			$participation->item_id = $_POST['item_id'];
			
			if ($output_item['item_type'] == $item_config['type']['approved']) {
				$_POST['status_id'] = $core_config['participation']['status']['pending'];
			}
			else {
				$_POST['status_id'] = $core_config['participation']['status']['active'];
			}
			
			$_POST['participation_permission'] = $output_item['default_user_permission'];
			
			$participation->user_id = $_SESSION['user_id'];
			
			$participation->insertParticipant($_POST);
			
			header("Location: " . $item_url . "&" . strip_tags(SID));
			exit;
		}
	}
	elseif (isset($_POST['my_participation_activate'])) {
		$participation->setUserStatus($output_participation['identity_id'], $core_config['participation']['status']['active']);
		
		header("Location: " . $item_url . "&" . strip_tags(SID));
		exit;
	
	}
	elseif (isset($_POST['my_participation_withdraw'])) {
		$participation->setUserStatus($output_participation['identity_id'], $core_config['participation']['status']['withdrawn']);
		
		header("Location: " . $item_url . "&" . strip_tags(SID));
		exit;
	
	}
	elseif (isset($_POST['remove_relations'])) {
		$participation->deleteRelations($_POST['identity_ids'], $output_participation['identity_id']);
	}
	
	
	require_once ("components/core/class/File.class.php");
	$file = new File($db, $core_config['file']);
	$file->user_id = $_SESSION['user_id'];
	$file->module_id = 0; // core
	$file->directory = "core";
	$user->file = $file;
	$user->file->no_image = $core_config['file']['image']['thumb'][2]['no_image'];
	$user->file->thumb = $core_config['file']['image']['thumb'][2]['suffix'];
	
	
	// INVITATION
	if (isset($output_participation) && $output_participation['status_id'] == $core_config['participation']['status']['invite']) {
		
		if ($output_item['item_type'] == $item_config['type']['invitation'] && empty($output_participation['invitee_user_id'])) {
			header("Location: " . $item_url . "&" . strip_tags(SID));
			exit;
		}
		
		unset ($body->vars['participation']);
		
		$body->set('invite', 1);
	
		// get user identities for join dropdown
	
		$output_identities = $user->selUserIdentities($_SESSION['user_id'], 1);
		$body->set('identities', $output_identities);
		
		if (!empty($output_participation['invitee_user_id'])) {
			$output_invitee = $user->selUserIdentity($output_participation['invitee_user_id']);
			$body->set('invitee_identity', $output_invitee);
		}
	}
	elseif (isset($output_participation)) { 
		// SELECT PARTICIPANTS --------------------------------------------------------
		$output_participants = $participation->selParticipants($core_config['participation']['status']['active']);
		
		// SELECT PARTICIPANTS IDENTITIES ---------------------------------------------
		if (!empty($output_participants)) {
			// get their ids
			if (!empty($output_participants)) {
				foreach ($output_participants as $key => $i):
					$user->identity_ids[] = $i['identity_id'];
				endforeach;
				
				$user->identity_ids = array_unique($user->identity_ids);
				
				if (!empty($user->identity_ids)) {
					$output_identities = $user->selUserIdentities();
					
					// we place the identities against the participants
					if (!empty($output_identities)) {
						foreach ($output_participants as $keyp => $p):
							foreach ($output_identities as $keyi => $i):
								if ($p['identity_id'] == $i['identity_id']) {
									$output_participants[$keyp]['identity'] = $i;
									break;
								}
							endforeach;
						endforeach;
					}

					unset($output_identities);
					
					$body->set('participants', $output_participants);
				}
			}
		}
	}
	else {
		// we display join screen
		$output_identities = $user->selUserIdentities($_SESSION['user_id'], 1);
		$body->set('identities', $output_identities);
	}

	$lang['txt_select_identity'] = str_replace('SYS_KEYWORD_MODULE_NAME', $lang['item_type_desc'][$output_item['item_type']],$lang['txt_select_identity']);
}
else {
	header('location: index.php');
	exit;
}
?>
