<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

include dirname(__FILE__) . "/../components/core/config/aroundme_core.config.php";
include "config/batch.config.php";


// SETUP DATABASE --------------------------------------------------------
require_once(dirname(__FILE__) . '/../components/core/class/Adodb/adodb.inc.php');
$ADODB_CACHE_DIR = 'cache/Adodb';
$ADODB_FETCH_MODE = ADODB_FETCH_BOTH;
$db = NewADOConnection($core_config['db']['driver']);
if ($db->Connect($core_config['db']['host'], $core_config['db']['user'] , $core_config['db']['pass'] , $core_config['db']['db'])) {
	$db->prefix = $core_config['db']['prefix'];
	
	
	$chart           = ImageCreate($batch_config['24_hour_activity']['width'], $batch_config['24_hour_activity']['height']);
	$backgroundcolor = ImageColorAllocate($chart, $batch_config['24_hour_activity']['color']['grids_background']['red'], $batch_config['24_hour_activity']['color']['grids_background']['green'], $batch_config['24_hour_activity']['color']['grids_background']['blue']);
	$gridscolor      = ImageColorAllocate($chart, $batch_config['24_hour_activity']['color']['grids']['red'], $batch_config['24_hour_activity']['color']['grids']['green'], $batch_config['24_hour_activity']['color']['grids']['blue']);
	$gridscolor_bg   = ImageColorAllocate($chart, $batch_config['24_hour_activity']['color']['grids_background']['red'], $batch_config['24_hour_activity']['color']['grids_background']['green'], $batch_config['24_hour_activity']['color']['grids_background']['blue']);
	$foregroundcolor = ImageColorAllocate($chart, $batch_config['24_hour_activity']['color']['foreground']['red'], $batch_config['24_hour_activity']['color']['foreground']['green'], $batch_config['24_hour_activity']['color']['foreground']['blue']);
	$chart_bg = ImageColorAllocate($chart, $batch_config['24_hour_activity']['color']['background']['red'], $batch_config['24_hour_activity']['color']['background']['green'], $batch_config['24_hour_activity']['color']['background']['blue']);
	
	
	$y_values = array(); $i=0;
	while ($i < 25) { // we need to init $y_values
		array_push($y_values, array('hour' => $i++, 'nr_of_hours' => 0));
	}
	
	// We select the data needed for the image ----------------------------------------------
	$query = "
		SELECT HOUR(session_lastused) AS hour, 
		COUNT(HOUR(session_lastused)) AS nr_of_hours
		FROM " . $db->prefix . "_user_session
 		GROUP BY HOUR(session_lastused)"
 	;
 	
	$result = $db->Execute($query);
	$max_val = 0;
			
	if (isset($result)) {
		while(!$result->EOF) {
			$max_val = $max_val >= $result->fields['nr_of_hours'] ? $max_val : $result->fields['nr_of_hours'];
			$y_values[$result->fields['hour']] = $result->fields;
			$result->moveNext();
		}
		$result->Close();
	}
	// ----------------------------------------------------------------------------------------
	
	$z = intval(($batch_config['24_hour_activity']['width'] - $batch_config['24_hour_activity']['padding']['left'] - $batch_config['24_hour_activity']['padding']['right']) / 24);
	$f = ($batch_config['24_hour_activity']['height'] - $batch_config['24_hour_activity']['padding']['top']*2 - $batch_config['24_hour_activity']['padding']['bottom']) / $max_val;
	imagefilledrectangle($chart, $batch_config['24_hour_activity']['padding']['left']+1, 0, $batch_config['24_hour_activity']['width'], $batch_config['24_hour_activity']['height'] - 2*$batch_config['24_hour_activity']['padding']['bottom'], $chart_bg);
	

	for($i = 0; $i <= 23; $i++) {
		$x1 = $z*$i + $batch_config['24_hour_activity']['padding']['left'];
		$x2 = $z*($i + 1) + $batch_config['24_hour_activity']['padding']['left'];
		$y1 = isset($y_values[$i]['nr_of_hours']) ? $y_values[$i]['nr_of_hours'] : 0;
		$y2 = isset($y_values[$i+1]['nr_of_hours']) ? $y_values[$i+1]['nr_of_hours'] : 0;
		imageline($chart, $x1, $batch_config['24_hour_activity']['height'] - $f*$y1 - $batch_config['24_hour_activity']['padding']['top'] - $batch_config['24_hour_activity']['padding']['bottom'], $x2, $batch_config['24_hour_activity']['height'] - $f*$y2 - $batch_config['24_hour_activity']['padding']['top'] - $batch_config['24_hour_activity']['padding']['bottom'], $foregroundcolor);
	}
	
	// we draw the axis --------------------------------------
// 	imagefilledrectangle($chart, 0, 0, $batch_config['24_hour_activity']['padding']['left'], $batch_config['24_hour_activity']['height'], $gridscolor_bg);
// 	imagefilledrectangle($chart, 0, $batch_config['24_hour_activity']['height'] - 2*$batch_config['24_hour_activity']['padding']['bottom'], $batch_config['24_hour_activity']['width'], $batch_config['24_hour_activity']['height'], $gridscolor_bg);
	
	imageline($chart, 1 + $batch_config['24_hour_activity']['padding']['left'], 1 + $batch_config['24_hour_activity']['padding']['top'] , 1 + $batch_config['24_hour_activity']['padding']['left'], $batch_config['24_hour_activity']['height'] - $batch_config['24_hour_activity']['padding']['top'] - $batch_config['24_hour_activity']['padding']['bottom'], $gridscolor);
	imageline($chart, 1 + $batch_config['24_hour_activity']['padding']['left'], $batch_config['24_hour_activity']['height'] - $batch_config['24_hour_activity']['padding']['top'] - $batch_config['24_hour_activity']['padding']['bottom'], $batch_config['24_hour_activity']['width'] - $batch_config['24_hour_activity']['padding']['right'], $batch_config['24_hour_activity']['height'] - $batch_config['24_hour_activity']['padding']['top'] - $batch_config['24_hour_activity']['padding']['bottom'], $gridscolor);
	imageline($chart, 1 + $batch_config['24_hour_activity']['padding']['left'], $batch_config['24_hour_activity']['height'] / 2, $batch_config['24_hour_activity']['padding']['left'] + 4, $batch_config['24_hour_activity']['height'] / 2, $gridscolor);
	imageline($chart, 1 + $batch_config['24_hour_activity']['padding']['left'], $batch_config['24_hour_activity']['padding']['top'], 5 + $batch_config['24_hour_activity']['padding']['left'], $batch_config['24_hour_activity']['padding']['left'], $gridscolor);

	for ($i = 0; $i <= 24; $i++) {
		if ($i != 0) {
			imageline($chart, $i*$z + $batch_config['24_hour_activity']['padding']['left'], $batch_config['24_hour_activity']['height'] - $batch_config['24_hour_activity']['padding']['top'] - $batch_config['24_hour_activity']['padding']['bottom'], $i*$z + $batch_config['24_hour_activity']['padding']['left'], $batch_config['24_hour_activity']['height'] - 2 - $batch_config['24_hour_activity']['padding']['top'] - $batch_config['24_hour_activity']['padding']['bottom'], $gridscolor);
		}
		if ($i == 0 || $i == 12 || $i == 24) {
			imagestring($chart, 1, $i*$z + $batch_config['24_hour_activity']['padding']['left'], $batch_config['24_hour_activity']['height'] - $batch_config['24_hour_activity']['padding']['top'] - $batch_config['24_hour_activity']['padding']['bottom'], $i, $gridscolor);
		}
	}
	imagestring($chart, 0, 0, $batch_config['24_hour_activity']['padding']['top'], intval($max_val/0.75), $gridscolor);
	
	// -------------------------------------------------------
	imagestring($chart, 1, $batch_config['24_hour_activity']['padding']['left'], $batch_config['24_hour_activity']['height'] - 10, date('Y-m-d h:i:s'), $gridscolor);
	imagepng($chart, $batch_config['24_hour_activity']['name']); 
	imageDestroy($chart);
	// ----------------------------------------------------------------------------------------

}
// -----------------------------------------------------------------------

?>