<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Tag {
	
	// Tag --------------------------------------------------------------------
	// the constuctor
	// tom calthrop - 23rd July 2005
	//
	function Tag($db, $module_id=null, $tag_type=null) {
		$this->db = $db;
		$this->module_id = $module_id;
		$this->tag_type = $tag_type;
	}//EO Tag

	
	
	// selTags --------------------------------------------------------------------
	// returns tag array
	// tom calthrop - 23rd July 2005
	//
	function selTags($meta=null) {
		if (isset($meta)) {
			// used for tag clouds
			$query = "
				SELECT count(t.tag_id) as total, t.tag_id, t.item_id, t.tag_body, t.user_id 
				FROM " . $this->db->prefix . "_tag t 
				WHERE "
			;
		}
		else {
			$query = "
				SELECT DISTINCT 
				t.tag_id, t.item_id, t.tag_body, t.user_id 
				FROM " . $this->db->prefix . "_tag t 
				WHERE "
			;
		}
		
		
		if (isset($this->item_id)) {
			$query .= "t.item_id=" . $this->item_id . " AND ";
		}
		
		if (isset($this->inner_item_id)) {
			$query .= "t.inner_item_id=" . $this->inner_item_id . " AND ";
		}
		
		if (isset($this->module_id)) {
			$query .= "t.module_id=" . $this->module_id . " AND ";
		}
		
		if (isset($this->user_id)) {
			$query .= "t.user_id=" . $this->user_id . " AND ";
		}
		
		if (isset($this->level_id)) {
			$query .= "t.level_id=" . $this->level_id . " AND ";
		}
		
		$query .= "1=1 ";
		
		if (isset($meta)) {
			$query .= "GROUP BY t.tag_body";
		}
		elseif (isset($this->order_by)) {
		    $query .= "order by " . $this->order_by;
		}
		else {
			$query .= "order by t.tag_body";
		}
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {
				$temp1 = $result->fields;
				array_push($temp, $temp1);
				$result->MoveNext();
			}
			
			return $temp;
			
		}
		else {
			$error_info = "function=selTags class=Tag.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selTags

	
	
	// selTag --------------------------------------------------------------------
	// returns tag array
	// tom calthrop - 23rd July 2005
	//
	function selTag($tag_id) {
		$query = "
			SELECT t.tag_id, t.item_id, t.tag_body, t.user_id 
			FROM " . $this->db->prefix . "_tag t 
			WHERE 
			t.tag_id=" . $tag_id
		;
		
		$result = $this->db->Execute($query);

		if (isset($result->fields)) {
			return $result->fields;
		}
		else {
			$error_info = "function=selTag class=Tag.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO selTag
	
	
	
	// insertTag --------------------------------------------------------------------
	// inserts tag
	// tom calthrop - 23rd July 2005
	//
	function insertTag($tag_body) {

		$rec = array();
		$rec['tag_body'] = trim(strip_tags($tag_body));
		
		if (isset($this->user_id)) {
			$rec['user_id'] = $this->user_id;
		}
		
		$rec['module_id'] = $this->module_id;
		$rec['item_id'] = $this->item_id;
		
		if (isset($this->inner_item_id)) {
			$rec['inner_item_id'] = $this->inner_item_id;
		}
		
		if (isset($this->level_id)) {
			$rec['level_id'] = $this->level_id;
		}
		
				
		$table = $this->db->prefix . "_tag";
				
		$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
		//echo $query;
		$result = $this->db->Execute($query);
			
		if (empty($result)) {
			$error_info = "function=insertTag class=Tag.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
	}//EO insertTags
	


	// deleteTag --------------------------------------------------------------------
	// deletes a tag
	// tom calthrop - 3rd December 2005
	//
	function deleteTag($tag_id) {
		$query = "
			DELETE FROM " . $this->db->prefix . "_tag 
			WHERE 
			tag_id=" . $tag_id
		;
				
		$result = $this->db->Execute($query);
				
		if (empty($result)) {
			$error_info = "function=deleteTag class=Tag.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['am_error_log'][] = array('db_error', $error_info);
		}
		
	} //EO deleteTag

	
	
	// updateTag --------------------------------------------------------------------
	// updates a tag
	// tom calthrop - 23rd July 2005
	//
	function updateTag($tag_id, $tag_body) {
		$query = "
			SELECT * 
			FROM " . $this->db->prefix . "_tag 
			WHERE 
			tag_id=" . $tag_id
		;
		
		$result = $this->db->Execute($query);
		
		$rec = array();
		$rec['tag_body'] = $tag_body;
		
		$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
		$result = $this->db->Execute($query);
	}//EO selTag
}
?>
