<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


// RELEASE NOTES --------------------------------------------------
$core_config['release']['version'] = 					"1.0";
$core_config['release']['release_date'] = 				"05-24-2007"; // MM-DD-YYYY
$core_config['release']['install_date'] = 				""; // MM-DD-YYYY



//DATABASE CONFIGURATION --------------------------------------------------
$core_config['db']['host'] = 							"localhost";
$core_config['db']['user'] = 							"your_db_username";
$core_config['db']['pass'] = 							"your_db_password";
$core_config['db']['db']=	 							"your_db_name";
$core_config['db']['prefix'] =	 						"am";
$core_config['db']['collate'] =	 						""; // utf8_swedish_ci



// PHP CONFIGURATION -----------------------------------------------------
ini_set('error_reporting', E_ALL); 						// error handling in development environment.
//ini_set('error_reporting', 0); 						// error handling in production environment



// LANGUAGE CONFIGURATION ---------------------------------------------------
// list within the array the language ID's available to this node.check
// you have the language files installed before extending this.
$core_config['language']['default_pack_id'] = 			1; //English
$core_config['language']['pack'][1] = 					"en";



// SET LOCALIZATION -----------------------------------------------------
// debian note: go to aptitude and install -language-pack-*-base, the restart webserver
// locale -a to display list of installed packs
// Key entries must be uppercase
$installed_server_language_packs = array('EN' => 'en_US');



// SYSTEM CONFIGURATION -----------------------------------------------
// PHP keeps data in a session. The session is called "PHPSESSID" as standard. If you 
// have more than one instance of this software you should create a unique session name.
// recomended is characters A-Z (uppercase),0-9 with no spaces. DO NOT use a dot (.).
$core_config['node']['php_session_name'] = 				"PHPSESSIDAM";



// AROUNDMe CONFIGURATION ---------------------------------------------
// Automatically point to a webspace X or work with multiple webspaces.
// Use zero for multiple webspaces or the webspace_id to point to a specific ID
$core_config['am']['mode'] = 							1;
// allow people to create webspaces (maintainers always have ability to create)
// 0=deny, 1=approval_required, 2=automatic
$core_config['am']['webspace_creation_type'] = 			0;
// we can access the maintainer.php page?
$core_config['resource']['maintainer_openid'][] = 		"http://example.barnraiser.info"; // http://you.barnraiser.info
// Where is the overview (http: for remote location or overview.php for local listing)
$core_config['am']['overview_url'] = 					"overview.php";



// WEBSPACE CONFIGURATION ---------------------------------------------
$core_config['webspace']['status']['pending'] = 		1;
$core_config['webspace']['status']['barred'] = 			2;
$core_config['webspace']['status']['active'] = 			3;
$core_config['webspace']['excluded_webspace_names'] = 	array('reserved');



// RELATION CONFIGURATION ---------------------------------------------
$core_config['connection']['status']['barred'] = 		1;
$core_config['connection']['status']['active'] = 		2;



// FILE CONFIGURATION ----------------------------------------------------
$core_config['file']['mime'][1]['mime'] = 				"image/jpeg";
$core_config['file']['mime'][2]['mime'] = 				"image/png";
$core_config['file']['mime'][3]['mime'] = 				"image/gif";
$core_config['file']['mime'][4]['mime'] = 				"application/pdf";
$core_config['file']['mime'][5]['mime'] = 				"text/plain";
// We use this to map IE-mimetype to standard mimetype
$core_config['file']['browser_path'] =					array(array("from" => "image/pjpeg", "to" => "image/jpeg"));
//image and thumbs
$core_config['file']['dir'] =							"../asset/";
$core_config['file']['thumbnail']['width'] =			90;
$core_config['file']['thumbnail']['height'] =			90;
$core_config['file']['default_allocation'] =			200; // in KB



// DISPLAY CONFIGURATION ---------------------------------------------------
$core_config['display']['max_list_rows'] = 				25;



// END OF CONFIG FILE ----------------------------------------------------

?>
