<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

include_once($language_path . 'connect.lang.php');

//create trusted root
$trusted_root = "http://" . $_SERVER['HTTP_HOST'] . dirname ($_SERVER['PHP_SELF']);

if (substr($trusted_root, -1, 1) != "/") {
	$trusted_root .= "/";
}


//create return_to path
$return_to = "http://" . $_SERVER['HTTP_HOST'] . dirname ($_SERVER['PHP_SELF']);

if (substr($return_to, -1, 1) != "/") {
	$return_to .= "/";
}
$return_to .= 'index.php?t=connect&ws=' . $output_webspace['webspace_id'];


if (isset($_POST['commit']) && empty($_SESSION['connection_id'])) {
	
	if (!empty($_POST['openid_login'])) {
		
		include_once ('components/core/class/Openid.class.php');
		
		$openid = new SimpleOpenID ($db, $core_config);
		$openid->SetIdentity($_POST['openid_login']);
		$openid->SetTrustRoot($trusted_root);
		$openid->SetApprovedURL($return_to);
		$openid->SetRequiredFields(array('nickname'));
		$openid->SetOptionalFields(array('fullname', 'email', 'country', 'language'));
		
		if ($openid->GetOpenIDServer()) {
			$openid->SetApprovedURL($trusted_root);
			$openid->SetApprovedURL($return_to);
			$openid->Redirect();
			exit;
		}
		else {
			$error = $openid->GetError();
			$GLOBALS['am_error_log'][] = array('login_failed');
		}
	}
}
elseif (isset($_GET['openid_mode']) && empty($_SESSION['connection_id'])) {
		
	if ($_GET['openid_mode'] == 'id_res') {
		
		include_once ('components/core/class/Openid.class.php');
		
		$openid = new SimpleOpenID ($db, $core_config);
		$openid->SetIdentity($_GET['openid_identity']);
		
		if ($openid->ValidateWithServer()) {

			if (empty($_GET['openid_sreg_nickname'])) {
				$GLOBALS['am_error_log'][] = array('nickname_empty');
			}
			else {
				$openid->setConnection($output_webspace);
			}
			
		}
		elseif ($openid->IsError()) {
			// something went wrong
			$GLOBALS['am_error_log'][] = array('login_failed');
		}
		else {
			// now allowed
			$GLOBALS['am_error_log'][] = array('login_failed');
		}
	}
}


if ($handle = opendir('components')) {
   while (false !== ($file = readdir($handle))) {
       if ($file != "." && $file != "..") {
           $output_plugins[] = $file;
       }
   }
   closedir($handle);
}

if (!empty($output_plugins)) {
	$body->set('plugins', $output_plugins);
}

?>
