<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
// 
// Copyright (C) 2003-2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; see the file COPYING.txt.  If not, see
// <http://www.gnu.org/licenses/>
// -----------------------------------------------------------------------

?>

<form action="overview.php" method="POST">

<div id="am_core_area">
	<table cellspacing="0" cellpadding="0" border="0" width="100%">
		<tr>
			<td valign="top">
				<?php
				if(isset($webspaces)) {
				?>
				<h1><?php echo $lang['hdr_latest_webspaces'];?></h1>

				<div class="box">
					<ul>
						<?php
						foreach($webspaces as $g):
						$url = formatSubDomainUrl($g['webspace_unix_name']);
						?>
						<li><a href="<?php echo $url; ?>"><?php echo $g['webspace_title']; ?></a>, <?php echo $g['webspace_create_datetime']; ?><br /><?php echo $g['webspace_description']; ?></li>
						<?php
						endforeach;
						?>
					</ul>
					<?php echo paging($total_nr_of_rows, $core_config['display']['max_list_rows'], 'overview.php'); ?>
				</div>

				<?php
				}
				elseif (isset($search_webspaces)) {
				?>
				<h1><?php echo $lang['hdr_search_results'];?></h1>
				
				<div class="box">
					<ul>
						<?php
						foreach($search_groups as $g):
						?>
						<li><b><?php echo $lang['txt_relevance']; ?>: </b> <?php echo $g['percentage'];?>%<br />
							<a href="<?php echo $g['webspace_url']; ?>"><?php echo $g['webspace_title']; ?></a>, <?php echo $g['webspace_create_datetime']; ?><br /><?php echo highlight($_REQUEST['search'], $g['webspace_description']); ?></li>
						<?php
						endforeach;
						?>
					</ul>
					<?php echo paging($total_nr_of_rows, $core_config['display']['max_list_rows'], 'overview.php&search=' . $_REQUEST['search']); ?>
				</div>
				
				<?php
				}
				else {
				?>
				<h1><?php echo $lang['hdr_search_results'];?></h1>
				
				<div class="box">
					<p>
						<?php echo $lang['err_no_webspaces'];?><br />
					</p>
				</div>
				<?php } ?>
			</td>
			<td width="20">
				<img src="<?php echo $template_path_core;?>img/pixel.png" width="20" height="1" border="0" alt="" /><br />
			</td>
			<td valign="top" width="240">
				<div class="box">
					<h1><?php echo $lang['hdr_search'];?></h1>
	
					<p>
						<input type="text" name="search" />
						&nbsp;
						<input type="submit" class="input_submit" value="<?php echo $lang['sub_search'];?>" /><br>
					</p>
	
						<ul>
							<li><a href="overview.php"><?php echo $lang['href_webspaces'];?></a></li>
						</ul>
					</div>
				</div>

				<?php
				if ($core_config['am']['webspace_creation_type'] == 1 || $core_config['am']['webspace_creation_type'] == 2) {
				?>
				<div class="box">
					<h1><?php echo $lang['hdr_create_webspace'];?></h1>

					<p>
						<?php echo $lang['txt_create_webspace'];?><br />
					</p>
	
					<ul>
						<li><a href="create_webspace.php"><?php echo $lang['href_create_webspace'];?></a></li>
					</ul>
				</div>
				<?php }?>
			</td>
		</tr>
	</table>
</div>
</form>