<?php

// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

if(isset($_SESSION['connection_permission']) && checkPermission('core', 'edit_webpages', $_SESSION['connection_permission'])) {

	require_once($language_path . 'admin_webpage.lang.php');
	
	
	if (isset($_POST['set_default_webpage'])) { // set the default page id
	
		$query = "
			UPDATE " . $db->prefix . "_webspace
			SET
			default_webpage_id=" . $_POST['default_webpage_id'] . " 
			WHERE
			webspace_id=" . $_SESSION['webspace_id']
		;
			
		$result = $db->Execute($query);
	
		$output_webspace['default_webpage_id'] = $_POST['default_webpage_id'];
		
	}
	elseif (isset($_POST['request_delete_webpages'])) { // delete selected pages
		if (!empty($_POST['webpage_ids'])) {
			$body->set('display_confirm_delete', 1);
			$delete_ids = $_POST['webpage_ids'];
		}
	}
	elseif (isset($_POST['confirm_delete_webpages'])) { // delete selected pages
		if (!empty($_POST['webpage_ids'])) {
			$query = "
				DELETE FROM " . $db->prefix . "_webpage
				WHERE
				webpage_id in (" . implode(",", $_POST['webpage_ids']) . ")"
			;
	
			$result = $db->Execute($query);
		}
	}
	
	
	$query = "
		SELECT webpage_id, webpage_name, webpage_title,
		UNIX_TIMESTAMP(webpage_create_datetime) as webpage_create_datetime  
		FROM " . $db->prefix . "_webpage
		WHERE
		webspace_id=" . $output_webspace['webspace_id'] . " AND "
	;
	
	if (isset($delete_ids)) {
		$query .= "webpage_id in (" . implode(",", $delete_ids) . ") AND ";
	}
	
	$query .= "1=1 ORDER BY webpage_name, webpage_create_datetime desc";
	
	$result = $db->Execute($query);
	
	if (isset($result)) {
		
		$output_webpages = $result;
	
		if (!empty($output_webpages)) {
			$body->set('webpages', $output_webpages);
		}
	}
}
else { // no permission to be here
	header("Location: index.php?ws=" . $_REQUEST['ws']);
	exit;
}

?>