<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------


if (isset($_POST['plugin_name']) && isset($_POST['plugin_item_id'])) {

	include_once ("../config/core.config.php");
	
	
	// SETUP DATABASE ------------------------------------------------------
	require_once('../class/Db.class.php');
	$db = new Database($core_config['db']);
	
	
	// START SESSION -----------------------------------------------------------
	session_name($core_config['node']['php_session_name']);
	session_start();
	
	
	
	if (isset($_POST['rate_value'])) {

		$rec = array();
		$rec['webspace_id'] = $_SESSION['webspace_id'];
		$rec['plugin_name'] = $_POST['plugin_name'];
		$rec['plugin_item_id'] = $_POST['plugin_item_id'];
		$rec['connection_id'] = $_SESSION['connection_id'];
		$rec['rate_value'] = $_POST['rate_value'];
		
		$table = $db->prefix . "_rate";
			
		$db->insertDb($rec, $table);
	}
	
	
	// GET RATINGS ( an unrated item displays an average of 3)
	$rating['total'] = 1;
	$rating['votes'] = 0;
	$rating['average'] = 3;
			
			
	// select total of the votes
	$query = "
		SELECT sum(rate_value) as total
		FROM " . $db->prefix . "_rate
		WHERE
		webspace_id=" . $_SESSION['webspace_id'] . " AND
		plugin_name=" . $db->qstr($_POST['plugin_name']) . " AND
		plugin_item_id=" . $_POST['plugin_item_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result[0])) {
		$rating['total'] = $result[0]['total']+3;
	}
	
	
	// select total number of votes
	$query = "
		SELECT count(rate_value) as total
		FROM " . $db->prefix . "_rate
		WHERE
		webspace_id=" . $_SESSION['webspace_id'] . " AND
		plugin_name=" . $db->qstr($_POST['plugin_name']) . " AND
		plugin_item_id=" . $_POST['plugin_item_id']
	;
	
	$result = $db->Execute($query);
	
	if (isset($result[0])) {
		$rating['votes'] = $result[0]['total']+1;
	}


	// compute the average
	if ($rating['total'] > 0 && $rating['votes'] > 0) {
		$rating['average'] = round($rating['total'] / $rating['votes']);
	}
			
	
	// select my vote
	if (isset($_SESSION['connection_id'])) {
		$query = "
			SELECT rate_value as total
			FROM " . $db->prefix . "_rate
			WHERE
			webspace_id=" . $_SESSION['webspace_id'] . " AND
			plugin_name=" . $db->qstr($_POST['plugin_name']) . " AND
			plugin_item_id=" . $_POST['plugin_item_id'] . " AND
			connection_id=" . $_SESSION['connection_id']
		;

		$result = $db->Execute($query);

		if (isset($result[0])) {
			$rating['vote'] = $result[0]['total'];
		}
	}

	// total | votes | average | vote
	header("Content-type: application/xml");
	echo '<?xml version="1.0"?>';
	echo '<rating>';
	echo '<total>' . $rating['total'] . '</total>';
	echo '<votes>' . $rating['votes'] . '</votes>';
	echo '<average>' . $rating['average'] . '</average>';
	echo '<vote>' . $rating['vote'] . '</vote>';
	echo '</rating>';
	
}
	
?>