<?php
// -----------------------------------------------------------------------
// This file is part of AROUNDMe
//
// Copyright (C) 2003 - 2007 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<form action="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=search" method="POST">

<div id="am_core_area">
	<table cellpadding="0" cellspacing="0" border="0" width="100%">
		<tr>
			<td width="240" valign="top">
				<div class="box">
					<h1><?php echo $lang['hdr_options'];?></h1>

					<p>
						<?php echo $lang['txt_options_intro'];?><br />
					</p>

					<ul>
						<?php
						$link_css = "";
						if (!isset($_REQUEST['v'])) {
							$link_css = " class=\"highlight\"";
						}
						?>
						<li><a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=search"<?php echo $link_css;?>><?php echo $lang['href_search'];?></a></li>
						
						<?php
						$link_css = "";
						if (isset($_REQUEST['v']) && $_REQUEST['v'] == "t") {
							$link_css = " class=\"highlight\"";
						}
						?>
						<li><a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=search&amp;v=t"<?php echo $link_css;?>><?php echo $lang['href_tagcloud'];?></a></li>

						<?php
						$link_css = "";
						if (isset($_REQUEST['v']) && $_REQUEST['v'] == "r") {
							$link_css = " class=\"highlight\"";
						}
						?>
						<li><a href="index.php?ws=<?php echo $webspace['webspace_id'];?>&amp;t=search&amp;v=r"<?php echo $link_css;?>><?php echo $lang['href_rated'];?></a></li>
					</ul>
				</div>
			</td>
			<td width="30" style="border-right: 1px solid #333">
				<img src="<?php echo $template_path_core;?>img/pixel.png" width="30" height="1" border="0" alt="" /><br />
			</td>
			<td width="40">
				<img src="<?php echo $template_path_core;?>img/pixel.png" width="40" height="1" border="0" alt="" /><br />
			</td>
			<td valign="top">
				<?php
				if (isset($_REQUEST['v']) && $_REQUEST['v'] == "t") {
				?>
				<div class="box">
					<h1><?php echo $lang['hdr_search_tags'];?></h1>
					
					<p>
						<?php echo $lang['txt_tag_intro'];?><br />
					</p>
	
					<p>
						<?php if (isset($tags)) { ?>
							<?php foreach($tags as $key => $t): ?>
								<a href="index.php?ws=<?php echo $_REQUEST['ws']; ?>&amp;t=search&amp;v=t&amp;tag=<?php echo $t['tag_name'];?>"><?php echo $t['tag_name']; ?></a><sup><?php echo $t['total_nr_of_tags']; ?></sup><?php if ($key != count($tags)-1) echo ", ";?>
							<?php endforeach; ?>
						<?php } ?>
					</p>
					<?php if (isset($search_result_tags)) { ?>
						<?php echo $lang['txt_items_tagged_with']; ?> <b><?php echo $_REQUEST['tag']; ?></b><br /><br />
						<ul style="list-style-type: none; padding: 0px; margin: 0px;">
						<?php foreach($search_result_tags as $s): ?>
							<li style="margin-bottom: 10px;">
								<a href="<?php echo $s['link']; ?>"><?php echo $s['item_title']; ?></a><br />
								<i><?php echo highlight($_REQUEST['tag'], $s['item_body'], 0); ?></i>
							</li>
						<?php endforeach; ?>
						</ul>
					<?php } ?>
				</div>

				<?php
				}
				elseif (isset($_REQUEST['v']) && $_REQUEST['v'] == "r") {
				?>
				<div class="box">
					<h1><?php echo $lang['hdr_rated'];?></h1>
					<?php echo $lang['txt_rated_intro'];?><br />
					<p>
						<input <?php if (empty($_REQUEST['rate_period']) || $_REQUEST['rate_period'] == "7") echo "checked=\"checked\"";?> type="radio" name="rate_period" value="7" id="rate_period_7"/>&nbsp;<label for="rate_period_7" style="margin: 0px; font-weight: normal; float: none; cursor: pointer;"><?php echo $lang['txt_rated_last_7'];?></label>
						<input <?php if (isset($_REQUEST['rate_period']) && $_REQUEST['rate_period'] == "30") echo "checked=\"checked\"";?> type="radio" name="rate_period" value="30" id="rate_period_30"/>&nbsp;<label for="rate_period_30" style="margin: 0px; font-weight: normal; float: none; cursor: pointer;"><?php echo $lang['txt_rated_last_30'];?></label>
						<input <?php if (isset($_REQUEST['rate_period']) && $_REQUEST['rate_period'] == "0") echo "checked=\"checked\"";?> type="radio" name="rate_period" value="0" id="rate_period_0"/>&nbsp;<label for="rate_period_0" style="margin: 0px; font-weight: normal; float: none; cursor: pointer;"><?php echo $lang['txt_rated_all'];?></label>
					
						<input type="submit" name="filter" value="filter" class="input_submit"/>
						<input type="hidden" name="v" value="r" />
					</p>
				</div>

				<div class="box">
					
					<?php if (isset($search_result_ratings)) { ?>
						<ul style="list-style-type: none; padding: 0px; margin: 0px;">
						<?php foreach($search_result_ratings as $s): ?>
							<li style="margin-bottom: 10px;">
								<b><?php echo $lang['txt_rating'];?>: <?php echo round($s['br'], 1); ?></b>
								<a href="<?php echo $s['link']; ?>"><?php echo $s['item_title']; ?></a><br />
								<i><?php echo highlight("0", $s['item_body'], 0); ?></i>
							</li>
						<?php endforeach; ?>
						</ul>
						<?php
							$url_end = "";
							if (isset($_REQUEST['rate_period']) && !empty($_REQUEST['rate_period'])) {
								$url_end = "&rate_period=" . $_REQUEST['rate_period'];
							}
						?>
						<?php echo paging($total_nr_of_rows, $core_config['display']['max_list_rows'], 'index.php?ws=' . $_REQUEST['ws'] . '&t=search&v=r' . $url_end); ?>
					<?php } ?>
				</div>
				
				<?php
				}
				else {
				?>

				<div class="box">
					<h1><?php echo $lang['hdr_search'];?></h1>
					<p>
						<?php echo $lang['txt_search_intro'];?></br >
					</p>

					<p>
						<?php
						if (isset($search_types)) {
						foreach ($search_types as $key => $i):
						$selected = "";
						if ((isset($_REQUEST['search_type']) && $_REQUEST['search_type'] == $i) || $key=="0") {
							$selected = " checked=\"checked\"";
						}
						?>
						&nbsp;<label style="float: none; font-weight: normal; margin: 0px; cursor: pointer;" for="search_type_<?php echo $i; ?>"><?php echo $i;?></label>
						<input id="search_type_<?php echo $i; ?>" type="radio" name="search_type" value="<?php echo $i;?>"<?php echo $selected;?> style="margin:2px;" />
						<?php
						endforeach;
						}
						?>
					</p>
					
					<p>
						<label for="id_webspace_search"><?php echo $lang['txt_search'];?></label>
						<input type="text" name="search_text" id="id_webspace_search" value="<?php if (isset($_REQUEST['search_text'])) { echo $_REQUEST['search_text'];}?>" style="width:180px;margin:2px;" />
						<input type="submit" name="search" value="<?php echo $lang['sub_search'];?>" class="input_submit" /><br />
					</p>
					<?php if (isset($search_result)) { ?>
						<?php if (empty($search_result)) { ?>
							<?php echo $lang['txt_no_result']; ?>
						<?php } else { ?>
							<ul style="list-style-type: none; padding: 0px; margin: 0px;">
								<?php
								foreach($search_result as $s):
								?>
									<li style="margin-bottom: 10px;">
									<a href="<?php echo $s['link']; ?>"><?php echo $s['item_title']; ?></a><br />
									<span style=" font-weight: bold; font-size: 75%; padding-right: 10px; padding-bottom: 10px; cursor: help;" title="relevance is a..."><?php echo $lang['txt_relevance']; ?>: <?php echo $s['percentage'];?>%</span>
										<i><?php echo highlight($_REQUEST['search_text'], $s['item_body']); ?></i>
									</li>
								<?php
								endforeach;
								?>
							</ul>
							<?php echo paging($total_nr_of_rows, $core_config['display']['max_list_rows'], 'index.php?ws=' . $_REQUEST['ws'] . '&search_type=' . $_REQUEST['search_type'] . '&t=search&search_text=' . urlencode(htmlentities($_REQUEST['search_text']))); ?>
						<?php } ?>
					<?php } ?>
				</div>
				<?php }?>
			</td>
		</tr>
	</table>
</div>
</form>
