<?php

// -----------------------------------------------------------------------
// This file is part of Beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------
$menu_section = "splash";
include "inc/header.inc.php";


//form actions
if (!empty($_REQUEST['confirmation'])) {
	$user->user_status_ids = $c_node['user_status'];
	
	$user->confirmationRegistration($_REQUEST['confirmation']);
	
	if (empty($GLOBALS['beacon_error_log'])) {
		$GLOBALS['beacon_error_log'][] = array(18, null); //ok
		$frmdata['user_email'] = $user->user_email;
	}
}
elseif (isset($frmdata['new_password'])) {
	$catpcha = strtoupper($_POST['captchastring']);
	
	if (!isset($catpcha) || $_SESSION['CAPTCHAString'] != $catpcha) {
		$GLOBALS['beacon_error_log'][] = array(8, null);
	}
	
	if (empty($GLOBALS['beacon_error_log'])) {
		//setup mail
		require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');
		$mail = new PHPMailer();
		$mail->Host = 		$c_node['mail']['host'];
		$mail->Port = 		$c_node['mail']['port'];
		$mail->Mailer = 	$c_node['mail']['mailer'];
		
		if (isset($c_node['mail']['smtp']['username'])) {
			$mail->SMTPAuth = true;
			$mail->Username = $c_node['mail']['smtp']['username'];
			$mail->Password = $c_node['mail']['smtp']['password'];
		}
		
		$mail->language = 	$c_node['mail']['language'];
		$mail->From = 		$c_node['mail']['no_reply_address'];
		$mail->FromName = 	$c_node['mail']['from_name'];
		$mail->WordWrap = 	$c_node['mail']['wordwrap'];
		$mail->Subject = 	$lang['txt_mail_subject_new_pass'];
		$user->mail = $mail;
		
		$message_file = $languageTextPath . "send_new_password.txt.php";
		
		$user->sendNewPassword($frmdata, $message_file);
	}
	
	if (empty($GLOBALS['beacon_error_log'])) {
			$GLOBALS['beacon_error_log'][] = array(14, null);
	}
	else {
		$display = "new_password";
	}
}
elseif (isset($frmdata['login'])) {
	$user->user_status_ids = $c_node['user_status'];
	$user->installation_name = $c_node['installation_name'];
	$user->loginUser($frmdata['email'], $frmdata['password']);
	
	if (empty($GLOBALS['beacon_error_log'])) {
		header("Location: index.php");
		exit;
	}
	
	$display = "login";
	
}
elseif (isset($frmdata['register'])) {
	$catpcha = strtoupper($_POST['captchastring']);
	
	if (!isset($catpcha) || $_SESSION['CAPTCHAString'] != $catpcha) {
		$GLOBALS['beacon_error_log'][] = array(8, null);
	}
	
	$display = "register";
	
	if (empty($GLOBALS['beacon_error_log'])) {
		//setup mail
		require_once($c_node['dir']['class_path'] . '/Mail/class.phpmailer.php');
		$mail = new PHPMailer();
		$mail->Host = 		$c_node['mail']['host'];
	//	$mail->Port = 		$c_node['mail']['port'];
		$mail->Mailer = 	$c_node['mail']['mailer'];
		
		if (isset($c_node['mail']['smtp']['username'])) {
			$mail->SMTPAuth = true;
			$mail->Username = $c_node['mail']['smtp']['username'];
			$mail->Password = $c_node['mail']['smtp']['password'];
		}
		
		$mail->language = 	$c_node['mail']['language'];
		$mail->From = 		$c_node['mail']['no_reply_address'];
		$mail->FromName = 	$c_node['mail']['from_name'];
		$mail->WordWrap = 	$c_node['mail']['wordwrap'];
		$mail->Subject = 	$lang['txt_mail_subject_register'];
		$user->mail = $mail;
		
		$user->user_status_ids = $c_node['user_status'];
		
		$message_file = $languageTextPath . "confirm_registration.txt.php";
		
		$user->role_id = $c_acs['arr_acs']['user_join_role_default'];
		
		$user->registerUser($frmdata, $message_file);
		
		if (empty($GLOBALS['beacon_error_log'])) {
			$GLOBALS['beacon_error_log'][] = array(7, null);
			
			$display = "login";
		}
	}
}
elseif (isset($_REQUEST['man'])) {
	
	require_once($languageArrayPath . 'arr_man.lang.php');
	
	if (isset($_REQUEST['man_id']) && $_REQUEST['man_id'] > 0) {
		$page = $_REQUEST['man_id'];
	}
	else {
		$page = 0;
	}
	
	$langfile = $lang['man'][$page][0] . ".man.php";
	$output_manual_page['man'] = readTxtFile($languagePath . 'man/' . $langfile);
	$output_manual_page['man'] = stripslashes($output_manual_page['man']);
	$output_manual_page['man'] = $wiki->transform($output_manual_page['man'], 'Xhtml');
	$output_manual_page['title'] = $lang['man'][$page][1];
	$output_manual_page['man_id'] = $page;
	$display = "man";
}
elseif (isset($_REQUEST['register'])) {
	$display = "register";
}
elseif (isset($_REQUEST['new_password'])) {
	$display = "new_password";
}
	
	
	
	
if (!empty($display)) {
	$body->set('display', $display);
}

if (!empty($output_manual_page)) {
	$body->set('manual_page', $output_manual_page);
}

if (!empty($output_new_password)) {
	$body->set('new_password', $output_new_password);
}

include "inc/footer.inc.php";

?>
