<?php

// -----------------------------------------------------------------------
// This file is part of Beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<form action="splash.php" method="post" id="frm">

<?php
if (isset($display) && $display == "register") {
?>

<div class="box">
	<div class="box_top">
		<?php echo $lang['hdr_register'];?><br />
	</div>
		
	<div class="box_mid">
		<div class="content">
			<p>
				<?php echo $lang['txt_register_intro'];?><br />
			</p>
			
			<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="30" alt="" /><br />

			<table border="0" cellspacing="0" cellpadding="0" width="100%">
				<tr>
					<td valign="top" width="50%">
						<fieldset>
						<legend>&nbsp;<b><?php echo $lang['fld_details'];?></b>&nbsp;</legend>
						<p>
						<?php echo $lang['txt_register_intro'];?><br />
						</p>
						
						<p>
							<label for="id_name"><?php echo $lang['txt_name'];?></label>
							<input id="id_name" type="text" name="user_name" size="20" value="<?php if(isset($frmdata['user_name'])) { echo $frmdata['user_name'];}?>" /><br />
						</p>
						
						<p>
							<label for="id_email"><?php echo $lang['txt_email'];?></label>
							<input id="id_email" type="text" name="user_email" size="20" value="<?php if(isset($frmdata['user_email'])) { echo $frmdata['user_email'];}?>" /><br />
						</p>
						
						<p>
							<label for="id_password"><?php echo $lang['txt_password'];?></label>
							<input id="id_password" type="password" name="user_password" size="12" value="<?php if(isset($frmdata['user_password'])) { echo $frmdata['user_password'];}?>" /><br />
						</p>
						
						<?php
						if(count($lang['language']) == 1) {
						?>
							<input type="hidden" name="language_id" value="<?php echo $_SESSION['language_id'];?>" />
						<?php
						}
						else {
						?>
						
						<p>
							<label for="id_language"><?php echo $lang['form_label_language'];?></label>
							<select id="id_language" name="language_id">
							<?php
							foreach($lang['language'] as $key => $i):
							$selected = "";
							
							if (isset($frmdata['language_id']) && $frmdata['language_id'] == $key) {
								$selected = " selected=\"selected\"";
							}
							?>
							<option value="<?php echo $key;?>"><?php echo $i;?></option>
							<?php endforeach; ?>
							</select>
						</p>
						<?php }?>
						</fieldset>
						
						<img src="<?php echo $templatePath;?>img/pixel.png" width="1" height="10" alt="" border="0" /><br />
						
						<fieldset>
						<legend>&nbsp;<b><?php echo $lang['fld_preferences'];?></b>&nbsp;</legend>
							<p>
							<?php echo $lang['txt_preferences_intro'];?><br />
							</p>
							
							<p>
							<label for="id_allow_correspondence" style="width:100%"><?php echo $lang['txt_allow_correspondence'];?></label><br />
							</p>
							
							<p align="right">
							<input id="id_allow_correspondence" type="checkbox" name="allow_correspondence" value="1" <?php if(!empty($frmdata['allow_correspondence'])) { echo "checked=\"checked\"";}?> /><br />
							</p>
							
							<p>
							<label for="id_show_email" style="width:100%"><?php echo $lang['txt_show_email'];?></label><br />
							</p>
							
							<p align="right">
							<input id="id_show_email" type="checkbox" name="show_email" value="1" <?php if(!empty($frmdata['show_email'])) { echo "checked=\"checked\"";}?> /><br />
							</p>
						</fieldset>
						
					</td>
					<td width="20">
						<img src="<?php echo $templatePath;?>img/pixel.png" width="20" height="1" alt="" border="0" /><br />
					</td>
					<td valign="top" width="50%">
						<fieldset>
						<legend>&nbsp;<b><?php echo $lang['fld_register'];?></b>&nbsp;</legend>
							<p>
							<?php echo $lang['txt_register_intro'];?><br />
							</p>
							
							<p>
								<img src="get_captcha.php" alt="CAPTCHA" class="picture"><br />
							</p>
							
							<p>
								<input id="id_captcha" type="text" name="captchastring" size="20"><br />
							</p>
							
							</p>
							
							<p align="right">
								<input type="submit" name="register" value="<?php echo $lang['sub_register'];?>" class="button" /><br />
							</p>
							
							<p>
								<?php echo $lang['txt_captcha_intro'];?><br />
							</p>
						</fieldset>
					</td>
				</tr>
			</table>
		</div>
	</div>
</div>

<div class="box_bottom">
	<span class="box_bottom_right"></span>
	<span class="box_bottom_left"></span>
</div>
<?php
}
elseif (isset($display) && $display=="man") {
?>
<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $manual_page['title'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php echo $manual_page['man'];?><br />
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_man'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<?php
				if (isset($lang['man'])) {
				foreach($lang['man'] as $key => $i):
				?>
				<p>
					<?php
					if (isset($manual_page) && $manual_page['man_id'] == $key) {
						echo $i[1];
					}
					else {
					?>
					<a href="splash.php?man=1&amp;man_id=<?php echo $key;?>"><?php echo $i[1];?></a><br />
					<?php }?>
				</p>
				<?php
				endforeach;
				}
				?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
<?
}
else {
?>

	<div class="col_main">
		<?php
		if (isset($_SESSION['s_user_id'])) {
		?>
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_welcome'] . " " . $_SESSION['user_name'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<?php echo $lang['txt_introduction'];?><br />
					</div>
				</div>
			</div>
			
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
		
		<?php
		}
		else {
		?>
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_welcome'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<?php echo $lang['txt_public_introduction'];?><br />
					</div>
				</div>
			</div>
				
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
			
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_about_beacon'];?><br />
				</div>
				
				<div class="box_mid">
						<div class="content">
						<?php echo $lang['txt_about_beacon'];?><br />
					
						<p align="right">
							<a href="http://www.barnraiser.org/" title="Beacon is created by Barnraiser. Click to visit our web site."><img src="<?php echo $templatePath;?>img/beacon.png" width="137" height="40" alt="" border="0" /></a><br />
						</p>
					</div>
				</div>
			</div>
				
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
			
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_credits'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<?php echo $lang['txt_credits'];?><br />
					</div>
				</div>
			</div>
				
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
		<?php }?>
	</div>
	
	<div class="col_side">
		<?php
		if (isset($_SESSION['s_user_id'])) {
		?>
			
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_help'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<?php echo $lang['txt_help_introduction'];?><br />
						<p>
							<a href="splash.php?man=1"><?php echo $lang['href_help'];?></a><br />
						</p>
					</div>
				</div>
			</div>
			
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
			
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_membership'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<?php echo $lang['txt_membership_introduction'];?><br />
						<p>
							<a href="account.php"><?php echo $lang['href_membership'];?></a><br />
						</p>
					</div>
				</div>
			</div>
				
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
			
		<?php
		}
		elseif (isset($display) && $display == "new_password") {
		?>
		<div class="box">
			<div class="box_top">
				<?php echo $lang['hdr_password'];?><br />
			</div>
			
			<div class="box_mid">
				<div class="content">
					<p>
						<?php echo $lang['txt_new_pass_intro'];?><br />
					</p>
					
					<p>
						<label for="id_email"><?php echo $lang['txt_email'];?></label><br />
						<input id="id_email" type="text" name="user_email" size="20" value="<?php if (isset($frmdata['user_email'])) { echo $frmdata['user_email'];}?>" /><br />
					</p>
					
					<p>
						<img src="get_captcha.php" alt="CAPTCHA" class="picture"><br />
					</p>
					
					<p>
						<input id="id_captcha" type="text" name="captchastring" size="20"><br />
					</p>
					
					<p align="right">
						<input type="submit" name="new_password" value="<?php echo $lang['sub_send_pass'];?>" class="button" /><br />
					</p>
					
					<p>
						<?php echo $lang['txt_captcha_intro'];?><br />
					</p>
				</div>
			</div>
		</div>
			
		<div class="box_bottom">
			<span class="box_bottom_right"></span>
			<span class="box_bottom_left"></span>
		</div>
		<?php
		}
		else {
		?>
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_login'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<form action="spl_view.php" method="post">
						
						<p>
							<input type="hidden" name="http_referer" value="<?php if (isset($http_referer)) { echo $http_referer;}?>" />
							<label for="id_email"><?php echo $lang['txt_email'];?></label><br />
						</p>
						
						<p>
							<input id="id_email" type="text" name="email" size="20" value="<?php if(isset($frmdata['user_email'])) { echo $frmdata['user_email'];}?>" style="width: 140px" /><br />
						</p>
						
						<p>
							<label for="id_password"><?php echo $lang['txt_password'];?></label><br />
						</p>
						
						<p>
							<input id="id_password" type="password" name="password" size="12" value="" style="width: 100px" /><br />
						</p>
						
						<p>
							<?php echo $lang['txt_login_note'];?><br />
						</p>
						
						<p align="right">
							<input type="submit" name="login" value="enter" /><br />
						</p>
						
						</form>
					</div>
				</div>
			</div>
				
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
			
			<div class="box">
				<div class="box_top">
					<?php echo $lang['hdr_password'];?><br />
				</div>
				
				<div class="box_mid">
					<div class="content">
						<?php echo $lang['txt_new_password'];?><br />
					</div>
				</div>
			</div>
				
			<div class="box_bottom">
				<span class="box_bottom_right"></span>
				<span class="box_bottom_left"></span>
			</div>
		<?php }?>
	</div>
<?php }?>
