<?php

// -----------------------------------------------------------------------
// This file is part of Beacon
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------



class Menu {
	// CLASS FUNCTIONS
	// Menu
	// selMenu
	// insertMenuItem
	// updateMenuItem
	// deleteMenuItem



	// Menu -----------------------------------------------------------------
	// the constuctor
	// tom calthrop - 21st Feb 2004
	//
	function Menu($db, $arr_menu){
		$this->db = $db;
		$this->arr_menu = $arr_menu;
	}//EO Menu
	
	
	
	// selMenu --------------------------------------------------------------------
	// returns multiple rows of items from DB
	// tom calthrop - 22nd May 2004
	//
	function selMenu($menu_location_id=null) {
		$query = "
			SELECT m.menu_id, m.menu_title, m.menu_link, 
			m.menu_link_type_id, m.menu_location_id, m.menu_order 
			FROM " . $this->db->prefix . "_menu m 
			WHERE "
		;
		
		if (isset($this->language_id)) {
		    $query .= "m.language_id=" . $this->language_id . " AND ";
		}
		
		if (isset($menu_location_id)) {
		    $query .= "m.menu_location_id=" . $menu_location_id . " AND ";
		}
		
		$query .="1=1 ";

		if (isset($this->order_by)) {
		    $query .= "order by m." . $this->order_by;
		}
		else {
			$query .= "order by m.menu_order";
		}

		$result = $this->db->Execute($query);
		
		if (isset($result->fields)) {
			$temp = array();

			while (!$result->EOF) {

				$temp1 = $result->fields;
				array_push($temp, $temp1);

				$result->MoveNext();
			}

			$result->Close();
			return $temp;
		}
		else {
			$error_info = "function=selMenu class=Menu.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	} //EO selMenu()
	
	
	
	// selMenuItem -----------------------------------------------------------
	// returns multiple rows of items from DB
	// tom calthrop - 22nd May 2004
	//
	function selMenuItem() {
		$query = "
			SELECT m.menu_title, m.menu_link, m.menu_id, m.menu_link_type_id, 
			m.menu_location_id, m.menu_order 
			FROM " . $this->db->prefix . "_menu m 
			WHERE "
		;
		
		if (isset($this->menu_id)) {
		    $query .= "m.menu_id=" . $this->menu_id . " AND ";
		}
		
		if (isset($this->language_id)) {
			$query .= "m.language_id=" . $this->language_id . " AND ";
		}
		
		$query .="1=1 ";

		$result = $this->db->SelectLimit($query, 1);
		
		if (isset($result->fields)) {

			$temp = $result->fields;
			$this->menu_id = $temp['menu_id'];
			
			$result->Close();

			return $temp;
		}
		else {
			$error_info = "function=selMenuItem class=Menu.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	} //EO selMenuItem()
	
	



	// insertMenuItem --------------------------------------------------------------------
	// inserts a topic
	// tom calthrop - 8th Jan 2004
	//
	function insertMenuItem($data) {
		if (empty($data['menu_title'])) {
			$GLOBALS['beacon_error_log'][] = array(3, null);
		}

		if (empty($GLOBALS['beacon_error_log'])) {
			if (!empty($data['wikipage']) && $data['wikipage'] != "0") {
				$menu_link_type_id = $this->config_menu['link_type']['wikipage'];
				$menu_link = $data['wikipage'];
			}
			elseif (!empty($data['tag_id'])) {
				$menu_link_type_id = $this->config_menu['link_type']['tag'];
				$menu_link = $data['tag_id'];
			}
			else {
				$menu_link_type_id = $this->config_menu['link_type']['external_link'];
				$menu_link = $data['ext_menu_link'];
				
				
				if ($menu_link == "http://") {
					$menu_link = "#";
				}
			}
			
			if (empty($data['menu_order'])) {
				$data['menu_order'] = 99;
			}
			
			$rec = array();
			$rec['menu_location_id'] = $data['menu_location_id'];
			$rec['menu_title'] = $data['menu_title'];
			$rec['menu_link'] = $menu_link;
			$rec['menu_link_type_id'] = $menu_link_type_id;
			$rec['language_id'] = $data['language_id'];
			$rec['menu_order'] = $data['menu_order'];
			$rec['user_id'] = $this->user_id;
			
			$table = $this->db->prefix . "_menu";
			$query = $this->db->GetInsertSQL($table, $rec, get_magic_quotes_gpc());
			
			$result = $this->db->Execute($query);
			
			if (empty($result)) {
				$error_info = "function=insertMenuItem class=Menu.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['beacon_error_log'][] = array(1, $error_info);
			}
		}
	}//EO insertMenuItem



	// updateMenuItem --------------------------------------------------------------------
	// updates a row from DB
	// tom calthrop - 21st December 2004
	//
	function updateMenuItem($data) {

		if (empty($data['menu_title'])) {
			$GLOBALS['beacon_error_log'][] = array(3, null);
		}

		if (empty($GLOBALS['beacon_error_log'])) {
			if (!empty($data['wikipage']) && $data['wikipage'] != "0") {
				$menu_link_type_id = $this->config_menu['link_type']['wikipage'];
				$menu_link = $data['wikipage'];
			}
			elseif (!empty($data['tag_id'])) {
				$menu_link_type_id = $this->config_menu['link_type']['tag'];
				$menu_link = $data['tag_id'];
			}
			else {
				$menu_link_type_id = $this->config_menu['link_type']['external_link'];
				$menu_link = $data['ext_menu_link'];
				
				
				if ($menu_link == "http://") {
					$menu_link = "#";
				}
			}
			
			if (empty($data['menu_order'])) {
				$data['menu_order'] = 99;
			}
			
			$query = "
				SELECT * 
				FROM " . $this->db->prefix . "_menu
				WHERE 
				menu_id=" . $data['menu_id']
			;
			
			$result = $this->db->Execute($query);
			
			$rec = array();
			$rec['menu_location_id'] = $data['menu_location_id'];
			$rec['menu_title'] = $data['menu_title'];
			$rec['menu_link'] = $menu_link;
			$rec['menu_link_type_id'] = $menu_link_type_id;
			$rec['language_id'] = $data['language_id'];
			$rec['menu_order'] = $data['menu_order'];
			$rec['user_id'] = $this->user_id;
			
			$query = $this->db->GetUpdateSQL($result, $rec, false, get_magic_quotes_gpc());
			
			$result = $this->db->Execute($query);
			
			if (empty($result)) {
				$error_info = "function=updateMenuItem class=Menu.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
				$GLOBALS['beacon_error_log'][] = array(1, $error_info);
			}
		}
	}//EO updateMenuItem



	// deleteMenuItem --------------------------------------------------------------------
	// deletes topic row from DB
	// tom calthrop - 28th December 2004
	//
	function deleteMenuItem($menu_id) {

		$query = "
			DELETE FROM " . $this->db->prefix . "_menu 
			WHERE
			menu_id =" . $menu_id;
		;

		$result = $this->db->Execute($query);

		if (empty($result)) {
			$error_info = "function=deleteMenuItem class=Menu.class.php -- " . $query . " -- " . $this->db->ErrorMsg();
			$GLOBALS['beacon_error_log'][] = array(1, $error_info);
		}
	}//EO deleteMenuItem

}
?>
