<?php

// -----------------------------------------------------------------------
// This file is part of aroundme
//
// Copyright (C) 2003, 2005 Barnraiser
// http://www.barnraiser.org/
// info@barnraiser.org
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any
// later version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with program; see the file COPYING. If not, write to the Free
// Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
// 02110-1301, USA.
// -----------------------------------------------------------------------

?>

<form action="list.php" method="post" name="list">

<div class="col_main">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_list'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php echo $lang['txt_list_intro'];?><br />
				</p>
				
				<?php
				if (isset($items)) {
				$display_items = trimArray($items);
				?>
				
				<table width="100%" cellpadding="4" cellspacing="0" border="0">
					<?php
					foreach($display_items as $key => $i):
					?>
					<tr>
						<td>
							<b><a href="index.php?item_id=<?php echo $i['item_id'];?>"><?php echo $this->date->formatDate($i['item_create_datetime'],1);?></a>: <?php echo $i['item_title'];?></b><br />
							<?php echo $i['item_synopsis'];?><br />
						</td>
					</tr>
					<tr>
						<td>
							<?php echo $lang['txt_tag'];?>: 
				
							<?php
							$tags = "";
							if (isset($i['tags'])) {
								foreach ($i['tags'] as $keyt => $t):
									$tags .= $t['tag_body'];
									
									if (count($i['tags']) > $keyt+1) {
										$tags .= ", ";
									}
								endforeach;
								
								if (isset($tag)) {
									$tags = searchTextFormat($tag, $tags);
								}
								
								echo $tags;
							}
							?>
						</td>
					</tr>
					<?php
					endforeach;
					?>
				</table>
				<?php
				echo createArrayList($items);
				}
				else {
				?>
				<p>
					<?php echo $lang['err_no_items'];?><br />
				</p>
				<?php }?>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>

<div class="col_side">
	<div class="box">
		<div class="box_top">
			<?php echo $lang['hdr_options'];?><br />
		</div>
		
		<div class="box_mid">
			<div class="content">
				<p>
					<?php
					$out_tags = "";
					
					if (!empty($node_tags)) {
						echo "<b>" . $lang['txt_tag_search'] . "</b><br />";
						foreach ($node_tags as $key => $i):
							$out_tags .= "<a href='list.php?tag=" . $i['tag_body']. "'>" . $i['tag_body'] . "</a>";
							
							if (count($node_tags) > $key+1) {
								$out_tags .= ", ";
							}
						endforeach;
					}
					
					echo $out_tags;
					?>
				</p>
				
				<p>
					<h3><?php echo $lang['hdr_search'];?></h3>
				</p>
				
				<p>
					<input type="radio" class="blank" name="search_version" value="0" checked="checked" />&nbsp;
					<?php echo $lang['txt_search_version_new'];?><br />
					
					<input type="radio" name="search_version" value="1" />&nbsp;
					<?php echo $lang['txt_search_version_all'];?><br />
				<p>
					<input type="text" name="search_text" class"search_input" size="20" value="<?php if (isset($frmdata['search_text'])) { echo $frmdata['search_text'];};?>" />
					<input type="image" src="<?php echo $templatePath;?>img/go.png" value="search" class="go" /><br />
				</p>
			</div>
		</div>
	</div>
		
	<div class="box_bottom">
		<span class="box_bottom_right"></span>
		<span class="box_bottom_left"></span>
	</div>
</div>
</form>
