<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Database_OfflineResources
{
  private static $instance;
  private function __construct() {
    $this->db = Database_SQLite::connect ("offlineresources");
  }
  public static function getInstance()
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_OfflineResources ();
    }
    return self::$instance;
  }


  public function create ()
  {
$sql = <<<'EOD'
CREATE TABLE IF NOT EXISTS offlineresources (
  name text,
  book integer,
  chapter integer,
  verse integer,
  html text
);
EOD;
    Database_SQLite::exec ($this->db, $sql);
    $sql = "CREATE INDEX IF NOT EXISTS speedup ON offlineresources (name, book, chapter, verse)";
    Database_SQLite::exec ($this->db, $sql);
  }


  public function optimize () {
    Database_SQLite::exec ($this->db, "REINDEX offlineresources;");
    Database_SQLite::exec ($this->db, "VACUUM offlineresources;");
  }


  public function delete ($name)
  {
    $name = Database_SQLiteInjection::no ($name);
    $query = "DELETE FROM offlineresources WHERE name = '$name';";
    Database_SQLite::exec ($this->db, $query);
  }


  public function store ($name, $book, $chapter, $verse, $html)
  {
    $name = Database_SQLiteInjection::no ($name);
    $book = Database_SQLiteInjection::no ($book);
    $chapter = Database_SQLiteInjection::no ($chapter);
    $verse = Database_SQLiteInjection::no ($verse);
    $html = Database_SQLiteInjection::no ($html);
    $query = "INSERT INTO offlineresources (name, book, chapter, verse, html) VALUES ('$name', $book, $chapter, $verse, '$html');";
    Database_SQLite::exec ($this->db, $query);
  }


  public function exists ($name, $book, $chapter, $verse)
  {
    $name = Database_SQLiteInjection::no ($name);
    $book = Database_SQLiteInjection::no ($book);
    $chapter = Database_SQLiteInjection::no ($chapter);
    $verse = Database_SQLiteInjection::no ($verse);
    $query = "SELECT count(*) FROM offlineresources WHERE name = '$name' AND book = $book AND chapter = $chapter AND verse = $verse;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return ($row [0] == 1);
    }
    return false;
  }


  // Counts the number of verses in the offline resource $name.
  public function count ($name)
  {
    $name = Database_SQLiteInjection::no ($name);
    $query = "SELECT count(*) FROM offlineresources WHERE name = '$name';";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row [0];
    }
    return 0;
  }


  public function get ($name, $book, $chapter, $verse)
  {
    $name = Database_SQLiteInjection::no ($name);
    $book = Database_SQLiteInjection::no ($book);
    $chapter = Database_SQLiteInjection::no ($chapter);
    $verse = Database_SQLiteInjection::no ($verse);
    $query = "SELECT html FROM offlineresources WHERE name = '$name' AND book = $book AND chapter = $chapter AND verse = $verse;";
    $result = Database_SQLite::query ($this->db, $query);
    foreach ($result as $row) {
      return $row[0];
    }
    return "";
  }


}



?>
