<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
?>
<h2><?php echo gettext ("Install Bibledit-Web 1.4 on Ubuntu 13.10") ?></h2>
<p>
  <?php echo gettext ("Follow the steps below to install Bibledit-Web.") ?>
  <?php echo gettext ("It needs some basic knowledge of working with Linux servers.") ?>
</p>
<ol>
<li><?php echo gettext ("Open a terminal.") ?></li>
<li>
  <p><?php echo gettext ("Update the software sources:") ?></p>
  <p><code>$ sudo apt-get update</code></p>
</li>
<li>
  <p><?php echo gettext ("Start installing the web server:") ?></p>
  <p><code>$ sudo apt-get install tasksel</code></p>
  <p><code>$ sudo tasksel</code></p>
</li>
<li><?php echo gettext ("Enable the LAMP server, and install.") ?></li>
<li>
  <?php echo gettext ("Test the web server by opening the site in the browser, for example:") ?>
  http://localhost
  <?php echo gettext ("or") ?>
  http://website.org.
  <?php echo gettext ("When the web server works, the browser displays:") ?> It works!
</li>
<li>
  <p><?php echo gettext ("Install the software Bibledit-Web relies on:") ?></p>
  <p><code>$ sudo apt-get install git unzip libzend-framework-php sqlite3 python perl libsword-utils rcs php5-gd tidy php5-json php5-tidy php5-sqlite</code></p>
</li>
<li>
  <p><?php echo gettext ("Download Bibledit-Web:") ?></p>
  <p><code>$ wget http://download.savannah.nongnu.org/releases/bibledit-web/source/bibledit-web-1.4.zip</code></p>
</li>
<li>
  <p><?php echo gettext ("Install Bibledit-Web in folder /var/www as user root:") ?></p>
  <p><code>$ cd /var/www</code></p>
  <p><code>$ sudo unzip ~/bibledit-web-1.4.zip</code></p>
</li>
<li>
  <p><?php echo gettext ("Make everything readable and writable to the web server user:") ?></p>
  <p><code>$ chown -R www-data:www-data bibledit-web</code></p>
</li>
<li><?php echo gettext ("Bibledit-Web will be accessible through:") ?> http://website.org/bibledit-web.</li>
<li><?php echo gettext ("Open the web address in the browser, and follow the steps on the screen to configure Bibledit-Web and log in.") ?></li>
<li>
  <a href="https://help.ubuntu.com/community/EnablingUseOfApacheHtaccessFiles" target="_blank"><?php echo gettext ("Enable the use of .htaccess files in Apache to secure some Bibledit-Web folders.") ?></a>
  <?php echo gettext ("Edit file apache2.conf instead of the one mentioned in the guide.") ?>
</li>
</ol>
<p>
  <?php echo gettext ("Due to the new installer of Bibledit-Web 1.4, older versions cannot be upgraded.") ?>
  <?php echo gettext ("These need to be uninstalled first.") ?>
  <?php echo gettext ("The database can be left in place.") ?>
  <?php echo gettext ("It will be upgraded.") ?>
  <?php echo gettext ("Uninstallation can be done by using the tarball of, for example, Bibledit-Web 1.3, configure it, and then uninstall it:") ?>
  <code>$ sudo make uninstall</code>.
</p>
