<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


error_reporting (E_ALL);


$extensions = get_loaded_extensions ();


// PHP mysqli support.
$mysqli = in_array ("mysqli", $extensions);


// PHP multi-byte string support.
$mbstring = in_array ("mbstring", $extensions);


// PHP JSON support.
$json = in_array ("json", $extensions);


// PHP DOMDocument support.
$dom = in_array ("dom", $extensions);


// PHP DOMDocument support.
$posix = in_array ("posix", $extensions);


// PHP Tidy support.
$tidy = in_array ("tidy", $extensions);


// PHP SQLite 3 support.
$sqlite3 = in_array ("sqlite3", $extensions);


// Location of the Zend framework.
// Debian: dpkg -L zendframework: /usr/share/php/Zend
if (!isset ($zendpath)) {
  $zendpath = "/usr/share/php/Zend";
  if (!file_exists ($zendpath)) unset ($zendpath);
}
// Ubuntu: dpkg -L libzend-framework-php: /usr/share/php/libzend-framework-php/Zend
if (!isset ($zendpath)) {
  $zendpath = "/usr/share/php/libzend-framework-php/Zend";
  if (!file_exists ($zendpath)) unset ($zendpath);
}
// Unpacked Zend Framework zip file in top-level directory of web server.
if (!isset ($zendpath)) {
  $directory = dirname (dirname (__DIR__));
  $objects = new RecursiveIteratorIterator (new RecursiveDirectoryIterator ($directory));
  foreach ($objects as $name => $object) {
    $dirname = dirname ($name);
    $basename = basename ($dirname);
    if ($basename == "Zend") {
      $zendpath = $dirname;
    }
  }
}


// Write the path to file.
$writable = true;
if (isset ($zendpath)) {
  $filename = "../config/zend.php";
  $contents = array ();
  $contents [] = "<?php";
  $contents [] = '$zendpath = "' . $zendpath . '";';
  $contents [] = "?>";
  @$writable = file_put_contents ($filename, implode ("\n", $contents));
}


if ($mysqli && $mbstring && $json && $dom && $posix && $tidy && $sqlite3 && isset ($zendpath) && $writable) {
  header ("Location: step.php?referer=libraries");
  die;
}

?>
<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>Bibledit-Web Installation</title>
<link rel="stylesheet" href="stylesheet.css" type="text/css" />
</head>
<body>
<h1><img src="../assets/bibledit.png"> <a href="http://bibledit.org/">Bibledit-Web</a></h1>
<p>Bibledit-Web has tried to find the libraries it relies on, and has found problems.</p>
<ul>
  <strong>
    <?php if (!$mysqli) { ?>
      <li>Bibledit-Web cannot find PHP mysqli support. It usually is in package <code>php5-mysql</code> on Debian and derivatives, or in <code>php-mysql</code> on CentOS.</li>
    <?php } ?>
    <?php if (!$json) { ?>
      <li>Bibledit-Web cannot find PHP JSON support. It usually is in package <code>php5-json</code>.</li>
    <?php } ?>
    <?php if (!$mbstring) { ?>
      <li>Bibledit-Web cannot find PHP Multibyte String support. On CentOS it is in package <code>php-mbstring</code>.</li>
    <?php } ?>
    <?php if (!$dom) { ?>
      <li>Bibledit-Web cannot find PHP DOMDocument support. On CentOS it is in package <code>php-xml</code>.</li>
    <?php } ?>
    <?php if (!$posix) { ?>
      <li>Bibledit-Web cannot find PHP POSIX support. On CentOS it is in package <code>php-posix</code>.</li>
    <?php } ?>
    <?php if (!$tidy) { ?>
      <li>Bibledit-Web cannot find PHP Tidy support. It usually is in package <code>php5-tidy</code> on Debian and derivatives, or in <code>php-tidy</code> on CentOS.</li>
    <?php } ?>
    <?php if (!$tidy) { ?>
      <li>Bibledit-Web cannot find PHP SQLite 3 support. It usually is in package <code>php5-sqlitey</code> on Debian and derivatives.</li>
    <?php } ?>
    <?php if (!isset ($zendpath)) { ?>
      <li>
        Bibledit-Web cannot find the Zend Framework.
        It is in package <code>zendframework</code> on Debian or in <code>libzend-framework-php</code> for Ubuntu.
        Or <a href="http://framework.zend.com/downloads/latest" target="_blank">download a release of Zend Framework 1</a> and unpack it in the same directory where Bibledit-Web was unpacked.
      </li>
    <?php } ?>
    <?php if (!$writable) { ?>
      <li>Bibledit-Web does not have permission to write the information to file <code><?php echo realpath ("../config/zend.php"); ?></code>.</li>
    <?php } ?>
  </strong>
</ul>
<p>Please install the missing libraries. Your hosting provider will be able to advise what to do with regard to the problems mentioned.</p>
<p><a href="libraries.php" class="button button-large">Retry</a></p>
</body>
</html>
