<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("../bootstrap/bootstrap.php");


// Security.
if (php_sapi_name () != "cli") {
  echo "Fatal: This only runs through the CLI SAPI";
  die;
}


ignore_user_abort (true);
set_time_limit (0);


$database_watchdog = Database_Watchdog::getInstance ();
$database_logs = Database_Logs::getInstance ();
$database_tasks = Database_Tasks::getInstance ();


$startTime = time ();


// Run for a short while stopping before the full minute.
while (time () < ($startTime + 10)) {

  
  // Kick the watchdog.
  $database_watchdog->kick ();


  // Count the running tasks.
  // Deal with any output from the completed tasks.
  $runningTasksCount = 0;
  $actives = $database_tasks->actives ();
  foreach ($actives as $active) {
    $pid = $active ['pid'];
    if (file_exists ('/proc/'.$pid)) {
      $runningTasksCount++;
      continue;
    }
    $rowid = $active ['rowid'];
    $database_tasks->erase ($rowid);
    $logfile = $active ['logfile'];
    if (!file_exists ($logfile)) continue;
    $lines = file ($logfile);
    unlink ($logfile);
    $process = $active ['process'];
    $database_logs->log ("Exit $process");
    foreach ($lines as $line) {
      $database_logs->log ($line);
    }
  }


  // In case the maximum number of parallel running tasks has not yet been reached,
  // start more tasks, if they are available.
  // With MySQL we cannot have too many connections at once. This limits the number of parallel tasks.
  if ($runningTasksCount < 10) {
    $task = $database_tasks->next ();
    if ($task) {
      $process = $task ['process'];
      $id = $task ['rowid'];
      $logfile = tempnam (sys_get_temp_dir (), "");
      $command = "$process > $logfile 2>&1 & echo $!";
      $pid = trim (shell_exec ($command));
      $database_logs->log ("Launch $process ($pid)", Filter_Roles::ADMIN_LEVEL);
      $database_tasks->run ($id, $pid, $logfile);
    }
  }  

  
  // Sleep for a short while: No overloading of the system.
  sleep (1);
}


// Check how many processes run this script in this directory.
$counter = 0;
$output = array ();
exec ("ps ax", $output, $exitcode);
if ($exitcode == 0) {
  foreach ($output as $line) {
    if (strpos ($line, "run.php") !== false) {
      $pid = (integer) $line;
      $output2 = array ();
      exec ("pwdx $pid 2> /dev/null", $output2, $exitcode);
      if ($exitcode == 0) {
        foreach ($output2 as $line2) {
          $directory = substr ($line2, strlen ($pid) + 2);
          if ($directory == __DIR__) {
            $counter++;
          }
        }
      }
    }
  }
}


// If one process runs, then it will be this process. Start another one just before this one dies.
// In all other cases, the script just dies, and the crontab timer will have to start another one.
// The purpose of all of this is to ensure that the script does not run simultaneously with another one,
// so that processes would start more than once.
// There have been regular cases that the send/receive process was started twice, with the result
// that git locked.
// We also have seen cases of the same emails sent out more than once.
// And cases where the change notifications were given five times, because five scripts ran simultaneously.
if ($counter == 1) {
  shell_exec ("php run.php > /dev/null 2>&1 &");
}


?>
