<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


// Security.
if (php_sapi_name () != "cli") {
  echo "Fatal: This only runs through the CLI SAPI";
  die;
}


ignore_user_abort (true);
set_time_limit (0);
chdir (__DIR__);


require_once ("../bootstrap/bootstrap.php");


function filter_tasks ($input)
{
  // Filter input.
  $output = array ();
  if (is_array ($input)) {
    foreach ($input as $task) {
      if (!isset ($task ['process'])) continue;
      if (!isset ($task ['priority'])) continue;
      $output [] = $task;
    }
  }
  unset ($task);
  return $output;
}


$database_logs = Database_Logs::getInstance ();


$tasks = array ();
$existingTasks = glob (__DIR__ . "/*.tasks");
foreach ($existingTasks as $file) {
  $tasks = file_get_contents ($file);
  @unlink ($file);
  $tasks = unserialize ($tasks);
}
$tasks = filter_tasks ($tasks);


// Run for less than a minute stopping just before the full minute.
while ((time () % 60) < 57) {


  //file_put_contents ("1.task", "sleep 2\n5");
  

  // Load any new queued tasks from the filesystem.
  $newTasks = glob (__DIR__ . "/*.task");
  foreach ($newTasks as $file) {
    $task = file ($file);
    @unlink ($file);
    $task ['process'] = trim ($task [0]);
    unset ($task [0]);
    $task ['priority'] = trim ($task [1]);
    unset ($task [1]);
    // Don't add an already queued task.
    $alreadyQueued = false;
    foreach ($tasks as $offset => $queued) {
      if ($task ['process'] == $queued ['process']) {
        $alreadyQueued = true;
        $tasks [$offset] ['priority']++;
      }
    }
    if (!$alreadyQueued) $tasks [] = $task;
  }


  // Count the running tasks.
  // Deal with any output from the completed tasks.
  $runningTasksCount = 0;
  foreach ($tasks as $offset => $task) {
    @$pid = $task ['pid'];
    if (isset ($pid)) {
      // Read the process list.
      // The first method, now commented out, see below, used forking to start "ps".
      // This forking is expensive.
      // The new method reads the process list from the file system.
      // To make this work, it clears the file stat cache each time.
      clearstatcache ();
      if (file_exists ("/proc/$pid")) {
        $runningTasksCount++;
      } else {
        $logfile = $task ['logfile'];
        if (file_exists ($logfile)) {
          $lines = file ($logfile);
          unlink ($logfile);
          $process = $task ['process'];
          //echo "Exit $process ($pid)\n";
          if (count ($lines)) {
            $database_logs->log ("$process ($pid)");
            foreach ($lines as $line) {
              $database_logs->log ($line);
            }
          }
        }
        unset ($tasks [$offset]);
      }
    }
  }
  
  
  // When the maximum number of parallel running tasks has not yet been reached,
  // start another task, if available.
  // Start task with highest priority first.
  if ($runningTasksCount < 10) {
    $highestPriority = -1;
    $matchingOffset = -1;
    foreach ($tasks as $offset => $task) {
      if (!isset ($task ['pid'])) {
        $priority = $task ['priority'];
        if ($priority > $highestPriority) {
          $highestPriority = $priority;
          $matchingOffset = $offset;
        }
      }
    }
    if ($matchingOffset >= 0) {
      $logfile = tempnam (sys_get_temp_dir (), "");
      $process = $tasks [$matchingOffset] ['process'];
      $command = "$process > $logfile 2> $logfile & echo $!";
      $pid = exec ($command);
      $pid = trim ($pid);
      //echo "Launch $process ($pid)\n";
      // If the task count not be started, set its priority one step lower. It will be retried later on.
      if ($pid != "") {
        $tasks [$matchingOffset] ['pid'] = $pid;
        $tasks [$matchingOffset] ['logfile'] = $logfile;
        $tasks [$matchingOffset] ['time'] = time ();
      } else {
        if ($tasks [$matchingOffset] ['priority'] > 1) $tasks [$matchingOffset] ['priority'] --;
      }
    }
  }
 
  // Sleep for a short while to not overload the system.
  sleep (1);
}


// Kill tasks running for more than x hours.
$time = time ();
foreach ($tasks as $offset => $task) {
  if (isset ($task ['time'])) {
    if ($time > ($task ['time']) + 21600) {
      $pid = $task ['pid'];
      posix_kill ($pid, SIGKILL);
      $process = $task ['process'];
      $database_logs = Database_Logs::getInstance ();
      $database_logs->log ("Killing stuck process $process with PID $pid", Filter_Roles::ADMIN_LEVEL);
      unset ($tasks [$offset]);
    }
  }
}



// Save any remaining tasks to disk.
// The next time the script runs it picks the tasks up again.
$tasks = array_values ($tasks);
$tasks = serialize ($tasks);
$time = time ();
$path = __DIR__ . "/$time.tasks";
file_put_contents ($path, $tasks);


?>
