// Generated on 2011 June Thu, 30 at 04:06:35 by the CERTI message generator
#ifndef ADDRESSBOOK_H
#define ADDRESSBOOK_H
// ****-**** Global System includes ****-****
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <assert.h>
#include <string.h>
// ****-**** Includes coming from native types ****-****

#include "MsgBuffer.h"
// The generated file will be put in 
// the MsgTutorial package
//package MsgTutorial 

   // Native types has been defined:
   //     - by included headers (see above)
   //     - with typedef (see below [if any])

   typedef uint32_t M_Type;

   typedef char* MStreamType;
   //addressbook package equivalent in C
   static const uint32_t addressbook_versionMajor = 1;
   static const uint32_t addressbook_versionMinor = 0;

   typedef enum addressbook_PhoneType {
      MOBILE = 0, 
      HOME, 
      WORK 

   } addressbook_PhoneType; //end of enum PhoneType 



   typedef enum addressbook_MessageType {
      NOT_USED = 0, 
      PERSON, 
      ADDRESSBOOK, 
      LAST 

   } addressbook_MessageType; //end of enum MessageType 

   typedef struct  nmsg {
      uint32_t type;
      char[] messageName;
   } nmsg_t; 

   void nmsg_create();
   void nmsg_destroy();

   void nmsg_serialize(nmsg_t* cthis, MsgBuffer_t* msgBuffer);
   void nmsg_deserialize(nmsg_t* cthis, MsgBuffer_t* msgBuffer);
   // specific Getter(s)/Setter(s)
   const uint32_tnmsg_getType(nmsg_t cthis) const {return cthis.type;}
   void nmsg_setType(nmsg_t* cthis, const uint32_t newType) {cthis->type=newType;}
   const char[]nmsg_getMessageName(nmsg_t cthis) const {return cthis.messageName;}
   void nmsg_setMessageName(nmsg_t* cthis, const char[] newMessageName) {cthis->messageName=newMessageName;}
   // the show method
   FILE* show(FILE* out);

   typedef struct  PhoneNumber {
      char[] number;
      addressbook_PhoneType type;
      uint_8 _hasType;
   } PhoneNumber_t; 

   void PhoneNumber_create();
   void PhoneNumber_destroy();

   void PhoneNumber_serialize(PhoneNumber_t* cthis, MsgBuffer_t* msgBuffer);
   void PhoneNumber_deserialize(PhoneNumber_t* cthis, MsgBuffer_t* msgBuffer);
   // specific Getter(s)/Setter(s)
   const char[]PhoneNumber_getNumber(PhoneNumber_t cthis) const {return cthis.number;}
   void PhoneNumber_setNumber(PhoneNumber_t* cthis, const char[] newNumber) {cthis->number=newNumber;}
   const addressbook_PhoneTypePhoneNumber_getType(PhoneNumber_t cthis) const {return cthis.type;}
   void PhoneNumber_setType(PhoneNumber_t* cthis, const addressbook_PhoneType newType) {
      cthis->_hasType=1;
      cthis->type=newType;
   }
   uint_8 hasType(PhoneNumber_t cthis) {return PhoneNumber.Type;}
   // the show method
   FILE* show(FILE* out);

   typedef struct  Person{
      nmsg super;
      char[] name;
      int32_t id;
      char[] email;
      uint_8 _hasEmail;
      PhoneNumber[] phone;
      uint32_t phonesize;
   } Person_t; 

   void Person_create();
   void Person_destroy();

   void Person_serialize(Person_t* cthis, MsgBuffer_t* msgBuffer);
   void Person_deserialize(Person_t* cthis, MsgBuffer_t* msgBuffer);
   // specific Getter(s)/Setter(s)
   const char[]Person_getName(Person_t cthis) const {return cthis.name;}
   void Person_setName(Person_t* cthis, const char[] newName) {cthis->name=newName;}
   const int32_tPerson_getId(Person_t cthis) const {return cthis.id;}
   void Person_setId(Person_t* cthis, const int32_t newId) {cthis->id=newId;}
   const char[]Person_getEmail(Person_t cthis) const {return cthis.email;}
   void Person_setEmail(Person_t* cthis, const char[] newEmail) {
      cthis->_hasEmail=1;
      cthis->email=newEmail;
   }
   uint_8 hasEmail(Person_t cthis) {return Person.Email;}
   uint32_t Person_getPhoneSize(Person_t cthis) const {
   assert(rank<cthis->phonesize);
    return cthis.phonesize;}
   void Person_setPhoneSize(Person_t* cthis, uint32_t num) { 
      phone* temp;
      temp = calloc(num,sizeof(phone));
      memcpy(temp,cthis->phone, cthis->phonesize);
      free(cthis->phone);
      cthis->phone = temp;
      cthis->phonesize = num;
   }
   const PhoneNumber* getPhone() const {return phone;}
   const PhoneNumber Person_getPhone(Person_t cthis, uint32_t rank) const {return cthis.phone[rank];}
   PhoneNumberPerson_getPhone(Person_t* cthis, uint32_t rank) {return cthis->phone[rank];}
   void Person_setPhone(Person_t* cthis, const PhoneNumber newPhone, uint32_t rank) {cthis->phone[rank]=newPhone;}
   void removePhone(uint32_t rank) {cthis->phone.erase(phone.begin() + rank);}
   // the show method
   FILE* show(FILE* out);

   typedef struct  AddressBook{
      nmsg super;
      Person[] person;
      uint32_t personsize;
   } AddressBook_t; 

   void AddressBook_create();
   void AddressBook_destroy();

   void AddressBook_serialize(AddressBook_t* cthis, MsgBuffer_t* msgBuffer);
   void AddressBook_deserialize(AddressBook_t* cthis, MsgBuffer_t* msgBuffer);
   // specific Getter(s)/Setter(s)
   uint32_t AddressBook_getPersonSize(AddressBook_t cthis) const {
   assert(rank<cthis->personsize);
    return cthis.personsize;}
   void AddressBook_setPersonSize(AddressBook_t* cthis, uint32_t num) { 
      person* temp;
      temp = calloc(num,sizeof(person));
      memcpy(temp,cthis->person, cthis->personsize);
      free(cthis->person);
      cthis->person = temp;
      cthis->personsize = num;
   }
   const Person* getPerson() const {return person;}
   const Person AddressBook_getPerson(AddressBook_t cthis, uint32_t rank) const {return cthis.person[rank];}
   PersonAddressBook_getPerson(AddressBook_t* cthis, uint32_t rank) {return cthis->person[rank];}
   void AddressBook_setPerson(AddressBook_t* cthis, const Person newPerson, uint32_t rank) {cthis->person[rank]=newPerson;}
   void removePerson(uint32_t rank) {cthis->person.erase(person.begin() + rank);}
   // the show method
   FILE* show(FILE* out);

   typedef struct  M_Factory {
      public:
         static nmsg* create(M_Type type) throw (string); 
      protected:
      private:
   };

// end of namespace MsgTutorial 
// ADDRESSBOOK_H
#endif
