#ifndef _ALLOCATE_ME_HH
#define _ALLOCATE_ME_HH

#include <string>

class AllocateMe {
public:
	AllocateMe();
	AllocateMe(const std::string& name);
	~AllocateMe();

	const std::string getName();
	void setName(const std::string& name) {_name = name;}
	int getId() {return _id;}

private:
	static int counter;
	int _id;
	std::string _name;
};

class AllocateMeOver {
public:
	AllocateMeOver();
	AllocateMeOver(const std::string& name);
	~AllocateMeOver();

	const std::string getName();
	void setName(const std::string& name) {_name = name;}
	int getId() {return _id;}

	// overloaded operators
	void* operator new(size_t s) throw (std::bad_alloc);
	void* operator new[] (size_t s) throw (std::bad_alloc);
	void operator delete(void* addr) throw ();
	void operator delete[] (void* addr) throw ();

private:
	static int counter;
	int _id;
	std::string _name;
};

#endif
