
package hla.rti;

/**
 * This iterator interface is intended to be used with HandleSets.
 * It differs from the usual Java Enumerator. The typical idiom
 * is:
 *   for (HandleIterator i = handleSet.handles(), int h = i.first();
 	        i.isValid();
 	        h = i.next(); {
 	      ...
 	  }
 * The handle value h will iterate through all the values in the set. 
 * This interface was generated by a SmartGuide.
 * 
 */
public interface HandleIterator {

/**
 * Call this to get the first valid handle. Resets the iterator.
 * @return int: first valid handle in set, or -1
 */
public int first();
/**
 * Should be checked before using return from first() or next()
 * @return boolean: true if currently reported handle is valid.
 */
public boolean isValid();
/**
 * @return int: next valid handle in set, or -1
 */
public int next();
}
