/*
 * hla.hxx - FlightGear interface to HLA 1.3
 * http://virtualair.sourceforge.net
 *
 * Copyright (C) 2008  Petr Gotthard <petr.gotthard@centrum.cz>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * $Id: hla.hxx 6 2008-06-01 12:21:09Z gotthardp $
 */

#ifndef _FG_HLA_HXX_
#define _FG_HLA_HXX_

#define FG_HLA_HID "$Id: hla.hxx 6 2008-06-01 12:21:09Z gotthardp $"

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <AIModel/AIMultiplayer.hxx>
#include "protocol.hxx"

#ifndef RTI_USES_STD_FSTREAM
#define RTI_USES_STD_FSTREAM
#endif
#include <NullFederateAmbassador.hh>

class FGHLA : public FGProtocol, public NullFederateAmbassador
{
public:
  FGHLA(const int rate, const std::string &federateName,
    const std::string &federationName, const std::string &federationModel = "");
  virtual ~FGHLA()
    throw (RTI::FederateInternalError);

  virtual bool open();
  virtual bool close();

  virtual bool process();

  virtual void discoverObjectInstance(RTI::ObjectHandle object_handle,
    RTI::ObjectClassHandle class_handle, const char *event_tag)
  throw (RTI::CouldNotDiscover, RTI::ObjectClassNotKnown, RTI::FederateInternalError);

  void reflectAttributes(
    RTI::ObjectHandle object_handle, const RTI::AttributeHandleValuePairSet &values);

  // RTI::FederateAmbassador methods
  virtual void reflectAttributeValues(RTI::ObjectHandle object_handle,
    const RTI::AttributeHandleValuePairSet &values, const RTI::FedTime &time,
    const char *event_tag, RTI::EventRetractionHandle retraction_handle)
  throw (RTI::ObjectNotKnown, RTI::AttributeNotKnown, RTI::FederateOwnsAttributes,
    RTI::InvalidFederationTime, RTI::FederateInternalError)
  {
    reflectAttributes(object_handle, values);
  }

  virtual void reflectAttributeValues(RTI::ObjectHandle object_handle,
    const RTI::AttributeHandleValuePairSet &values, const char *event_tag)
  throw (RTI::ObjectNotKnown, RTI::AttributeNotKnown, RTI::FederateOwnsAttributes,
    RTI::FederateInternalError)
  {
    reflectAttributes(object_handle, values);
  }

  virtual void removeObjectInstance(RTI::ObjectHandle object_handle, const RTI::FedTime &time,
    const char *event_tag, RTI::EventRetractionHandle retraction_handle)
  throw (RTI::ObjectNotKnown, RTI::InvalidFederationTime, RTI::FederateInternalError);

  virtual void removeObjectInstance(RTI::ObjectHandle object_handle, const char *event_tag)
  throw (RTI::ObjectNotKnown, RTI::FederateInternalError);

private:
  RTI::RTIambassador mRtiAmbassador;

  RTI::ObjectClassHandle mClassHandle;
  RTI::ObjectHandle mObjectHandle;
  RTI::AttributeHandle mAttrLocation;
  RTI::AttributeHandle mAttrOrientation;
  RTI::AttributeHandle mAttrLinearVelocity;
  RTI::AttributeHandle mAttrLinearAcceleration;
  RTI::AttributeHandle mAttrAngularVelocity;
  RTI::AttributeHandle mAttrVisualModel;

  // maps HLA objects to the FGAIMultiplayer
  typedef std::map<RTI::ObjectHandle, osg::ref_ptr<FGAIMultiplayer> > MultiPlayerMap;
  MultiPlayerMap mMultiPlayerMap;

  std::string mFederateName;
  std::string mFederationName;
  std::string mFederationModel;

  std::string mCallSign;
  bool mInitialised;
};

#endif // _FG_HLA_HXX_

