#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

/* This program is by Jed Wing,
with a couple of small fixes by Pabs */

void pee(){
	perror("peeing blood aaarrrrrghhhh");
	exit(-1);
}

/* ENCINT reader */
static unsigned long read_cdword(FILE *f)
{
    unsigned char buffer;
    unsigned long value = 0;
    int shift=0;

    do {
        fread(&buffer, 1, 1, f);
        value |= (buffer & 0x7f) << shift;
        shift += 7;
    } while (buffer & 0x80);

    return value;
}

static int read_dword(FILE *f)
{
    unsigned char buffer[4];
    int value;

    fread(buffer, 1, 4, f);
    value = buffer[0] |
                (buffer[1] << 8)  |
                (buffer[2] << 16) |
                (buffer[3] << 24);

    return value;
}

static short read_word(FILE *f)
{
    unsigned char buffer[2];
    short value;

    fread(buffer, 1, 2, f);
    value = buffer[0] |
                (buffer[1] << 8);

    return value;
}

static int dump_dword(FILE *f, const char *label)
{
    int value = read_dword(f);
    printf("%-32s: %08x\n", (label ?: " "), value);
    return value;
}

static short dump_word(FILE *f, const char *label)
{
    short value = read_word(f);
    printf("%-32s: %04x\n", (label ?: " "), value & 0xffff);
    return value;
}

struct page_index
{
    char       *name;
    short       name_len;
    short       unknown;
    long        offset;
};

static void read_page_index(FILE *f, struct page_index *page_idx)
{
	char t;
	fread(&page_idx->name_len, 1, 1, f);
	fread(&t, 1, 1, f);
    page_idx->name = malloc(page_idx->name_len);
	if( !page_idx->name ) pee(-1);
    memset(page_idx->name, 0, page_idx->name_len);
    fread(page_idx->name, 1, page_idx->name_len - 1, f);
    page_idx->offset = read_dword(f);
    page_idx->unknown = read_word(f);
}

struct index_entry
{
    struct index_entry *previous;
    struct index_entry *next;
    char               *name;
    unsigned char       is_in_title;
    unsigned long       count;
    unsigned long       offset;
    unsigned long       length;
    unsigned char       unknown[2];
};

static void dump_page(FILE *f)
{
    int i;
    struct index_entry *head=NULL, *cur=NULL;

    dump_dword(f, "next_page");
    dump_dword(f, NULL);

    for (;;)
    {
        struct index_entry *newEntry=NULL;
        unsigned char lengths[2];
        fread(lengths, 1, 2, f);
        if (lengths[0] == 0)
            break;

        newEntry = (struct index_entry *)malloc(sizeof(struct index_entry));
		if( !newEntry ) pee(-1);
        if (head == NULL)
        {
            head = cur = newEntry;
            newEntry->previous = NULL;
            newEntry->next = NULL;
        }
        else
        {
            newEntry->previous = cur;
            newEntry->next = NULL;
            cur->next = newEntry;
        }

        newEntry->name = (char *)malloc(lengths[0] + lengths[1]);
		if( !newEntry->name ) pee(-1);
        memcpy(newEntry->name, cur->name, lengths[1]);
        if (lengths[0] > 1)
            fread(newEntry->name + lengths[1], 1, lengths[0] - 1, f);
        newEntry->name[lengths[0] + lengths[1] - 1] = '\0';

        fread(&(newEntry->is_in_title), 1, 1, f);
        newEntry->count = read_cdword(f);
        newEntry->offset = read_dword(f);
        fread(newEntry->unknown, 1, 2, f);
        newEntry->length = read_cdword(f);
        cur = newEntry;
    }

    for (cur = head; cur != NULL; cur = cur->next)
    {
        printf("    %s %s  <%d, %d, %d>: ",
               cur->name,
               cur->is_in_title ? "(TITLE)" : "       ",
               cur->count, cur->offset, cur->length);

        fseek(f, cur->offset, SEEK_SET);
        for (i=0; i<cur->length; i++)
        {
            unsigned char b;
            fread(&b, 1, 1, f);
            printf(" %02x", b);
        }
        printf("\n");
    }

    while (head != NULL)
    {
        cur = head->next;
        free(head->name);
        free(head);
        head = cur;
    }
}

static void dump_file(FILE *f)
{
    short depth=0;
    int page_count=0;
    int page_index_offset=0;
    struct page_index *page_idx;
    int i;

    dump_dword(f, NULL);
    dump_dword(f, "num_files");
    dump_dword(f, NULL);
    dump_dword(f, NULL);
    page_count = dump_dword(f, "num_pages");
    page_index_offset = dump_dword(f, "pages_offset");
    depth = dump_word(f, "depth");

    switch (depth)
    {
        case 1:
            fseek(f, page_index_offset, SEEK_SET);
            printf("Entries:\n");
            dump_page(f);
            break;

        case 2:
            page_idx = (struct page_index *)malloc(page_count * sizeof(struct page_index));
			if( !page_idx ) pee(-1);
            fseek(f, page_index_offset, SEEK_SET);
            printf("Page Index:\n");
            dump_word(f, NULL);
            for (i=0; i<page_count; ++i){
                read_page_index(f, page_idx+i);
				printf("page_index %d: %s\n", i, (page_idx+i)->name);
			}

            for (i=0; i<page_count; ++i)
            {
                printf("  Page ending with '%s' (offset=%08x)\n", page_idx[i].name, page_idx[i].offset);
                if (page_idx[i].unknown != 0)
                    printf("    Page->unknown == %04x\n", page_idx[i].unknown);
                fseek(f, page_idx[i].offset, SEEK_SET);
                dump_page(f);
            }
            free(page_idx);
            break;

        default:
            printf("Unsupported depth!\n");
            return;
    }
}

int main(int c, char **v)
{
    FILE *f;
    int offset;

    if (c <= 1)
    {
        fprintf(stderr, "Usage: %s filename\n", v[0]);
    }

    if ((f = fopen(v[1], "rb")) == NULL)
    {
        fprintf(stderr, "Couldn't open file '%s'\n", v[1]);
        exit(1);
    }

    printf("%s:\n", v[1]);
    dump_file(f);

    fclose(f);

    return 0;
}
