/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.Pack;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.n3.nanoxml.XMLElement;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PacksPanel
extends IzPanel
implements ActionListener {
    private BoxLayout layout;
    private JLabel infoLabel;
    private JLabel tipLabel;
    private JLabel spaceLabel;
    private int bytes;
    private HashMap checkBoxes;
    private HashMap packsforBoxes;
    protected InstallData idata;

    public void panelActivate() {
        try {
            Iterator iterator = this.idata.availablePacks.iterator();
            this.bytes = 0;
            while (iterator.hasNext()) {
                Pack pack = (Pack)iterator.next();
                JCheckBox jCheckBox = (JCheckBox)this.checkBoxes.get(pack);
                if (jCheckBox == null) {
                    System.err.println("ERROR[PacksPanel]: internal error, no checkbox for Pack. ignoring");
                    continue;
                }
                if (pack.required) {
                    jCheckBox.setSelected(true);
                    this.bytes = (int)((long)this.bytes + pack.nbytes);
                    continue;
                }
                if (this.idata.selectedPacks.contains(pack)) {
                    this.bytes = (int)((long)this.bytes + pack.nbytes);
                }
                jCheckBox.setSelected(this.idata.selectedPacks.contains(pack));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.showSpaceRequired();
    }

    private final void showSpaceRequired() {
        StringBuffer stringBuffer = new StringBuffer(this.parent.langpack.getString("PacksPanel.space"));
        stringBuffer.append(Pack.toByteUnitsString(this.bytes));
        this.spaceLabel.setText(stringBuffer.toString());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        JCheckBox jCheckBox = (JCheckBox)object;
        Pack pack = (Pack)this.packsforBoxes.get(jCheckBox);
        if (jCheckBox.isSelected()) {
            this.idata.selectedPacks.add(pack);
            this.bytes = (int)((long)this.bytes + pack.nbytes);
        } else {
            this.idata.selectedPacks.remove(this.idata.selectedPacks.indexOf(pack));
            this.bytes = (int)((long)this.bytes - pack.nbytes);
        }
        this.showSpaceRequired();
    }

    public boolean isValidated() {
        return true;
    }

    public void makeXMLData(XMLElement xMLElement) {
        XMLElement xMLElement2 = new XMLElement("selected");
        int n = this.idata.selectedPacks.size();
        int n2 = 0;
        while (n2 < n) {
            XMLElement xMLElement3 = new XMLElement("pack");
            Pack pack = (Pack)this.idata.selectedPacks.get(n2);
            Integer n3 = new Integer(this.idata.availablePacks.indexOf(pack));
            xMLElement3.setAttribute("index", n3.toString());
            xMLElement2.addChild(xMLElement3);
            ++n2;
        }
        xMLElement.addChild(xMLElement2);
    }

    public void runAutomated(XMLElement xMLElement) {
        XMLElement xMLElement2 = xMLElement.getFirstChildNamed("selected");
        Vector vector = xMLElement2.getChildrenNamed("pack");
        int n = vector.size();
        this.idata.selectedPacks.clear();
        int n2 = 0;
        while (n2 < n) {
            XMLElement xMLElement3 = (XMLElement)vector.get(n2);
            Integer n3 = new Integer(xMLElement3.getAttribute("index"));
            int n4 = n3;
            this.idata.selectedPacks.add(this.idata.availablePacks.get(n4));
            ++n2;
        }
    }

    private final /* synthetic */ void this() {
        this.bytes = 0;
        this.checkBoxes = new HashMap();
        this.packsforBoxes = new HashMap();
    }

    public PacksPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        this.this();
        this.idata = installData;
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        JPanel jPanel = new JPanel();
        this.layout = new BoxLayout(jPanel, 1);
        jPanel.setLayout(this.layout);
        gridBagLayout.addLayoutComponent(jPanel, gridBagConstraints);
        this.add(jPanel);
        jPanel.add(Box.createVerticalStrut(10));
        this.infoLabel = new JLabel(installerFrame.langpack.getString("PacksPanel.info"), installerFrame.icons.getImageIcon("preferences"), 11);
        jPanel.add(this.infoLabel);
        jPanel.add(Box.createVerticalStrut(10));
        this.tipLabel = new JLabel(installerFrame.langpack.getString("PacksPanel.tip"), installerFrame.icons.getImageIcon("tip"), 11);
        jPanel.add(this.tipLabel);
        jPanel.add(Box.createVerticalStrut(20));
        int n = installData.availablePacks.size();
        int n2 = 0;
        while (n2 < n) {
            Pack pack = (Pack)installData.availablePacks.get(n2);
            String string = pack.description != null ? " " + pack.name + " : " + pack.description : " " + pack.name;
            JCheckBox jCheckBox = new JCheckBox(string, true);
            jCheckBox.addActionListener(this);
            if (pack.required) {
                jCheckBox.setEnabled(false);
            }
            this.checkBoxes.put(pack, jCheckBox);
            this.packsforBoxes.put(jCheckBox, pack);
            jPanel.add(jCheckBox);
            ++n2;
        }
        jPanel.add(Box.createVerticalStrut(20));
        this.spaceLabel = new JLabel(installerFrame.langpack.getString("PacksPanel.space"));
        jPanel.add(this.spaceLabel);
    }
}

