<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($rechte["admin"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");

if (!isset($_GET["type"]))
{
  ?>
  <h3>Kalender verwalten</h3>
  <table class="maintable">
  <form method="POST" action="index.php?action=admincp&amp;show=kalender&amp;type=neu">
  <tr class="rowberschrift">
    <td colspan="2"><b>Kalender erstellen</b></td>
  </tr>
  <tr class="row2">
    <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" /></td>
  </tr>
  <tr class="row2">
    <td>Beschreibung:</td><td><input class="inputtext" name="beschreibung" type="text" size="40" /></td>
  </tr>
  <tr class="row2">
    <td>&nbsp</td><td><input type="submit" value="erstellen" /></td>
  </tr>
  </form>
  <form method="POST" action="index.php?action=admincp&amp;show=kalender&amp;type=bearbeiten">
  <tr class="rowberschrift">
    <td colspan="2"><b>Kalender bearbeiten/lschen</b></td>
  </tr>
  <tr class="row2">
    <td>Kalender:</td>
    <td>
    <select class="inputtext" name="id" size="1">
    <?php
    $result = sql_select("*", "kalender", "ORDER BY id ASC", NULL, NULL);
    while ($ergebnis = sql_fetch_assoc($result))
    {
      echo "<option value=\"".$ergebnis["id"]."\" />".$ergebnis["id"]." - ".$ergebnis["titel"]."</option>";
    }
    ?>
    </select>
    <input name="kalender_bearbeiten" type="submit" value="bearbeiten" /> <input name="kalender_loeschen" type="submit" value="lschen" />
    </td>
  </tr>
  </form>
  </table>
  <?php
}
else
{
  //******************************* neu ****************************************
  if($_GET["type"]=="neu")
  {
    if(trim($_POST["titel"])=="") fehler("Jeder Kalender muss einen Titel haben!");
    // erst kalender erzeugen, dann bearbeiten-seite aufrufen
    // als besitzer erstmal den aktuellen admin-user nehmen
    $werte = array(
        "titel" => htmlspecialchars($_POST["titel"]),
        "beschreibung" => htmlspecialchars($_POST["beschreibung"]),
        "besitzer_id" => $user["id"],
        "besitzer_name" => $user["username"]
        );
    sql_insert("kalender", $werte);

    // id des neuen eintrags?
    $result = sql_select("id", "kalender", "ORDER BY id DESC");
    $ergebnis = sql_fetch_assoc($result);

    ?>
    <h3>Kalender erstellen</h3>
    Der Kalender wurde erfolgreich erstellt!<br />
    Klicken Sie jetzt auf "bearbeiten" um die Einstellungen fr den Kalender zu bearbeiten.<br />
    <form method="POST" action="index.php?action=admincp&amp;show=kalender&amp;type=bearbeiten">
    <input name="id" type="hidden" value="<?php echo $ergebnis["id"] ?>" />
    <input name="kalender_bearbeiten" type="submit" value="bearbeiten" />
    </form>
    <?php
  }
  if($_GET["type"]=="bearbeiten")
  {
    //lschen oder bearbeiten?
    //**************************** bearbeiten **********************************
    if(isset($_POST["kalender_bearbeiten"]))
    {
      if(!isset($_POST["bearbeiten_knopf"]))
      {
        //bearbeiten-formular
        //bisherige einstellungen abfragen:
        $kalenderresult = sql_select("*", "kalender", "WHERE id=".$_POST["id"], NULL, NULL);
        $kalender = sql_fetch_assoc($kalenderresult);

        $kalenderrechteresult = sql_select("*", "kalenderrechte", "WHERE kalender_id=".$kalender["id"], NULL, NULL);
        $lesen[] = 0; $schreiben[] = 0; $moderieren[] = 0;
        while($kalenderrechte = sql_fetch_assoc($kalenderrechteresult))
        {
          if($kalenderrechte["lesen"]      == 1) $lesen[]      = $kalenderrechte["gruppe_id"];
          if($kalenderrechte["schreiben"]  == 1) $schreiben[]  = $kalenderrechte["gruppe_id"];
          if($kalenderrechte["moderieren"] == 1) $moderieren[] = $kalenderrechte["gruppe_id"];
        }
        ?>
        <h3>Kalender bearbeiten</h3>
        <form method="POST" action="index.php?action=admincp&amp;show=kalender&amp;type=bearbeiten">
        <input name="kalenderid" type="hidden" value="<?php echo $_POST["id"] ?>" />
        <input name="kalender_bearbeiten" type="hidden" value="1" />
        <table class="maintable">
        <tr class="rowberschrift">
          <td colspan="2"><b>Allgemeines:</b></td>
        </tr>
        <tr class="row2">
          <td>Titel:</td><td><input class="inputtext" name="titel" type="text" value="<?php echo $kalender["titel"] ?>" size="40" /></td>
        </tr>
        <tr class="row2">
          <td>Beschreibung:</td><td><input class="inputtext" name="beschreibung" type="text" value="<?php echo $kalender["beschreibung"] ?>" size="40" /></td>
        </tr>
        <tr class="row2">
          <td>Besitzer:</td><td><input class="inputtext" name="besitzer" type="text" value="<?php echo $kalender["besitzer_name"] ?>" size="40" /></td>
        </tr>
        <tr class="row2">
          <td>Privat:</td><td><input class="inputtext" name="privat" type="radio" value="1" <?php if($kalender["privat"] == 1) echo "checked " ?>/>Ja <input class="inputtext" name="privat" type="radio" value="0" <?php if($kalender["privat"] == 0) echo "checked " ?>/>Nein</td>
        </tr>
        <tr class="rowberschrift">
          <td colspan="2"><b>Rechte:</b></td>
        </tr>
        <tr class="row2">
          <td>Lesen:</td><td><select multiple class="inputtext" name="lesen[]" size="5">
          <?php
          // welche gruppen gibt es?
          $gruppenresult = sql_select("id, titel", "gruppen ORDER BY id ASC", NULL, NULL);
          while($gruppen = sql_fetch_assoc($gruppenresult))
          {
            echo "<option value=\"".$gruppen["id"]."\"";
            if(in_array($gruppen["id"],$lesen))
            {
              echo "selected";
            }
            echo ">".$gruppen["titel"]."</option>";
          }
          ?>
          </select></td>
        </tr>
        <tr class="row2">
          <td>Schreiben:</td><td><select multiple class="inputtext" name="schreiben[]" size="5">
          <?php
          // welche gruppen gibt es?
          $gruppenresult = sql_select("id, titel", "gruppen ORDER BY id ASC", NULL, NULL);
          while($gruppen = sql_fetch_assoc($gruppenresult))
          {
            echo "<option value=\"".$gruppen["id"]."\"";
            if(in_array($gruppen["id"],$schreiben))
            {
              echo "selected";
            }
            echo ">".$gruppen["titel"]."</option>";
          }
          ?>
          </select></td>
        </tr>
        <tr class="row2">
          <td>Moderieren:</td><td><select multiple class="inputtext" name="moderieren[]" size="5">
          <?php
          // welche gruppen gibt es?
          $gruppenresult = sql_select("id, titel", "gruppen ORDER BY id ASC", NULL, NULL);
          while($gruppen = sql_fetch_assoc($gruppenresult))
          {
            echo "<option value=\"".$gruppen["id"]."\"";
            if(in_array($gruppen["id"],$moderieren))
            {
              echo "selected";
            }
            echo ">".$gruppen["titel"]."</option>";
          }
          ?>
          </select></td>
        </tr>
        <tr class="row2">
          <td>&nbsp</td><td><input name="bearbeiten_knopf" type="submit" value="bearbeiten" /></td>
        </tr>
        </table>
        </form>
        <?php
      }
      else
      {
        // datenbank-eintrag aktualisieren
        if(trim($_POST["titel"])=="") fehler("Jeder Kalender muss einen Titel haben!");
        if(trim($_POST["beschreibung"]) == "") fehler("Jeder Kalender muss eine Beschreibung haben!");
        if(trim($_POST["besitzer"]) == "") fehler("Jeder Kalender muss einen Besitzer haben!");

        // wenn eine gruppe, die in $_POST["lesen"] ist, noch nicht in der tabelle ist -> hinzufgen
        function checkgroups($value, $key)
        {
          if(sql_num_rows(sql_select("gruppe_id", "kalenderrechte", "WHERE kalender_id=".$_POST["kalenderid"]." AND gruppe_id=".$value, NULL, NULL)) == 0)
          {
            $werte = array("gruppe_id" => $value, "kalender_id" => $_POST["kalenderid"]);
            sql_insert("kalenderrechte", $werte);
          }
        }
        @array_walk($_POST["lesen"], 'checkgroups');
        @array_walk($_POST["schreiben"], 'checkgroups');
        @array_walk($_POST["moderieren"], 'checkgroups');

        // jede gruppe durchgehen
        $alterechteresult = sql_select("*", "kalenderrechte", "WHERE kalender_id=".$_POST["kalenderid"], NULL, NULL);
        function checkrechte($recht, $alterechte)
        {
          global $alterechte;
          // wenn diese gruppe ein recht hat -> aktualisieren
          if(in_array($alterechte["gruppe_id"],$_POST[$recht]))
          {
            $werte = array($recht => 1);
            sql_update("kalenderrechte", $werte, "WHERE gruppe_id=".$alterechte["gruppe_id"]." AND kalender_id=".$_POST["kalenderid"]);
          }
          else
          {
            $werte = array($recht => 0);
            sql_update("kalenderrechte", $werte, "WHERE gruppe_id=".$alterechte["gruppe_id"]." AND kalender_id=".$_POST["kalenderid"]);
          }
        }
        while($alterechte = sql_fetch_assoc($alterechteresult))
        {
          @checkrechte("lesen", $alterechte);
          @checkrechte("schreiben", $alterechte);
          @checkrechte("moderieren", $alterechte);
        }

        // id zum besitzernamen finden
        $besitzerresult = sql_select("*", "users", "WHERE username='".$_POST["besitzer"]."'", NULL, NULL);
        if(sql_num_rows($besitzerresult) == 0) fehler("Der Benutzername ist nicht vorhanden!");
        $besitzer = sql_fetch_assoc($besitzerresult);

        $werte = array(
            "titel" => htmlspecialchars($_POST["titel"]),
            "beschreibung" => htmlspecialchars($_POST["beschreibung"]),
            "besitzer_id" => $besitzer["id"],
            "besitzer_name" => $besitzer["username"],
            "privat" => $_POST["privat"]
            );
        sql_update("kalender", $werte, "WHERE id=".$_POST["kalenderid"]);

        redir("index.php?action=admincp&show=kalender", "Die Einstellungen wurden bearbeitet!");
      }
    }
    //***************************** lschen ************************************
    elseif(isset($_POST["kalender_loeschen"]))
    {
      // sicherheitsabfrage, dann lschen
      if(!isset($_POST["bestaetigen_knopf"]))
      {
        // formular mit besttigungsknopf anzeigen
        $result = sql_select("*", "kalender", "WHERE id=".$_POST["id"], NULL, NULL);
        $ergebnis = sql_fetch_assoc($result);
        ?>
        <h3>Kalender lschen</h3>
        <form method="POST" action="index.php?action=admincp&amp;show=kalender&amp;type=bearbeiten">
        <input name="kalenderid" type="hidden" value="<?php echo $_POST["id"] ?>" />
        <input name="kalender_loeschen" type="hidden" value="1" />
        Sind Sie sicher, dass Sie den Kalender "<?php echo $ergebnis["titel"] ?>" lschen wollen?<br />
        Die enthaltenen Events:<br />
        <input class="inputtext" name="move" type="radio" value="1" />Verschieben in diesen Kalender:
        <select class="inputtext" name="moveid" size="1">
        <?php
        $result = sql_select("*", "kalender", "", NULL, NULL);
        while ($ergebnis = sql_fetch_assoc($result))
        {
          echo "<option value=\"".$ergebnis["id"]."\" />".$ergebnis["id"]." - ".$ergebnis["titel"];
        }
        ?>
        </select><br />
        <input class="inputtext" name="move" type="radio" value="0" checked />Lschen<br />
        <input name="bestaetigen_knopf" type="submit" value="lschen" />
        </form>
        <?php
      }
      else
      {
        // kalender aus der datenbank lschen
        // alle zugehrigen kalender-rechte lschen
        sql_delete("kalenderrechte", "WHERE kalender_id=".$_POST["kalenderid"]);
        
        if($_POST["move"]==1)
        {
          // alle enthaltenen events verschieben
          $werte = array("kalender" => $_POST["moveid"]);
          sql_update("events", $werte, "WHERE kalender=".$_POST["kalenderid"]);
        }
        else
        {
          // alle events des kalenders lschen
          sql_delete("events", "WHERE kalender=".$_POST["kalenderid"]);
        }
        // kalender lschen
        sql_delete("kalender", "WHERE id=".$_POST["kalenderid"]);

        redir("index.php?action=admincp&show=kalender", "Der Kalender wurde gelscht!");
      }
    }
  }
}

?>