<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if ($rechte["kalender"] == false) fehler("Sie besitzen nicht gengend Zugriffsrechte, um diese Seite zu betreten!");
?>
<table class="maintable" width="100%">
<tr>
  <td class="leftnav">
  <b>Kalender:</b>
  <?php
  $weiterekalender = sql_select("*", "kalender", "", NULL, NULL);
  while($weitererkalender = sql_fetch_assoc($weiterekalender))
  {
    $navkalenderrechte = getkalenderrechte($weitererkalender["id"]);
    if($navkalenderrechte["lesen"] == true or $weitererkalender["besitzer_id"] == $user["id"])
    {
      echo "<a href=\"index.php?action=kalender&amp;id=".$weitererkalender["id"]."\">".$weitererkalender["titel"]."</a><br />\n";
    }
  }
  ?>
  </td>
  <td align="center">
<?php
$kalenderrechte = getkalenderrechte($user["id"], $aktkalender["id"]);
if($kalenderrechte["lesen"] == false and $aktkalender["besitzer_id"] != $user["id"]) fehler("Sie besitzen nicht die ntigen Rechte um diese Seite anzuzeigen!");

echo "<h3>".$aktkalender["titel"]."</h3>\n";
echo $aktkalender["beschreibung"]."<br /><br />\n";
echo "Besitzer: ";
// besitzer-info
$besitzerresult = sql_select("*", "users", "WHERE id=".$aktkalender["besitzer_id"], NULL, NULL);
if(sql_num_rows($besitzerresult) != 0)
{
  //user ist in der datenbank
  $besitzer = sql_fetch_assoc($besitzerresult);
  if($besitzer["id"] != 1)
  {
    if($rechte["memberlist"] == true) { ?>
    <a href="index.php?action=userinfo&amp;id=<?php echo $besitzer["id"] ?>"><?php } ?><b><?php echo htmlspecialchars($besitzer["username"]) ?></b><?php if($rechte["memberlist"] == true) { ?></a>
    <?php }
  }
  else
  {
    // Gast
    ?>
    <b><?php echo htmlspecialchars($aktkalender["besitzer_name"]) ?></b> - <i>(Gast)</i>
    <?php
  }
}
else
{
  //gelschter user
  ?>
  <b><?php echo htmlspecialchars($aktkalender["besitzer_name"]) ?></b> - <i>(gelschter Benutzer)</i>
  <?php
}

echo "<br /><br />";

function getdayspermonth($monat, $jahr)
{
  // ist das jahr ein schaltjahr?
  $schaltjahr = false;
  if(is_int($jahr/4)) $schaltjahr = true;
  if(is_int($jahr/100)) $schaltjahr = false;
  if(is_int($jahr/400)) $schaltjahr = true;
  switch($monat)
  {
    case 1: case 3: case 5: case 7: case 8: case 10: case 12:
      $dpm = 31;
      break;
    case 4: case 6: case 9: case 11:
      $dpm = 30;
      break;
    case 2:;
      if($schaltjahr == true)
      {
        $dpm = 29;
      }
      else
      {
        $dpm = 28;
      }
      break;
  }
  return $dpm;
}

if(isset($aktjahr) and !isset($aktmonat) and !isset($akttag))
{
  // jahr anzeigen

  // links fr voriges und nchstes jahr
  $prevlink = "<a class=\"berschriftlink\" href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;jahr=".($aktjahr - 1)."\">&#060</a> ";
  $nextlink = " <a class=\"berschriftlink\" href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."jahr=".($aktjahr + 1)."\">&#062</a>";

  // tabelle anzeigen
  ?>
  <table class="maintable">
  <tr class="rowberschrift">
    <td colspan="4"><b><?php echo $prevlink.$aktjahr.$nextlink ?></b></td>
  </tr>
  <tr>
    <?php
    for($runmonat = 1; $runmonat <= 12; $runmonat++)
    {
      switch($runmonat)
      {
        case 1:  $runmonatname = "Januar"; break;
        case 2:  $runmonatname = "Februar"; break;
        case 3:  $runmonatname = "Mrz"; break;
        case 4:  $runmonatname = "April"; break;
        case 5:  $runmonatname = "Mai"; break;
        case 6:  $runmonatname = "Juni"; break;
        case 7:  $runmonatname = "Juli"; break;
        case 8:  $runmonatname = "August"; break;
        case 9:  $runmonatname = "September"; break;
        case 10: $runmonatname = "Oktober"; break;
        case 11: $runmonatname = "November"; break;
        case 12: $runmonatname = "Dezember"; break;
      }

      // 3 monate pro reihe
      switch($runmonat)
      {
        case 4:
        case 7:
        case 10:
          // "zeilenumbruch"
          echo "</tr>";
        case 1:
          // liste der wochentage
          ?>
          <td class="kalender_wochentage"><br /><br /><br />So<br />Mo<br />Di<br />Mi<br />Do<br />Fr<br />Sa</td>
          <?php
      }
      ?>
    <td>
      <table class="maintable">
      <tr class="rowberschrift">
        <?php
        $dpm = getdayspermonth($runmonat, $aktjahr);

        // tabelle anzeigen
        echo "<td colspan=\"7\"><a class=\"berschriftlink\" href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;jahr=".$aktjahr."&amp;monat=".$runmonat."\"><b>".$runmonatname."</b></a></td>\n</tr>\n";
        echo "<tr>\n<td class=\"row2\">\n";
        // ersten tag abfragen
        $erstertag = getdate(mktime(12,0,0,$runmonat,1,$aktjahr));
        $weekday = 0;
        while($erstertag["wday"] != $weekday)
        {
          echo "&nbsp<br />";
          $weekday++;
        }
        $monthday = 1;
        while($monthday <= $dpm)
        {
          echo "<a href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;jahr=".$aktjahr."&amp;monat=".$runmonat."&amp;tag=".$monthday."\">".$monthday."</a><br />";
          if($weekday == 6)
          {
            if($monthday != $dpm)
            {
              echo "\n</td>\n<td class=\"row2\">\n";
            }
            $weekday = -1;
          }
          $monthday++;
          $weekday++;
        }
        if($weekday != 0)
        {
          for($i = $weekday; $i < 7; $i++)
          {
            echo "&nbsp<br />";
          }
        }
        ?>
        </td>
      </tr>
      </table>
    </td>
    <?php
    }
  ?>
  </tr>
  <?php
}
if(isset($aktjahr) and isset($aktmonat) and !isset($akttag))
{
  // monat anzeigen
  ?>
  <table class="maintable">
  <tr class="rowberschrift">
  <?php
  $dpm = getdayspermonth($aktmonat, $aktjahr);

  // links fr vorigen und nchsten monat
  $prevlink["jahr"] = $aktjahr;
  $prevlink["monat"] = $aktmonat - 1;
  if($prevlink["monat"] == 0)
  {
    $prevlink["monat"] = 12;
    $prevlink["jahr"] = $aktjahr - 1;
  }
  $prevlink = "<a class=\"berschriftlink\" href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;jahr=".$prevlink["jahr"]."&amp;monat=".$prevlink["monat"]."\">&#060</a> ";
  $nextlink["jahr"] = $aktjahr;
  $nextlink["monat"] = $aktmonat + 1;
  if($nextlink["monat"] == 13)
  {
    $nextlink["monat"] = 1;
    $nextlink["jahr"] = $aktjahr + 1;
  }
  $nextlink = " <a class=\"berschriftlink\" href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;jahr=".$nextlink["jahr"]."&amp;monat=".$nextlink["monat"]."\">&#062</a>";

  // tabelle anzeigen
  echo "<td colspan=\"7\"><b>".$prevlink.$aktmonatname." ".$aktjahr.$nextlink."</b></td>\n</tr>\n";
  echo "<tr>\n<td>So</td><td>Mo</td><td>Di</td><td>Mi</td><td>Do</td><td>Fr</td><td>Sa</td>\n</tr>\n";
  echo "<tr>\n";
  // ersten tag abfragen
  $erstertag = getdate(mktime(12,0,0,$aktmonat,1,$aktjahr));
  $weekday = 0;
  while($erstertag["wday"] != $weekday)
  {
    echo "<td>&nbsp</td>";
    $weekday++;
  }
  $monthday = 1;
  while($monthday <= $dpm)
  {
    echo "<td><div class=\"kalenderhead\"><a href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;jahr=".$aktjahr."&amp;monat=".$aktmonat."&amp;tag=".$monthday."\">".$monthday."</a></div><div class=\"kalenderbody\">";
    $daseventresult = sql_select("*", "events", "WHERE kalender=".$aktkalender["id"], NULL, NULL);
    while($dasevent = sql_fetch_assoc($daseventresult))
    {
      $ist_heute = false;

      if($dasevent["wiederholung"] != "0")
      {
        // sich wiederholendes event
        // timestamp des ersten tages -> mit getdate() infos holen -> gucken ob aktuell anzuzeigender tag dazu passt
        $startstamp = mktime(0, 0, 0, $dasevent["monat"], $dasevent["tag"], $dasevent["jahr"]);
        $jetztstamp = mktime(12, 0, 0, $aktmonat, $monthday, $aktjahr);
        $startdate = getdate($startstamp);
        $jetztdate = getdate($jetztstamp);

        if($dasevent["wiederholung"] == 1 and $startdate["wday"] == $jetztdate["wday"]) $ist_heute = true;
        if($dasevent["wiederholung"] == 2 and $startdate["mday"] == $jetztdate["mday"]) $ist_heute = true;
        if($dasevent["wiederholung"] == 3 and $startdate["mday"] == $jetztdate["mday"] and $startdate["mon"] == $jetztdate["mon"]) $ist_heute = true;

      }

      if($dasevent["endetag"] != "0" and $dasevent["wiederholung"] == 0)
      {
        // das event geht ber mehrere tage
        // timestamp von 1. u. letzten tag -> gucken ob aktueller timestamp dazwischen
        // bei sich wiederholenden events $startstamp u. $endestamp anpassen

        $startstamp = mktime(0, 0, 0, $dasevent["monat"], $dasevent["tag"], $dasevent["jahr"]);
        $endestamp = mktime(23, 59, 59, $dasevent["endemonat"], $dasevent["endetag"], $dasevent["endejahr"]);
        $jetztstamp = mktime(12, 0, 0, $aktmonat, $monthday, $aktjahr);

        if($startstamp <= $jetztstamp and $endestamp >= $jetztstamp) $ist_heute = true;
      }

      if($dasevent["jahr"] == $aktjahr and $dasevent["monat"] == $aktmonat and $dasevent["tag"] == $monthday) $ist_heute = true;

      if($ist_heute == true) echo "<a href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;jahr=".$aktjahr."&amp;monat=".$aktmonat."&amp;tag=".$monthday."#".$dasevent["id"]."\">".$dasevent["titel"]."</a><br />";
    }
    echo "</div></td>";
    if($weekday == 6)
    {
      if($monthday != $dpm)
      {
        echo "\n</tr>\n<tr>\n";
      }
      $weekday = -1;
    }
    $monthday++;
    $weekday++;
  }
  if($weekday != 0)
  {
    for($i = $weekday; $i < 7; $i++)
    {
      echo "<td>&nbsp</td>";
    }
  }
  echo "\n</tr>\n";
}
if(isset($aktjahr) and isset($aktmonat) and isset($akttag))
{
  // tag anzeigen

  // BB-Code-Parser laden
  include("./bbcode_parser.php");
  $parser = new HTML_BBCodeParser;

  // Smilie-Parser
  include("./smilie_parser.php");

  // alle ereignisse am tag abfragen
  $events = sql_select("*", "events", "WHERE kalender=".$aktkalender["id"]." ORDER BY id ASC", NULL, NULL);

  ?>
  <table class="maintable" width="100%">
  <tr class="rowberschrift">
  <?php
  // links fr vorigen und nchsten tag
  $prevlink["jahr"] = $aktjahr;
  $prevlink["monat"] = $aktmonat;
  $prevlink["tag"] = $akttag - 1;
  if($prevlink["tag"] == 0) $prevlink["monat"] = $aktmonat - 1;
  if($prevlink["monat"] == 0)
  {
    $prevlink["monat"] = 12;
    $prevlink["jahr"] = $aktjahr - 1;
  }
  if($prevlink["tag"] == 0) $prevlink["tag"] = getdayspermonth($prevlink["monat"], $prevlink["jahr"]);
  $prevlink = "<a class=\"berschriftlink\" href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;jahr=".$prevlink["jahr"]."&amp;monat=".$prevlink["monat"]."&amp;tag=".$prevlink["tag"]."\">&#060</a> ";

  $nextlink["jahr"] = $aktjahr;
  $nextlink["monat"] = $aktmonat;
  $nextlink["tag"] = $akttag + 1;
  if($nextlink["tag"] > getdayspermonth($aktmonat, $aktjahr))
  {
    $nextlink["tag"] = 1;
    $nextlink["monat"] = $aktmonat + 1;
  }
  if($nextlink["monat"] == 13)
  {
    $nextlink["monat"] = 1;
    $nextlink["jahr"] = $aktjahr + 1;
  }
  $nextlink = " <a class=\"berschriftlink\" href=\"index.php?action=kalender&amp;id=".$aktkalender["id"]."&amp;jahr=".$nextlink["jahr"]."&amp;monat=".$nextlink["monat"]."&amp;tag=".$nextlink["tag"]."\">&#062</a>";
  ?>
    <td colspan="3"><b><?php echo $prevlink.$akttag.". ".$aktmonatname." ".$aktjahr.$nextlink ?></b></td>
  </tr>
  <?php
  $zeile = 2;

  while($event = sql_fetch_assoc($events))
  {
    $ist_heute = false;
    if($event["endetag"] != "0")
    {
      // das event geht ber mehrere tage
      // timestamp von 1. u. letzten tag -> gucken ob aktueller timestamp dazwischen
      $startstamp = mktime(0, 0, 0, $event["monat"], $event["tag"], $event["jahr"]);
      $endestamp = mktime(23, 59, 59, $event["endemonat"], $event["endetag"], $event["endejahr"]);
      $jetztstamp = mktime(12, 0, 0, $aktmonat, $akttag, $aktjahr);
      if($startstamp <= $jetztstamp and $endestamp >= $jetztstamp) $ist_heute = true;
    }
    if($event["wiederholung"] != "0" and true == false)
    {
      // sich wiederholendes event
      // timestamp des ersten tages -> mit getdate() infos holen -> gucken ob aktuell anzuzeigender tag dazu passt
      $startstamp = mktime(0, 0, 0, $event["monat"], $event["tag"], $event["jahr"]);
      $jetztstamp = mktime(12, 0, 0, $aktmonat, $akttag, $aktjahr);
      $startdate = getdate($startstamp);

    }

    // einfaches ein-tag-event:
    if($event["jahr"] == $aktjahr and $event["monat"] == $aktmonat and $event["tag"] == $akttag) $ist_heute = true;

    if($ist_heute == true)
    {
      ?>
      <tr class="row<?php echo $zeile ?>">
        <td width="150" class="postautorfeld"><a id="<?php echo $event["id"] ?>"></a>
        <?php
        $autorresult = sql_select("*", "users", "WHERE id=".$event["autor_id"], NULL, NULL);
        if(sql_num_rows($autorresult) != 0)
        {
          //user ist in der datenbank
          $autor = sql_fetch_assoc($autorresult);
          if($autor["id"] != 1)
          {
            if($rechte["memberlist"] == true) { ?>
            <a href="index.php?action=userinfo&amp;id=<?php echo $autor["id"] ?>"><?php } ?><b><?php echo htmlspecialchars($autor["username"]) ?></b><?php if($rechte["memberlist"] == true) { ?></a><?php } ?><br />
            <?php
            // benutzerrang?
            $autorposts = sql_num_rows(sql_select("*", "posts", "WHERE autor_id=".$autor["id"]));
            $autorrank = sql_fetch_assoc(sql_select("*", "userranks", "WHERE minposts<=".$autorposts." ORDER BY minposts DESC", 0, 1));
            echo $autorrank["titel"];
            ?><br />
            <img src="./gfx/userranks/<?php echo $autorrank["icon"] ?>" /><br />
            <br /><br />
            registriert seit: <?php echo date("d.m.Y",$autor["reg_since"] + $zeitoffset) ?><br />
            Posts: <?php echo sql_num_rows(sql_select("*", "posts", "WHERE autor_id=".$autor["id"], NULL, NULL)) ?><br />
            <?php
          }
          else
          {
            // Gast
            ?>
            <b><?php echo htmlspecialchars($event["autor_name"]) ?></b><br />
            <i>Gast</i>
            <?php
          }
        }
        else
        {
          //gelschter user
          ?>
          <b><?php echo htmlspecialchars($event["autor_name"]) ?></b><br />
          <i>gelschter Benutzer</i>
          <?php
        }
        ?>
        </td>
        <td colspan="2" class="postnachrichtfeld"><b><?php echo $event["titel"] ?></b><br />
        <?php
        if($event["bbcode"] == 1)
        {
          $parser->setText($event["beschreibung"]);
          $parser->parse();
          $nachricht = $parser->getParsed();
        }
        else
        {
          $nachricht = $event["beschreibung"];
        }
        if($event["smilies"] == 1)
        {
          $nachricht = parse_smilies($nachricht);
        }
        echo str_replace("\n", "<br />\n", $nachricht) ?></td>
      </tr>
      <tr class="row<?php echo $zeile ?>">
        <td width="150" class="postdatumfeld"><?php echo date("d.m.Y - H:i:s",$event["created"] + $zeitoffset) ?></td>
        <td align="left" class="postlinksfeld">
        <?php
        // modul-links anzeigen
        if(isset($modlinks["userlinks"]))
        {
            foreach($modlinks["userlinks"] as $modtitel => $modlink)
            {
                if($modlink["gast"] == true or $event["autor_id"] != 1)
                {
                    ?>
                    <a href="<?php echo str_replace("{userid}", $event["autor_id"], $modlink) ?>"><?php echo $modtitel ?></a>
                    <?php
                }
            }
        }
        
        <?php } if($rechte["sendmail"] == true) { ?><a class="alignleft" href="index.php?action=sendmail&amp;id=<?php echo $event["autor_id"] ?>">E-Mail</a><?php } ?>
        </td>
        <td  align="right" class="postlinksfeld"><?php
        if ($kalenderrechte["moderieren"] == true or ($event["autor_id"]==$user["id"] and $user["id"] != 1))
        {
          ?><a class="alignright" href="index.php?action=moderate&amp;type=editevent&amp;id=<?php echo $event["id"] ?>">bearbeiten</a><?php
        }
        ?></td>
      </tr>
      <?php
      $zeile++;
      if ($zeile>2) $zeile=1;
    }
  }
}

if(!isset($_GET["show"]))
{
  // legende und aktionen anzeigen
  ?>
  </table>
  <br />
  <table class="maintable" width="100%">
  <tr class="rowberschrift">
    <td align="left"><b>Legende</b></td>
    <td align="right"><b>Aktionen</b></td>
  </tr>
  <tr class="row2">
    <td align="left">&nbsp</td><td align="right"><?php
    if($kalenderrechte["moderieren"] == true)
    {
      ?><a href="index.php?action=moderate&amp;type=editkalender&amp;id=<?php echo $aktkalender["id"] ?>">kalender bearbeiten</a> <?php
    }

    if($kalenderrechte["schreiben"] == true or $aktkalender["besitzer_id"] == $user["id"])
    {
      ?><a href="index.php?action=kalender&amp;id=<?php echo $aktkalender["id"] ?>&amp;show=neu">neues event</a><?php
    }
    ?></td>
  </tr>
  </table>
  <?php
}

if(isset($_GET["show"]) and $_GET["show"] == "neu")
{
  if($kalenderrechte["schreiben"] == false and $aktkalender["besitzer_id"] != $user["id"]) fehler("Sie besitzen keine Schreibrechte fr diesen Kalender!");

  // neues event erstellen
  if(!isset($_POST["erstellen_knopf"]))
  {
    // formular anzeigen
    ?>
    <h3>Neues Event</h3>
    <form name="form1" method="POST" action="index.php?action=kalender&amp;id=<?php echo $aktkalender["id"] ?>&amp;show=neu">
    <table class="maintable">
    <tr class="rowberschrift">
      <td colspan="2"><b>Zeitpunkt</b></td>
    </tr>
    <tr class="row2">
      <td>Datum/Beginn:</td><td><input class="inputtext" name="tag" type="text" size="2" />. <input class="inputtext" name="monat" type="text" size="2" />. <input class="inputtext" name="jahr" type="text" size="4" /> (Tag. Monat. Jahr)</td>
    </tr>
    <tr class="row2">
      <td>Ende (optional):</td><td><input class="inputtext" name="endetag" type="text" size="2" />. <input class="inputtext" name="endemonat" type="text" size="2" />. <input class="inputtext" name="endejahr" type="text" size="4" /> (Tag. Monat. Jahr)</td>
    </tr>
    <tr class="row2">
      <td>Wiederholung:<br />(Datum optional)</td><td>
      <select class="inputtext" name="wiederholung" size="1">
        <option value="0" selected>nie</option>
        <option value="1">wchentlich</option>
        <option value="2">monatlich</option>
        <option value="3">jhrlich</option>
      </select>
      bis zum <input class="inputtext" name="rangedtag" type="text" size="2" />. <input class="inputtext" name="rangedmonat" type="text" size="2" />. <input class="inputtext" name="rangedjahr" type="text" size="4" /></td>
    </tr>
    <tr class="rowberschrift">
      <td colspan="2"><b>Event:</b></td>
    </tr>
    <tr class="row2">
      <td>Titel:</td><td><input class="inputtext" name="titel" type="text" size="40" /></td>
    </tr>
    <tr class="row2">
      <td>BB-Code:</td><td><?php $formname = "form1"; $textname="beschreibung"; include("./bbcode_inputs.php") ?></td>
    </tr>
    <tr class="row2">
      <td>Beschreibung:</td><td><textarea class="inputtext" name="beschreibung" cols="39" rows="15"></textarea></td>
    </tr>
    <tr class="rowberschrift">
      <td colspan="2">Optionen</td>
    </tr>
    <tr class="row2">
      <td>BB-Code aktivieren</td><td><input name="bbcode" type="radio" value="1"<?php if($user["auto_bbcode"] == 1) echo " checked" ?> />Ja <input name="bbcode" type="radio" value="0"<?php if($user["auto_bbcode"] == 0) echo " checked" ?> />Nein</td>
    </tr>
    <tr class="row2">
      <td>Smileys aktivieren</td><td><input name="smilies" type="radio" value="1"<?php if($user["auto_smilies"] == 1) echo " checked" ?> />Ja <input name="smilies" type="radio" value="0"<?php if($user["auto_smilies"] == 0) echo " checked" ?> />Nein</td>
    </tr>
    <tr class="row2">
      <td>&nbsp</td><td><input name="erstellen_knopf" type="submit" value="erstellen" /></td>
    </tr>
    </table>
    </form>
    <?php
  }
  else
  {
    // speichern
    if(trim($_POST["titel"]) == "") fehler("Jedes Event muss einen Titel haben!");
    if(trim($_POST["beschreibung"]) == "") fehler("Jedes Event muss eine Beschreibung haben!");
    if(trim($_POST["tag"]) == "" or trim($_POST["monat"]) == "" or trim($_POST["jahr"]) == "") fehler("Sie mssen ein vollstndiges Start-Datum angeben!");

    // falls einige felder leer sind mit 0 "auffllen"
    if($_POST["endetag"] == "") $ende["tag"] = 0; else $ende["tag"] = $_POST["endetag"];
    if($_POST["endemonat"] == "") $ende["monat"] = 0; else $ende["monat"] = $_POST["endemonat"];
    if($_POST["endejahr"] == "") $ende["jahr"] = 0; else $ende["jahr"] = $_POST["endejahr"];
    if($_POST["rangedtag"] == "") $ranged["tag"] = 0; else $ranged["tag"] = $_POST["rangedtag"];
    if($_POST["rangedmonat"] == "") $ranged["monat"] = 0; else $ranged["monat"] = $_POST["rangedmonat"];
    if($_POST["rangedjahr"] == "") $ranged["jahr"] = 0; else $ranged["jahr"] = $_POST["rangedjahr"];

    $werte = array(
        "titel"        => $_POST["titel"],
        "beschreibung" => $_POST["beschreibung"],
        "kalender"     => $aktkalender["id"],
        "autor_id"     => $user["id"],
        "autor_name"   => $user["username"],
        "tag"          => $_POST["tag"],
        "monat"        => $_POST["monat"],
        "jahr"         => $_POST["jahr"],
        "endetag"      => $ende["tag"],
        "endemonat"    => $ende["monat"],
        "endejahr"     => $ende["jahr"],
        "rangedtag"    => $ranged["tag"],
        "rangedmonat"  => $ranged["monat"],
        "rangedjahr"   => $ranged["jahr"],
        "wiederholung" => $_POST["wiederholung"],
        "created"      => time(),
        "bbcode"       => $_POST["bbcode"],
        "smilies"      => $_POST["smilies"]
        );
    sql_insert("events", $werte);

    $event = sql_fetch_assoc(sql_select("*", "events", "ORDER BY id DESC", NULL, NULL));

    redir("index.php?action=kalender&id=".$aktkalender["id"]."&jahr=".$_POST["jahr"]."&monat=".$_POST["monat"]."&tag=".$_POST["tag"]."#".$event["id"], "Das Event wurde erstellt!");
  }
}
?>

</td>
</tr>
</table>