<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

if(modzugriff($modul["id"]) == false) fehler("Sie haben nicht die ntigen Zugriffsrechte, um diese Seite anzzeigen!");

if(!isset($_GET["type"]))
{
    ?>
    <h3>Eigene Blogs:</h3>
    <table class="maintable">
    <tr class="rowberschrift">
        <td>Private Blogs</td>
    </tr>
    <?php
    $blogresult = sql_select("*", "blogs_blogs", "WHERE besitzer_id=".$user["id"]." and privat=1");
    
    if(sql_num_rows($blogresult) == 0)
    {
        ?>
        <tr class="row2">
            <td class="liste"><a href="index.php?action=usercc&amp;show=mod&amp;mod=blogs&amp;type=installieren">installieren</a></td>
        </tr>
        <?php
    }
    else
    {
        $zeile = 2;
        while($blog = sql_fetch_assoc($blogresult))
        {
            ?>
            <tr class="row<?php echo $zeile ?>">
                <td class="liste"><a href="index.php?action=usercc&amp;show=mod&amp;mod=blogs&amp;type=bearbeiten&amp;id=<?php echo $blog["id"] ?>"><?php echo $blog["titel"] ?></td>
            </tr>
            <?php
        }
    }
    ?>
    <tr class="rowberschrift">
        <td>Allgemeine Blogs</td>
    </tr>
    <?php
    $blogresult = sql_select("*", "blogs_blogs", "WHERE besitzer_id=".$user["id"]." and privat=0");
    
    $zeile = 2;
    while($blog = sql_fetch_assoc($blogresult))
    {
        ?>
        <tr class="row<?php echo $zeile ?>">
            <td class="liste"><a href="index.php?action=usercc&amp;show=mod&amp;mod=blogs&amp;type=bearbeiten&amp;id=<?php echo $blog["id"] ?>"><?php echo $blog["titel"] ?></td>
        </tr>
        <?php
    }
    ?>
    </table>
    <?php
}
elseif($_GET["type"] == "installieren")
{
    if(sql_num_rows(sql_select("*", "blogs_blogs",  "WHERE besitzer_id=".$user["id"]." AND privat=1")) != 0) fehler("Sie haben bereits ein privates Blog!");
    // neues blog erstellen
    $werte = array(
        "titel" => $user["username"]."s Blog",
        "beschreibung" => "Mein privates Blog",
        "besitzer_id" => $user["id"],
        "besitzer_name" => $user["username"],
        "privat" => 1
        );
    sql_insert("blogs_blogs", $werte);
    
    redir("index.php?action=usercc&show=mod&mod=blogs", "Ihr privates Blog wurde installiert!");
}
elseif($_GET["type"] == "bearbeiten")
{
    if(!isset($_POST["bearbeiten"]) and !isset($_POST["loeschen"]) and !isset($_POST["loeschen_bestaetigen"]))
    {
        // bearbeiten-formular
        //bisherige einstellungen abfragen:
        $blog = sql_fetch_assoc(sql_select("*", "blogs_blogs", "WHERE id=".$_GET["id"]." AND besitzer_id=".$user["id"]));
        
        $blogrechteresult = sql_select("*", "blogs_rechte", "WHERE blog_id=".$blog["id"]);
        $lesen[] = 0; $schreiben[] = 0; $moderieren[] = 0;
        while($blogrechte = sql_fetch_assoc($blogrechteresult))
        {
            if($blogrechte["lesen"]      == 1) $lesen[]      = $blogrechte["gruppe_id"];
            if($blogrechte["schreiben"]  == 1) $schreiben[]  = $blogrechte["gruppe_id"];
            if($blogrechte["moderieren"] == 1) $moderieren[] = $blogrechte["gruppe_id"];
        }
        ?>
        <h3>Blog bearbeiten</h3>
        <form method="POST" action="index.php?action=usercc&amp;show=mod&amp;mod=blogs&amp;type=bearbeiten">
        <input name="id" type="hidden" value="<?php echo $blog["id"] ?>" />
        <table class="maintable">
        <tr class="rowberschrift">
            <td colspan="2">Allgemeines</td>
        </tr>
        <tr class="row2">
            <td>Beschreibung:</td><td><input class="inputtext" name="beschreibung" type="text" size="40" value="<?php echo $blog["beschreibung"] ?>" /></td>
        </tr>
        <tr class="rowberschrift">
            <td colspan="2">Rechte</td>
        </tr>
        <tr class="row2">
            <td>Lesen:</td><td><select multiple class="inputtext" name="lesen[]" size="5">
            <?php
            // welche gruppen gibt es?
            $gruppenresult = sql_select("id, titel", "gruppen ORDER BY id ASC");
            while($gruppen = sql_fetch_assoc($gruppenresult))
            {
                echo "<option value=\"".$gruppen["id"]."\"";
                if(in_array($gruppen["id"],$lesen))
                {
                    echo "selected";
                }
                echo ">".$gruppen["titel"]."</option>";
            }
            ?>
            </select></td>
        </tr>
        <tr class="row2">
            <td>Schreiben:</td><td><select multiple class="inputtext" name="schreiben[]" size="5">
            <?php
            // welche gruppen gibt es?
            $gruppenresult = sql_select("id, titel", "gruppen ORDER BY id ASC");
            while($gruppen = sql_fetch_assoc($gruppenresult))
            {
                echo "<option value=\"".$gruppen["id"]."\"";
                if(in_array($gruppen["id"],$schreiben))
                {
                    echo "selected";
                }
                echo ">".$gruppen["titel"]."</option>";
            }
            ?>
            </select></td>
        </tr>
        <tr class="row2">
            <td>Moderieren:</td><td><select multiple class="inputtext" name="moderieren[]" size="5">
            <?php
            // welche gruppen gibt es?
            $gruppenresult = sql_select("id, titel", "gruppen ORDER BY id ASC");
            while($gruppen = sql_fetch_assoc($gruppenresult))
            {
                echo "<option value=\"".$gruppen["id"]."\"";
                if(in_array($gruppen["id"],$moderieren))
                {
                    echo "selected";
                }
                echo ">".$gruppen["titel"]."</option>";
            }
            ?>
            </select></td>
        </tr>
        <tr class="row2">
            <td>&nbsp</td><td><input name="bearbeiten" type="submit" value="bearbeiten" /> <?php if($blog["privat"] == 1) { ?><input name="loeschen" type="submit" value="lschen" /><?php } ?></td>
        </tr>
        </table>
        </form>
        <?php
    }
    if(isset($_POST["bearbeiten"]))
    {
        // nderungen speichern
        // berprfen, ob der user auch der besitzer ist
        if(sql_num_rows(sql_select("*", "blogs_blogs", "WHERE id=".$_POST["id"]." AND besitzer_id=".$user["id"])) == 0) fehler("Sie sind nicht der Besitzer des zu bearbeitenden Blogs!");
        
        // datenbank-eintrag aktualisieren
        if(trim($_POST["beschreibung"]) == "") fehler("Jedes Blog muss eine Beschreibung haben!");
        
        // wenn eine gruppe, die in $_POST["lesen"] ist, noch nicht in der tabelle ist -> hinzufgen
        function checkgroups($value, $key)
        {
            if(sql_num_rows(sql_select("gruppe_id", "blogs_rechte", "WHERE blog_id=".$_POST["id"]." AND gruppe_id=".$value)) == 0)
            {
                $werte = array("gruppe_id" => $value, "blog_id" => $_POST["id"]);
                sql_insert("blogs_rechte", $werte);
            }
        }
        @array_walk($_POST["lesen"],      'checkgroups');
        @array_walk($_POST["schreiben"],  'checkgroups');
        @array_walk($_POST["moderieren"], 'checkgroups');
        
        // jede gruppe durchgehen
        $alterechteresult = sql_select("*", "blogs_rechte", "WHERE blog_id=".$_POST["id"]);
        function checkrechte($recht, $alterechte)
        {
            global $alterechte;
            // wenn diese gruppe ein recht hat -> aktualisieren
            if(in_array($alterechte["gruppe_id"],$_POST[$recht]))
            {
                $werte = array($recht => 1);
                sql_update("blogs_rechte", $werte, "WHERE gruppe_id=".$alterechte["gruppe_id"]." AND blog_id=".$_POST["id"]);
            }
            else
            {
                $werte = array($recht => 0);
                sql_update("blogs_rechte", $werte, "WHERE gruppe_id=".$alterechte["gruppe_id"]." AND blog_id=".$_POST["id"]);
            }
        }
        while($alterechte = sql_fetch_assoc($alterechteresult))
        {
            @checkrechte("lesen",      $alterechte);
            @checkrechte("schreiben",  $alterechte);
            @checkrechte("moderieren", $alterechte);
        }
        
        $werte = array(
            "beschreibung"  => htmlspecialchars($_POST["beschreibung"])
            );
        sql_update("blogs_blogs", $werte, "WHERE id=".$_POST["id"]);
        
        redir("index.php?action=usercc&show=mod&mod=blogs", "Die Einstellungen wurden bearbeitet!");
    }
    if(isset($_POST["loeschen"]))
    {
        // ist es ein privates blog des benutzers ?
        $blog = sql_fetch_assoc(sql_select("*", "blogs_blogs", "WHERE id=".$_POST["id"]));
        if($blog["besitzer_id"] != $user["id"]) fehler("Sie sind nicht der Besitzer des Blogs!");
        if($blog["privat"] == 0) fehler("Sie knnen nur private Blogs lschen!");
        
        // sicherheitsabfrage
        ?>
        <form method="POST" action="index.php?action=usercc&amp;show=mod&amp;mod=blogs&amp;type=bearbeiten">
        <input name="id" type="hidden" value="<?php echo $blog["id"] ?>" />
        Sind Sie sicher, dass Sie Ihr privates Blog und alle enthaltenen Posts lschen wollen?<br />
        <input name="loeschen_bestaetigen" type="submit" value="lschen" />
        </form>
        <?php
    }
    if(isset($_POST["loeschen_bestaetigen"]))
    {
        // blog aus db entfernen
        $blogresult = sql_select("*", "blogs_blogs", "WHERE besitzer_id=".$user["id"]." AND privat=1 AND id=".$_POST["id"]);
        if(sql_num_rows($blogresult) == 0) fehler("Das Blog ist nicht installiert oder nicht Ihr privates Blog!");
        // blog-id herausfinden
        $blog = sql_fetch_assoc($blogresult);
        // blog-rechte lschen
        sql_delete("blogs_rechte", "WHERE blog_id=".$blog["id"]);
        // alle posts lschen
        sql_delete("blogs_posts", "WHERE blog=".$blog["id"]);
        // blog lschen
        sql_delete("blogs_blogs", "WHERE id=".$blog["id"]);
        
        redir("index.php?action=usercc&show=mod&mod=blogs", "Ihr privates Blog und alle enthaltenen Posts wurden gelscht!");
    }
}
?>