<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// mini-statistik:
$newestuser = sql_fetch_assoc(sql_select("id, username", "users", "WHERE id!=1 ORDER BY reg_since", 0, 1));
$statistik["boards"]     = sql_num_rows(sql_select("id", "boards", ""));
$statistik["threads"]    = sql_num_rows(sql_select("id", "threads", ""));
$statistik["posts"]      = sql_num_rows(sql_select("id", "posts", ""));
$statistik["users"]      = sql_num_rows(sql_select("id", "users", "")) - 1; // Gast abziehen
$statistik["newestuser"] = $newestuser["username"];
if($rechte["memberlist"] == true)
{
  $statistik["newestuserlink"] = "index.php?action=userinfo&amp;id=".$newestuser["id"];
}

if(isset($_GET["action"]) and $_GET["action"] == "statistik")
{
  // zustzlich ausfhrliche statistik:
  // noch als installation-zeitpunkt den reg_since von Gast nehmen
  $gastuser        = sql_fetch_assoc(sql_select("reg_since", "users", "WHERE id=1"));
  $highestuserid   = sql_fetch_assoc(sql_select("id", "users", "ORDER BY id DESC", 0, 1));
  $highestthreadid = sql_fetch_assoc(sql_select("id", "threads", "ORDER BY id DESC", 0, 1));
  $highestpostid   = sql_fetch_assoc(sql_select("id", "posts", "ORDER BY id DESC", 0, 1));
  $statistik["installiertseit"]     = $gastuser["reg_since"] + $zeitoffset;
  $statistik["totalregistrations"]  = $highestuserid["id"] - 1; // Gast abziehen
  $statistik["registrationsperday"] = round(($highestuserid["id"] - 1) / $statistik["installiertseit"] * 86400, 2); // 86400 sekunden pro tag
  $statistik["totalthreads"]        = $highestthreadid["id"];
  if($statistik["totalthreads"] == null) $statistik["totalthreads"] = "n/a";
  $statistik["threadsperday"]       = round($highestthreadid["id"] / $statistik["installiertseit"] * 86400, 2);
  $statistik["totalposts"]          = $highestpostid["id"];
  if($statistik["totalposts"] == null) $statistik["totalposts"] = "n/a";
  $statistik["postsperday"]         = round($highestpostid["id"] / $statistik["installiertseit"] * 86400, 2);
}
include("./layouts/".$layout."/statistik.php");
?>