<?php
/*
 * DasForum - a PHP BulletinBoardSystem
 * Copyright 2005 Heiko Rothkranz <heiko_rothkranz (at) arcor (dot) de>
 * 
 * This file is part of DasForum
 * 
 * DasForum is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DasForum is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DasForum; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

// BB-Code-Parser laden
include("./bbcode_parser.php");
$parser = new HTML_BBCodeParser;

// Smilie-Parser
include("./smilie_parser.php");

// array mit allen ausgabefertigen kategorien erstellen

$katresult = sql_select("*", "kategorien", "ORDER BY sort ASC");

$announcements = sql_select("*", "announcements", "WHERE kategorien!=''");
if(sql_num_rows($announcements) == 0) $announcementarray[] = NULL;
while($announcement = sql_fetch_assoc($announcements))
{
  // alle announcements in ein array stecken
  $announcementarray[] = $announcement;
}

$numkategorien = sql_num_rows($katresult);
for($z = 1; $z <= $numkategorien; $z++)
{
  $katergebnis = sql_fetch_assoc($katresult);

  $kategorien[$z]["id"] = $katergebnis["id"];

  $kategorien[$z]["titel"] = $katergebnis["titel"];
  
  // alle announcements durchgehen und gucken ob was fr diese kategorie dabei ist
  $t = 0;
  $m = 0;
  foreach($announcementarray as $key => $announcement)
  {
    // in dieser kategorie?
    if(in_array($katergebnis["id"], explode(";", $announcement["kategorien"])))
    {
      // ja -> thread- oder mini-typ?
      if($announcement["typ"] == 0)
      {
        // thread-typ -> in den thread-announcement-array stecken
        $kategorien[$z]["threadannouncements"][$t]["id"]    = $announcement["id"];
        $kategorien[$z]["threadannouncements"][$t]["titel"] = $announcement["titel"];
        $kategorien[$z]["threadannouncements"][$t]["link"]  = "index.php?action=announcement&amp;kategorie=".$katergebnis["id"]."&amp;id=".$announcement["id"];
        $t++;
      }
      else
      {
        // mini-typ -> in den mini-announcement-array stecken
        $kategorien[$z]["miniannouncements"][$m]["id"]        = $announcement["id"];
        $kategorien[$z]["miniannouncements"][$m]["titel"]     = $announcement["titel"];
        if($announcement["bbcode"] == 1)
        {
          $parser->setText($announcement["nachricht"]);
          $parser->parse();
          $nachricht = $parser->getParsed();
        }
        else
        {
          $nachricht = $announcement["nachricht"];
        }
        if($announcement["smilies"] == 1)
        {
          $nachricht = parse_smilies($nachricht);
        }
        $kategorien[$z]["miniannouncements"][$m]["nachricht"] = str_replace("\n", "<br />\n", $nachricht);
        $m++;
      }
    }
  }
  
  // array mit allen ausgabefertigen boards erstellen

  $result = sql_select("*", "boards", "WHERE kategorie=".$katergebnis["id"]." ORDER BY sort ASC");

  $numboards = sql_num_rows($result);
  for($i = 1; $i <= $numboards; $i++)
  {
    $ergebnis = sql_fetch_assoc($result);

    $boards[$i]["id"] = $ergebnis["id"];

    $boardrechte = getboardrechte($ergebnis["id"]);
    $boards[$i]["rechte"] = "";
    if($boardrechte["lesen"] == true)      $boards[$i]["rechte"] .= "l ";
    if($boardrechte["posts"] == true)      $boards[$i]["rechte"] .= "t ";
    if($boardrechte["threads"] == true)    $boards[$i]["rechte"] .= "p ";
    if($boardrechte["moderieren"] == true) $boards[$i]["rechte"] .= "m ";

    $boards[$i]["titellink"] = "index.php?action=viewboard&amp;id=".$ergebnis["id"];
    $boards[$i]["titel"] = $ergebnis["titel"];

    $boards[$i]["beschreibung"] = $ergebnis["beschreibung"];

    $threadsresult = sql_select("*", "threads", "WHERE board=".$ergebnis["id"], NULL, NULL);
    $boards[$i]["threads"] = sql_num_rows($threadsresult);

    $numposts = 0;
    $sql="";
    while($thread = sql_fetch_assoc($threadsresult))
    {
      $postsresult = sql_select("*", "posts", "WHERE thread=".$thread["id"], NULL, NULL);
      $numposts += sql_num_rows($postsresult);
      //fr "letzter post": sql-query vorbereiten
      $sql.="thread=".$thread["id"]." OR ";
    }
    $boards[$i]["posts"] = $numposts;

    if($numposts!=0)
    {
      $sql = "WHERE ".$sql."thread=0 ORDER BY id DESC";
      $lastpostresult = sql_select("*", "posts", $sql, NULL, NULL);
      $lastpost = sql_fetch_assoc($lastpostresult);
      $lastthread = sql_fetch_assoc(sql_select("*", "threads", "WHERE id=".$lastpost["thread"], NULL, NULL));
      $boards[$i]["lastpostlink"] = "index.php?action=viewthread&amp;id=".$lastpost["thread"]."#".$lastpost["id"];
      $boards[$i]["lastposttitel"] = $lastthread["titel"];
      $boards[$i]["lastpostdatum"] = date("d.m.Y - H:i:s",$lastpost["created"] + $zeitoffset);
      $userresult = sql_select("*", "users", "WHERE id=".$lastpost["autor_id"], NULL, NULL);
      if($lastpost["autor_id"]!=1 and sql_num_rows($userresult)!=0)
      {
        if($rechte["memberlist"] == true) { $boards[$i]["lastpostautorlink"] = "index.php?action=userinfo&amp;id=".$lastpost["autor_id"]; }
      }
      else
      {
        $boards[$i]["lastpostautorlink"] = "";
      }
      $boards[$i]["lastpostautor"] = htmlspecialchars($lastpost["autor_name"]);
    }
    else
    {
      $boards[$i]["lastpostlink"] = "";
      $boards[$i]["lastposttitel"] = "";
      $boards[$i]["lastpostdatum"] = "";
      $boards[$i]["lastpostautorlink"] = "";
      $boards[$i]["lastpostautor"] = "";
    }
  }

  if(isset($boards)) $kategorien[$z]["boards"] = $boards;
  $boards = NULL;
}

include("./layouts/".$layout."/viewindex.php");
?>