#
# ##################################################################
#
# TOPSYS
#
# agent _P4_0 (TOPSYS) = !e.?a2._P4_1
# agent _P4_1 (TOPSYS) = ?b.P4
# agent P4 (TOPSYS) = (?a2.?b._P4_0 + ?b.(?b._P4_0 + ?c._P4_1))
# agent S1 (TOPSYS) = (?t.!x.!y.S1 + ?r.!a1.!x.?t.!y.S1)
# agent R (TOPSYS) = ?a1.!a2.R
# agent A (TOPSYS) = ?x.!b.?y.!c.A
# net Q (TOPSYS) = (R // A)
# net TOPSYS (TOPSYS) = (P4 // S1 // Q)\a2\c\a1\y\b\x
#
# The system could be described as a chain (please, use fixed font):
#
#          +----+            +--------+            +----+
#  r --->  | S1 | --> a1 --> | R // A | --> a2 --> | P4 | --> e
#  t --->  |    | --> x ---> |  (Q)   | --> b ---> |    |
#          +----+ --> y ---> +--------+ --> c ---> +----+
#
# Formula: EF EX {e!} true
#
# ##################################################################
#

# known model checker's settings
global mc_diagnostic
global mc_automaton
global mc_explain
global mc_minimize
global mc_tracepath
global mc_progress

ccs_read topsys1.ccs
pa_write_process_ccs S1 0
pa_write_process_ccs Q 0
pa_write_process_ccs P4 0
pa_write_process_ccs TOPSYS 0

mc_check_actl_file 0 TOPSYS topsys.actl [expr $mc_automaton | $mc_minimize]

mc_check_actl_file 0 P4 topsys.actl [expr  $mc_automaton | $mc_minimize]
strucval_sync_product P Q MIN_WC1P4 "a2 b c"
versis_wca_minimization 0 P
pa_write_process_ccs MIN_P 0
strucval_sync_product X S1 MIN_P "a1 x y"
versis_wca_minimization 0 X
pa_write_process_ccs MIN_X 0

versis_strong_equivalence 0 MIN_WC1TOPSYS 0 MIN_X
