#  Authors     [Robert Meolic (meolic@uni-mb.si)]
#  Revision    [$Revision: 60 $]
#  Date        [$Date: 2012-07-04 14:30:43 +0200 (sre, 04 jul 2012) $]
#
#  Copyright   [This file is part of EST (Efficient Symbolic Tools).
#               Copyright (C) 2003, 2012
#               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia
#
#               EST is free software; you can redistribute it and/or modify
#               it under the terms of the GNU General Public License as
#               published by the Free Software Foundation; either version 2
#               of the License, or (at your option) any later version.
#
#               EST is distributed in the hope that it will be useful,
#               but WITHOUT ANY WARRANTY; without even the implied warranty of
#               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
#               GNU General Public License for more details.
#
#               You should have received a copy of the GNU General Public
#               License along with this program; if not, write to the Free
#               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
#               Boston, MA 02110-1301 USA.]

global MENU
global MENUITEMS
global MENUBG
global MENUFG

set MENUSTRUCVAL $MENU.strucval
menu $MENUSTRUCVAL -activeborderwidth 1 -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -relief groove -borderwidth 4 -tearoff false
$MENU insert [expr [$MENU index last]] cascade -menu $MENUSTRUCVAL -activebackground #ffffc0 -activeforeground #000040 -font MENUFONT -label "Strucval"

$MENUSTRUCVAL add command  -command menu_strucval_syncProdukt -label "strucval_sync_product"
$MENUSTRUCVAL add separator
$MENUSTRUCVAL add command  -command strucval_about -label "strucval_about"

lappend MENUITEMS $MENUSTRUCVAL
refresh

proc strucval_about {  } {
    global BINDIR

    outline ""
    outline "\#\#\# "
    out "\# "
    strucval_aboutPkg

    set OK ""
    if {[file isfile "/usr/lib/est2ed/strucval.about"]} {
      set OK "OK"
      set f [open "/usr/lib/est2ed/strucval.about" r]
    } else {
      if {[file isfile "$BINDIR/strucval.about"]} {
        set OK "OK"
        set f [open "$BINDIR/strucval.about" r]
      }
    }

    if { $OK == "OK"} {
      while {[gets $f line] >= 0} {
        out "\# "
        outline $line
      }
      outline "\#\#\# "
      close $f
    }
}

# ##########################################################
# FIELD1: Initial string/value
# FIELD2: List of arguments/values (where applicable)
#
# BROWSE types defined in mi.tcl
#
# file%s        filename
# boolean%s     false or true
# term%s        list of given terminals
# optional%s    optional parameter, can be left out
# required%s    required parameter, if empty then use ""
# nonempty%s    required parameter, must not be equal to ""
#
# BROWSE types defined in paDialog.tcl
#
# name%s        sort/process/composition name
# list%s        list of sorts/processes/compositions
#
# BROWSE types defined in versisDialog.tcl
#
# comtype%d     composition type
#
# BROWSE types defined in mcDialog.tcl
#
# form%s        formula
#
# ##########################################################

proc menu_strucval_syncProdukt {  } {
    global NAME
    global SYNOPSIS
    global SYNTAX
    global EXAMPLE
    global EXPLANATION
    global BROWSE
    global CMD
    global CMDEND

    set NAME "strucval_sync_product"
    set SYNOPSIS "Synchronous product between a process and a WCA"
    set SYNTAX "pname%s pname%s pname%s alist%s"
    set EXAMPLE "strucval_sync_product PRODUCT P A \"x y e\""
    set EXPLANATION "Create synchronous product between process P and WCA A"
    set BROWSE [list \
        {nonempty "Product name" 30} \
        {name "Select process" proc} \
        {name "Select WCA" proc} \
        {required "List of internal action names" 30} \
    ]

    set CMD $NAME
    set CMDEND ""

    commonDialog
}
